/*
 * Copyright 2017 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.oauth.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

/**
 * OAuth RefreshToken.
 */
@Entity
@Table(name = "oauthrefreshtoken")
public class RefreshToken implements Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = -9214518032613402956L;

	/** The token id. */
	@Id
	@Column(length = 100)
	private String tokenId;

	/** The token. */
	@Lob
	@Type(type = "org.hibernate.type.MaterializedBlobType")
	private byte[] token;

	/** The authentication. */
	@Lob
	@Type(type = "org.hibernate.type.MaterializedBlobType")
	private byte[] authentication;

	/** The client id. */
	@Column(length = 100, updatable = false)
	private String clientId;

	/** The username. */
	@Column(length = 100, updatable = false)
	private String username;

	/** The expiration. */
	@Temporal(TemporalType.TIMESTAMP)
	private Date expiration;

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public String getId() {
		return tokenId;
	}

	/**
	 * Sets the token id.
	 *
	 * @param tokenId the new token id
	 */
	public void setTokenId(final String tokenId) {
		this.tokenId = tokenId;
	}

	/**
	 * Gets the token id.
	 *
	 * @return the token id
	 */
	public String getTokenId() {
		return tokenId;
	}

	/**
	 * Sets the token.
	 *
	 * @param token the new token
	 */
	public void setToken(final byte[] token) {
		this.token = token;
	}

	/**
	 * Gets the token.
	 *
	 * @return the token
	 */
	public byte[] getToken() {
		return token;
	}

	/**
	 * Sets the authentication.
	 *
	 * @param authentication the new authentication
	 */
	public void setAuthentication(final byte[] authentication) {
		this.authentication = authentication;
	}

	/**
	 * Gets the authentication.
	 *
	 * @return the authentication
	 */
	public byte[] getAuthentication() {
		return authentication;
	}

	/**
	 * Sets the client id.
	 *
	 * @param clientId the new client id
	 */
	public void setClientId(final String clientId) {
		this.clientId = clientId;
	}

	/**
	 * Get the clientId for which this token is issued.
	 *
	 * @return OAuth clientId
	 * @see OAuthClient#getClientId()
	 */
	public String getClientId() {
		return clientId;
	}

	/**
	 * Sets the username.
	 *
	 * @param username the new username
	 */
	public void setUsername(final String username) {
		this.username = username;
	}

	/**
	 * Get the identifier of the user associated with this refresh token.
	 *
	 * @return Usually the UUID of the User
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * Sets the expiration.
	 *
	 * @param expiration the new expiration
	 */
	public void setExpiration(final Date expiration) {
		this.expiration = expiration;
	}

	/**
	 * Gets the expiration.
	 *
	 * @return the expiration
	 */
	public Date getExpiration() {
		return expiration;
	}
}
