/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.service.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.genesys.blocks.security.service.PasswordPolicy;
import org.springframework.stereotype.Component;

@Component
public class SimplePasswordPolicy
implements PasswordPolicy {
    private int minLength = 8;
    private int maxLength = Integer.MAX_VALUE;
    private int minDigits = 1;
    private int minSpecialChars = 1;
    private static final Pattern DIGITS = Pattern.compile("[0-9]");
    private static final Pattern SPECIAL = Pattern.compile("[^0-9a-zA-Z]");

    @Override
    public void assureGoodPassword(String password) throws PasswordPolicy.PasswordPolicyException {
        if (password == null) {
            throw new PasswordPolicy.PasswordPolicyException("Password cannot be null");
        }
        if (password.length() < this.minLength) {
            throw new PasswordPolicy.PasswordPolicyException("Password must be at least " + this.minLength + " characters");
        }
        if (password.length() > this.maxLength) {
            throw new PasswordPolicy.PasswordPolicyException("Password must be at most " + this.maxLength + " characters");
        }
        int digitsCount = 0;
        Matcher matcher = DIGITS.matcher(password);
        while (matcher.find()) {
            ++digitsCount;
        }
        if (digitsCount < this.minDigits) {
            throw new PasswordPolicy.PasswordPolicyException("Password must have at least " + this.minDigits + " number(s)");
        }
        int specialCount = 0;
        matcher = SPECIAL.matcher(password);
        while (matcher.find()) {
            ++specialCount;
        }
        if (specialCount < this.minSpecialChars) {
            throw new PasswordPolicy.PasswordPolicyException("Password must have at least " + this.minSpecialChars + " special character(s)");
        }
    }
}

