/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.genesys.blocks.security.SecurityContextUtil;
import org.genesys.blocks.security.model.AclAwareModel;
import org.genesys.blocks.security.model.AclClass;
import org.genesys.blocks.security.model.AclEntry;
import org.genesys.blocks.security.model.AclObjectIdentity;
import org.genesys.blocks.security.model.AclSid;
import org.genesys.blocks.security.model.BasicUser;
import org.genesys.blocks.security.persistence.AclClassPersistence;
import org.genesys.blocks.security.persistence.AclEntryPersistence;
import org.genesys.blocks.security.persistence.AclObjectIdentityPersistence;
import org.genesys.blocks.security.persistence.AclSidPersistence;
import org.genesys.blocks.security.service.CustomAclService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CustomAclServiceImpl
implements CustomAclService {
    private static Permission[] basePermissions = new Permission[]{BasePermission.CREATE, BasePermission.READ, BasePermission.WRITE, BasePermission.DELETE, BasePermission.ADMINISTRATION};
    @Autowired
    private AclObjectIdentityPersistence aclObjectIdentityPersistence;
    @Autowired
    private AclSidPersistence aclSidPersistence;
    @Autowired
    private AclClassPersistence aclClassPersistence;
    @Autowired
    private AclEntryPersistence aclEntryPersistence;
    @Autowired
    private CacheManager cacheManager;
    private static final Logger LOG = LoggerFactory.getLogger(CustomAclServiceImpl.class);

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void addCreatorPermissions(AclAwareModel target) {
        if (target == null || target.getId() <= 0L) {
            LOG.warn("No target specified for ACL permissions, bailing out!");
            return;
        }
        String uuid = SecurityContextUtil.getUsername();
        if (uuid == null) {
            LOG.warn("No user in security context, not doing ACL");
            return;
        }
        LOG.debug("Inserting owner ACL entries for owner={} class={} id={}", new Object[]{uuid, target.getClass().getName(), target.getId()});
        AclSid aclSid = this.ensureSid(uuid, true);
        AclClass aclClass = this.ensureAclClass(target.getClass().getName());
        AclObjectIdentity objectIdentity = new AclObjectIdentity();
        objectIdentity.setObjectIdIdentity(target.getId());
        objectIdentity.setAclClass(aclClass);
        objectIdentity.setOwnerSid(aclSid);
        objectIdentity.setParentObject(null);
        objectIdentity.setEntriesInheriting(false);
        AclObjectIdentity savedAclObjectIdentity = this.aclObjectIdentityPersistence.findByObjectIdIdentityAndClassName(objectIdentity.getObjectIdIdentity(), objectIdentity.getAclClass().getAclClass());
        if (savedAclObjectIdentity == null) {
            savedAclObjectIdentity = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.save((Object)objectIdentity));
            HashMap<Integer, Boolean> permissionsMap = new HashMap<Integer, Boolean>();
            for (Permission permission : basePermissions) {
                permissionsMap.put(permission.getMask(), true);
            }
            this.addPermissions(aclSid, savedAclObjectIdentity, permissionsMap);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void removePermissions(AclAwareModel target) {
        List<AclEntry> aclEntries;
        AclObjectIdentity savedAclObjectIdentity = this.aclObjectIdentityPersistence.findByObjectIdIdentityAndClassName(target.getId(), target.getClass().getName());
        if (savedAclObjectIdentity != null && (aclEntries = this.aclEntryPersistence.findByObjectIdentity(savedAclObjectIdentity)) != null) {
            this.aclEntryPersistence.delete(aclEntries);
            this.aclObjectIdentityPersistence.delete(savedAclObjectIdentity.getId());
        }
    }

    private void addPermissions(AclSid ownerSid, AclObjectIdentity objectIdentity, Map<Integer, Boolean> permissions) {
        for (Permission permission : basePermissions) {
            int mask = permission.getMask();
            AclEntry aclEntry = new AclEntry();
            aclEntry.setAclObjectIdentity(objectIdentity);
            aclEntry.setAclSid(ownerSid);
            aclEntry.setAceOrder(this.getAceOrder(objectIdentity.getId()));
            aclEntry.setGranting(permissions.get(mask));
            aclEntry.setAuditSuccess(true);
            aclEntry.setAuditFailure(true);
            aclEntry.setMask(mask);
            this.aclEntryPersistence.save((Object)aclEntry);
        }
        Cache aclCache = this.cacheManager.getCache("aclCache");
        if (aclCache != null) {
            aclCache.clear();
        }
    }

    private Long getAceOrder(long aclObjectEntityId) {
        Long maxAceOrder = this.aclEntryPersistence.getMaxAceOrderForObjectEntity(aclObjectEntityId);
        return maxAceOrder != null ? maxAceOrder + 1L : 1L;
    }

    private AclClass ensureAclClass(String className) {
        AclClass aclClass = this.aclClassPersistence.findByAclClass(className);
        if (aclClass == null) {
            LOG.warn("Missing AclClass '{}'", (Object)className);
            aclClass = new AclClass();
            aclClass.setAclClass(className);
            return (AclClass)((Object)this.aclClassPersistence.save((Object)aclClass));
        }
        return aclClass;
    }

    private AclSid ensureSid(String uuid, boolean principal) {
        AclSid aclSid = this.aclSidPersistence.findBySidAndPrincipal(uuid, principal);
        if (aclSid == null) {
            aclSid = new AclSid();
            aclSid.setPrincipal(principal);
            aclSid.setSid(uuid);
            LOG.warn("New SID sid={} principal={}", (Object)aclSid.getSid(), (Object)aclSid.isPrincipal());
            return (AclSid)((Object)this.aclSidPersistence.save((Object)aclSid));
        }
        return aclSid;
    }

    @Override
    @Transactional(readOnly=true)
    public AclObjectIdentity getObjectIdentity(String className, long id) {
        return this.aclObjectIdentityPersistence.findByObjectIdIdentityAndClassName(id, className);
    }

    @Override
    @Transactional(readOnly=true)
    public AclObjectIdentity getObjectIdentity(long id) {
        return (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.findOne(Long.valueOf(id)));
    }

    @Override
    @Transactional(readOnly=true)
    public AclObjectIdentity getObjectIdentity(AclAwareModel entity) {
        AclObjectIdentity oid;
        if (entity == null) {
            LOG.error("getObjectIdentity: Entity is null");
        }
        if ((oid = this.aclObjectIdentityPersistence.findByObjectIdIdentityAndClassName(entity.getId(), entity.getClass().getName())) == null) {
            LOG.warn("ACL object identity not found for class={} id={}", (Object)entity.getClass().getName(), (Object)entity.getId());
        }
        return oid;
    }

    @Override
    @Transactional(readOnly=true)
    public Permission[] getAvailablePermissions(String className) {
        return basePermissions;
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#id, #className, 'ADMINISTRATION')")
    public Map<String, Map<Integer, Boolean>> getPermissions(long id, String className) {
        HashMap<String, Map<Integer, Boolean>> perm = new HashMap<String, Map<Integer, Boolean>>();
        List<AclEntry> aclEntries = this.getAclEntries(this.getObjectIdentity(className, id));
        for (AclEntry aclEntry : aclEntries) {
            HashMap<Integer, Boolean> granted = (HashMap<Integer, Boolean>)perm.get(aclEntry.getAclSid().getSid());
            if (granted == null) {
                granted = new HashMap<Integer, Boolean>();
                perm.put(aclEntry.getAclSid().getSid(), granted);
            }
            granted.put((int)aclEntry.getMask(), aclEntry.isGranting());
        }
        return perm;
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity, 'ADMINISTRATION')")
    public Map<String, Map<Integer, Boolean>> getPermissions(AclAwareModel entity) {
        return this.getPermissions(entity.getId(), entity.getClass().getName());
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity.aclClass.id, #entity.aclClass.aclClass, 'ADMINISTRATION')")
    public void updatePermission(AclObjectIdentity entity, String sid, Map<Integer, Boolean> permissionMap) {
        boolean oneGranting = false;
        List<AclEntry> aclEntries = this.aclEntryPersistence.findBySidAndAclClass(sid, entity.getAclClass().getAclClass());
        for (AclEntry aclEntry : aclEntries) {
            aclEntry.setGranting(permissionMap.get((int)aclEntry.getMask()));
            oneGranting |= aclEntry.isGranting();
        }
        if (oneGranting) {
            LOG.info("Saving " + aclEntries);
            this.aclEntryPersistence.save(aclEntries);
        } else {
            LOG.info("Deleting " + aclEntries);
            this.aclEntryPersistence.delete(aclEntries);
        }
        this.cacheManager.getCache("aclCache").clear();
    }

    @Override
    @Transactional(readOnly=true)
    public List<AclEntry> getAclEntries(AclObjectIdentity objectIdentity) {
        return this.aclEntryPersistence.findByObjectIdentity(objectIdentity);
    }

    @Override
    @Transactional(readOnly=true)
    public List<AclEntry> getAclEntries(AclAwareModel entity) {
        return this.aclEntryPersistence.findByObjectIdentity(this.getObjectIdentity(entity));
    }

    @Override
    @Transactional(readOnly=true)
    public List<AclSid> getSids(long id, String className) {
        return this.aclEntryPersistence.getSids(id, className);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#entity, 'ADMINISTRATION')")
    public List<AclSid> getSids(AclAwareModel entity) {
        return this.aclEntryPersistence.getSids(entity.getId(), entity.getClass().getName());
    }

    @Override
    @Transactional(readOnly=true)
    public List<AclSid> getAllSids() {
        return this.aclSidPersistence.findAll();
    }

    @Override
    @PreAuthorize(value="hasRole('ADMINISTRATOR') or hasPermission(#objectIdIdentity, #className, 'ADMINISTRATION')")
    public boolean addPermissions(long objectIdIdentity, String className, String uuid, boolean principal, Map<Integer, Boolean> permissions) {
        AclSid sid = this.ensureSid(uuid, principal);
        AclObjectIdentity oid = this.ensureObjectIdentity(className, objectIdIdentity);
        this.addPermissions(sid, oid, permissions);
        return true;
    }

    @Override
    @Transactional
    public AclObjectIdentity ensureObjectIdentity(String className, long objectIdIdentity) {
        AclObjectIdentity aoi = this.aclObjectIdentityPersistence.findByObjectIdIdentityAndClassName(objectIdIdentity, className);
        if (aoi == null) {
            aoi = new AclObjectIdentity();
            aoi.setObjectIdIdentity(objectIdIdentity);
            aoi.setAclClass(this.ensureAclClass(className));
            String uuid = ((BasicUser)((Object)SecurityContextUtil.getMe())).getUuid();
            AclSid ownerSid = this.ensureSid(uuid, true);
            aoi.setOwnerSid(ownerSid);
            aoi = (AclObjectIdentity)((Object)this.aclObjectIdentityPersistence.save((Object)aoi));
        }
        return aoi;
    }

    @Override
    public List<Integer> permissionsBySid(String className, Long id, String sid) {
        Map<String, Map<Integer, Boolean>> map = this.getPermissions(id, className);
        Map<Integer, Boolean> permissionMap = map.get(sid);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map.Entry<Integer, Boolean> e : permissionMap.entrySet()) {
            Integer key = e.getKey();
            Boolean value = e.getValue();
            if (!value.booleanValue()) continue;
            list.add(key);
        }
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> listIdentitiesForSid(Class<? extends AclAwareModel> clazz, UserDetails authUser, Permission permission) {
        return this.aclEntryPersistence.findObjectIdentitiesBySidAndAclClassAndMask(authUser.getUsername(), clazz.getName(), permission.getMask());
    }
}

