/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.persistence;

import java.util.List;
import org.genesys.blocks.security.model.AclEntry;
import org.genesys.blocks.security.model.AclObjectIdentity;
import org.genesys.blocks.security.model.AclSid;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface AclEntryPersistence
extends JpaRepository<AclEntry, Long> {
    @Query(value="select ae from AclEntry ae where ae.aclObjectIdentity = :aclObjectIdentity")
    public List<AclEntry> findByObjectIdentity(@Param(value="aclObjectIdentity") AclObjectIdentity var1);

    @Query(value="select ae from AclEntry ae join ae.aclObjectIdentity aoi join aoi.aclClass ac join ae.aclSid sid where aoi.objectIdIdentity=?1 and ac.aclClass=?2 and sid.sid=?3")
    public List<AclEntry> findByObjectIdentityAndObjectClassIdAndSid(long var1, String var3, String var4);

    @Query(value="select ae from AclEntry ae join ae.aclObjectIdentity aoi join aoi.aclClass ac join ae.aclSid sid where sid.sid=?1 and ac.aclClass=?2")
    public List<AclEntry> findBySidAndAclClass(String var1, String var2);

    @Query(value="select count(ae) from AclEntry ae join ae.aclObjectIdentity aoi join aoi.aclClass ac join ae.aclSid sid where sid.sid=?1 and aoi.objectIdIdentity=?2 and ae.mask=?3 and ac.aclClass=?4")
    public Long findBySidAndObjectIdentityAndMask(String var1, long var2, long var4, String var6);

    @Query(value="select aoi.objectIdIdentity from AclEntry ae join ae.aclObjectIdentity aoi join aoi.aclClass ac join ae.aclSid sid where sid.sid=?1 and ac.aclClass=?2 and ae.mask=?3")
    public List<Long> findObjectIdentitiesBySidAndAclClassAndMask(String var1, String var2, long var3);

    @Query(value="select max(ae.aceOrder) from AclEntry ae join ae.aclObjectIdentity aoi where aoi.id = ?1")
    public Long getMaxAceOrderForObjectEntity(long var1);

    @Query(value="select distinct ae.aclSid from AclEntry ae join ae.aclObjectIdentity aoi join aoi.aclClass ac where aoi.objectIdIdentity = :objectIdIdentity and ac.aclClass = :aclClass")
    public List<AclSid> getSids(@Param(value="objectIdIdentity") long var1, @Param(value="aclClass") String var3);
}

