/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.genesys.blocks.model.AuditedVersionedModel;
import org.genesys.blocks.model.JsonViews;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@MappedSuperclass
public abstract class BasicUser<R extends GrantedAuthority>
extends AuditedVersionedModel
implements UserDetails {
    private static final long serialVersionUID = -5318892732608111516L;
    @Column(length=36, unique=true)
    private String uuid;
    @JsonView(value={JsonViews.Public.class})
    @Column(nullable=false, unique=true, length=60)
    private String email;
    @JsonView(value={JsonViews.Public.class})
    @Column(unique=true, length=20)
    private String shortName;
    @JsonView(value={JsonViews.Public.class})
    @Column(length=60)
    private String fullName;
    @JsonIgnore
    @Column(length=60)
    private String password;
    @JsonView(value={JsonViews.Internal.class})
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date accountExpires;
    @JsonView(value={JsonViews.Internal.class})
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lockedUntil;
    @JsonView(value={JsonViews.Internal.class})
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date passwordExpires;
    @JsonView(value={JsonViews.Protected.class})
    @ElementCollection(fetch=FetchType.EAGER)
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="userrole", joinColumns={@JoinColumn(name="userId")})
    @Column(name="role")
    private Set<R> roles = new HashSet<R>();
    @JsonView(value={JsonViews.Protected.class})
    @Enumerated(value=EnumType.STRING)
    @Column(length=20)
    private AccountType accountType = AccountType.LOCAL;

    @PrePersist
    void ensureUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Date getAccountExpires() {
        return this.accountExpires;
    }

    public void setAccountExpires(Date accountExpires) {
        this.accountExpires = accountExpires;
    }

    public Date getLockedUntil() {
        return this.lockedUntil;
    }

    public void setLockedUntil(Date lockedUntil) {
        this.lockedUntil = lockedUntil;
    }

    public Date getPasswordExpires() {
        return this.passwordExpires;
    }

    public void setPasswordExpires(Date passwordExpires) {
        this.passwordExpires = passwordExpires;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<R> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<R> roles) {
        this.roles = roles;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String toString() {
        return MessageFormat.format("id={0} email={1} fullName={2}", this.getId(), this.email, this.fullName);
    }

    @Transient
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.getRoles().stream().map(role -> new SimpleGrantedAuthority(role.getAuthority())).collect(Collectors.toSet());
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.uuid;
    }

    @JsonView(value={JsonViews.Protected.class})
    public boolean isAccountNonExpired() {
        return this.accountExpires == null || !this.accountExpires.before(new Date());
    }

    @JsonView(value={JsonViews.Protected.class})
    public boolean isAccountNonLocked() {
        return this.lockedUntil == null || !this.lockedUntil.after(new Date());
    }

    @JsonView(value={JsonViews.Protected.class})
    public boolean isAccountLocked() {
        return !this.isAccountNonLocked();
    }

    @JsonView(value={JsonViews.Protected.class})
    public boolean isCredentialsNonExpired() {
        return this.passwordExpires == null || !this.passwordExpires.before(new Date());
    }

    @JsonView(value={JsonViews.Protected.class})
    public boolean isEnabled() {
        return super.isActive();
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public static enum AccountType {
        LOCAL,
        LDAP,
        GOOGLE,
        SYSTEM;

    }
}

