/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.genesys.blocks.model.BasicModel;
import org.genesys.blocks.security.model.AclClass;
import org.genesys.blocks.security.model.AclEntry;
import org.genesys.blocks.security.model.AclSid;

@Entity
@Table(name="acl_object_identity", uniqueConstraints={@UniqueConstraint(columnNames={"object_id_class", "object_id_identity"})})
public class AclObjectIdentity
extends BasicModel {
    private static final long serialVersionUID = -8987281958564243010L;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="object_id_class", nullable=false)
    private AclClass aclClass;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="parent_object", nullable=true)
    private AclObjectIdentity parentObject;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="owner_sid", nullable=true)
    private AclSid ownerSid;
    @Column(name="object_id_identity", nullable=false)
    private long objectIdIdentity;
    @Column(name="entries_inheriting", nullable=false, length=1)
    private boolean entriesInheriting;
    @JsonIgnore
    @OneToMany(mappedBy="aclObjectIdentity", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private List<AclEntry> aclEntries;

    public AclClass getAclClass() {
        return this.aclClass;
    }

    public void setAclClass(AclClass aclClass) {
        this.aclClass = aclClass;
    }

    public AclObjectIdentity getParentObject() {
        return this.parentObject;
    }

    public void setParentObject(AclObjectIdentity parentObject) {
        this.parentObject = parentObject;
    }

    public AclSid getOwnerSid() {
        return this.ownerSid;
    }

    public void setOwnerSid(AclSid ownerSid) {
        this.ownerSid = ownerSid;
    }

    public long getObjectIdIdentity() {
        return this.objectIdIdentity;
    }

    public void setObjectIdIdentity(long objectIdIdentity) {
        this.objectIdIdentity = objectIdIdentity;
    }

    public boolean isEntriesInheriting() {
        return this.entriesInheriting;
    }

    public void setEntriesInheriting(boolean entriesInheriting) {
        this.entriesInheriting = entriesInheriting;
    }

    public List<AclEntry> getAclEntries() {
        return this.aclEntries;
    }

    public void setAclEntries(List<AclEntry> aclEntries) {
        this.aclEntries = aclEntries;
    }
}

