/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.security.component;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.genesys.blocks.security.model.AclAwareModel;
import org.genesys.blocks.security.service.CustomAclService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AclAssignerAspect {
    private static final Logger LOG = LoggerFactory.getLogger(AclAssignerAspect.class);
    @Autowired
    private CustomAclService aclService;

    public AclAssignerAspect() {
        LOG.warn("Enabling {}", (Object)this.getClass().getName());
    }

    @AfterReturning(pointcut="execution(* org.springframework.data.repository.*.save(..)) || execution(* org.springframework.data.jpa.repository.*.save(..)) || execution(* org.springframework.data.jpa.repository.*.saveAndFlush(..))", returning="result")
    public Object afterSaveAclObject(Object result) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            if (result instanceof AclAwareModel) {
                this.maybeAddCreatorPermissions(result);
            } else if (result instanceof Iterable) {
                Iterable i = (Iterable)result;
                for (Object o : i) {
                    this.maybeAddCreatorPermissions(o);
                }
            } else {
                LOG.trace("{} is not instance of AclAwareModel", result);
            }
        }
        return result;
    }

    private void maybeAddCreatorPermissions(Object obj) {
        if (obj instanceof AclAwareModel) {
            this.aclService.addCreatorPermissions((AclAwareModel)obj);
        } else {
            LOG.trace("{} is not instance of AclAwareModel", obj);
        }
    }

    @After(value="execution(* org.springframework.data.repository.*.delete(..)) || execution(* org.springframework.data.jpa.repository.*.deleteInBatch(..))")
    public void afterDeleteAclObject(JoinPoint joinPoint) {
        Object arg0 = joinPoint.getArgs()[0];
        if (!(arg0 instanceof Long)) {
            if (arg0 instanceof AclAwareModel) {
                AclAwareModel aclModel = (AclAwareModel)arg0;
                this.maybeRemovePermissions(aclModel);
            } else if (arg0 instanceof Iterable) {
                Iterable i = (Iterable)arg0;
                for (Object o : i) {
                    this.maybeRemovePermissions(o);
                }
            } else {
                LOG.trace("{} is not instance of AclAwareModel", arg0);
            }
        }
    }

    private void maybeRemovePermissions(Object obj) {
        if (obj instanceof AclAwareModel) {
            LOG.debug("Removing ACL entries for model={}", obj);
            this.aclService.removePermissions((AclAwareModel)obj);
        } else {
            LOG.trace("{} is not instance of AclAwareModel", obj);
        }
    }
}

