/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.oauth.service;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.genesys.blocks.oauth.model.AccessToken;
import org.genesys.blocks.oauth.model.OAuthClient;
import org.genesys.blocks.oauth.model.RefreshToken;
import org.genesys.blocks.oauth.persistence.AccessTokenRepository;
import org.genesys.blocks.oauth.persistence.OAuthClientRepository;
import org.genesys.blocks.oauth.persistence.RefreshTokenRepository;
import org.genesys.blocks.oauth.service.OAuthClientDetailsService;
import org.genesys.blocks.oauth.service.OAuthTokenStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.util.SerializationUtils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.DefaultAuthenticationKeyGenerator;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=false)
public class OAuthServiceImpl
implements OAuthClientDetailsService,
OAuthTokenStoreService {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthServiceImpl.class);
    @Autowired
    private OAuthClientRepository oauthClientRepository;
    @Autowired
    private RefreshTokenRepository refreshTokenRepository;
    @Autowired
    private AccessTokenRepository accessTokenRepository;
    private AuthenticationKeyGenerator authenticationKeyGenerator = new DefaultAuthenticationKeyGenerator();

    public void setAuthenticationKeyGenerator(AuthenticationKeyGenerator authenticationKeyGenerator) {
        this.authenticationKeyGenerator = authenticationKeyGenerator;
    }

    @Cacheable(cacheNames={"oauthclient"}, key="#clientId", unless="#result == null")
    public ClientDetails loadClientByClientId(String clientId) throws ClientRegistrationException {
        OAuthClient client = this.oauthClientRepository.findByClientId(clientId);
        if (client == null) {
            throw new NoSuchClientException(clientId);
        }
        client.getRoles().size();
        return client;
    }

    @CacheEvict(cacheNames={"oauthaccesstoken", "oauthaccesstokenauth"}, allEntries=true)
    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        String refreshToken = null;
        if (token.getRefreshToken() != null) {
            refreshToken = token.getRefreshToken().getValue();
        }
        if (this.readAccessToken(token.getValue()) != null) {
            this.removeAccessToken(token.getValue());
        }
        this.accessTokenRepository.deleteByAuthenticationId(this.authenticationKeyGenerator.extractKey(authentication));
        AccessToken storedToken = new AccessToken();
        storedToken.setTokenId(this.extractTokenKey(token.getValue()));
        storedToken.setToken(this.serializeAccessToken(token));
        storedToken.setAuthenticationId(this.authenticationKeyGenerator.extractKey(authentication));
        storedToken.setUsername(authentication.isClientOnly() ? null : authentication.getName());
        storedToken.setClientId(authentication.getOAuth2Request().getClientId());
        storedToken.setAuthentication(this.serializeAuthentication(authentication));
        storedToken.setRefreshToken(this.extractTokenKey(refreshToken));
        this.accessTokenRepository.save(storedToken);
    }

    @Cacheable(cacheNames={"oauthaccesstoken"}, key="#tokenValue", unless="#result == null")
    public OAuth2AccessToken readAccessToken(String tokenValue) {
        OAuth2AccessToken accessToken = null;
        LOG.trace("Reading access token value={} key={}", (Object)tokenValue, (Object)this.extractTokenKey(tokenValue));
        AccessToken storedToken = (AccessToken)this.accessTokenRepository.findOne((Serializable)((Object)this.extractTokenKey(tokenValue)));
        if (storedToken != null) {
            accessToken = this.deserializeAccessToken(storedToken.getToken());
        } else if (LOG.isInfoEnabled()) {
            LOG.info("Failed to find access token for token " + tokenValue);
        }
        return accessToken;
    }

    @CacheEvict(cacheNames={"oauthaccesstoken", "oauthaccesstokenauth"}, allEntries=true)
    public void removeAccessToken(OAuth2AccessToken token) {
        this.removeAccessToken(token.getValue());
    }

    @CacheEvict(cacheNames={"oauthaccesstoken", "oauthaccesstokenauth"}, allEntries=true)
    public void removeAccessToken(String tokenValue) {
        this.accessTokenRepository.delete((Serializable)((Object)this.extractTokenKey(tokenValue)));
    }

    @Cacheable(cacheNames={"oauthaccesstokenauth"}, key="#token.value", unless="#result == null")
    public OAuth2Authentication readAuthentication(OAuth2AccessToken token) {
        return this.readAuthentication(token.getValue());
    }

    @Cacheable(cacheNames={"oauthaccesstokenauth"}, key="#tokenValue", unless="#result == null")
    public OAuth2Authentication readAuthentication(String tokenValue) {
        OAuth2Authentication authentication = null;
        LOG.trace("TokenValue={} key={}", (Object)tokenValue, (Object)this.extractTokenKey(tokenValue));
        AccessToken storedToken = (AccessToken)this.accessTokenRepository.findOne((Serializable)((Object)this.extractTokenKey(tokenValue)));
        if (storedToken != null) {
            authentication = this.deserializeAuthentication(storedToken.getAuthentication());
        } else if (LOG.isInfoEnabled()) {
            LOG.info("Failed to find access token for token " + tokenValue);
        }
        return authentication;
    }

    @CacheEvict(cacheNames={"oauthaccesstoken", "oauthaccesstokenauth"}, allEntries=true)
    public void storeRefreshToken(OAuth2RefreshToken refreshToken, OAuth2Authentication authentication) {
        RefreshToken storedToken = new RefreshToken();
        storedToken.setTokenId(this.extractTokenKey(refreshToken.getValue()));
        storedToken.setToken(this.serializeRefreshToken(refreshToken));
        storedToken.setAuthentication(this.serializeAuthentication(authentication));
        this.refreshTokenRepository.save(storedToken);
    }

    public OAuth2RefreshToken readRefreshToken(String token) {
        OAuth2RefreshToken refreshToken = null;
        RefreshToken storedToken = (RefreshToken)this.refreshTokenRepository.findOne((Serializable)((Object)this.extractTokenKey(token)));
        if (storedToken != null) {
            refreshToken = this.deserializeRefreshToken(storedToken.getToken());
        } else if (LOG.isInfoEnabled()) {
            LOG.info("Failed to find refresh token for token " + token);
        }
        return refreshToken;
    }

    @CacheEvict(cacheNames={"oauthaccesstoken", "oauthaccesstokenauth"}, allEntries=true)
    public void removeRefreshToken(OAuth2RefreshToken token) {
        this.removeRefreshToken(token.getValue());
    }

    @CacheEvict(cacheNames={"oauthaccesstoken", "oauthaccesstokenauth"}, allEntries=true)
    public void removeRefreshToken(String token) {
        this.refreshTokenRepository.delete((Serializable)((Object)this.extractTokenKey(token)));
    }

    public OAuth2Authentication readAuthenticationForRefreshToken(OAuth2RefreshToken token) {
        return this.readAuthenticationForRefreshToken(token.getValue());
    }

    public OAuth2Authentication readAuthenticationForRefreshToken(String token) {
        OAuth2Authentication authentication = null;
        RefreshToken storedToken = (RefreshToken)this.refreshTokenRepository.findOne((Serializable)((Object)this.extractTokenKey(token)));
        if (storedToken != null) {
            authentication = this.deserializeAuthentication(storedToken.getAuthentication());
        } else if (LOG.isInfoEnabled()) {
            LOG.info("Failed to find access token for token " + token);
        }
        return authentication;
    }

    @CacheEvict(cacheNames={"oauthaccesstoken", "oauthaccesstokenauth"}, allEntries=true)
    public void removeAccessTokenUsingRefreshToken(OAuth2RefreshToken refreshToken) {
        this.removeAccessTokenUsingRefreshToken(refreshToken.getValue());
    }

    @CacheEvict(cacheNames={"oauthaccesstoken", "oauthaccesstokenauth"}, allEntries=true)
    public void removeAccessTokenUsingRefreshToken(String refreshToken) {
        this.accessTokenRepository.deleteByRefreshToken(this.extractTokenKey(refreshToken));
    }

    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        OAuth2AccessToken accessToken = null;
        String key = this.authenticationKeyGenerator.extractKey(authentication);
        LOG.trace("auth={} key={}", (Object)authentication, (Object)key);
        AccessToken storedToken = this.accessTokenRepository.findByAuthenticationId(key);
        if (storedToken != null) {
            accessToken = this.deserializeAccessToken(storedToken.getToken());
            OAuth2Authentication auth = this.readAuthentication(accessToken.getValue());
            if (accessToken != null && auth != null && !key.equals(this.authenticationKeyGenerator.extractKey(auth))) {
                this.removeAccessToken(accessToken.getValue());
                this.storeAccessToken(accessToken, authentication);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Failed to find access token for authentication={}", (Object)authentication);
        }
        return accessToken;
    }

    public Collection<OAuth2AccessToken> findTokensByClientIdAndUserName(String clientId, String username) {
        return this.accessTokenRepository.findByClientIdAndUsername(clientId, username).stream().filter(at -> at != null).map(at -> this.deserializeAccessToken(at.getToken())).collect(Collectors.toList());
    }

    public Collection<OAuth2AccessToken> findTokensByClientId(String clientId) {
        return this.accessTokenRepository.findByClientId(clientId).stream().filter(at -> at != null).map(at -> this.deserializeAccessToken(at.getToken())).collect(Collectors.toList());
    }

    protected String extractTokenKey(String value) {
        MessageDigest digest;
        if (value == null) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm not available.  Fatal (should be in the JDK).");
        }
        try {
            byte[] bytes = digest.digest(value.getBytes("UTF-8"));
            return String.format("%032x", new BigInteger(1, bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not available.  Fatal (should be in the JDK).");
        }
    }

    protected byte[] serializeAccessToken(OAuth2AccessToken token) {
        try {
            return SerializationUtils.serialize((Object)token);
        }
        catch (Throwable e) {
            LOG.warn(e.getMessage() + ". Returning null.");
            return null;
        }
    }

    protected byte[] serializeRefreshToken(OAuth2RefreshToken token) {
        try {
            return SerializationUtils.serialize((Object)token);
        }
        catch (Throwable e) {
            LOG.warn(e.getMessage() + ". Returning null.");
            return null;
        }
    }

    protected byte[] serializeAuthentication(OAuth2Authentication authentication) {
        try {
            return SerializationUtils.serialize((Object)authentication);
        }
        catch (Throwable e) {
            LOG.warn(e.getMessage() + ". Returning null.");
            return null;
        }
    }

    protected OAuth2AccessToken deserializeAccessToken(byte[] token) {
        try {
            return (OAuth2AccessToken)SerializationUtils.deserialize((byte[])token);
        }
        catch (Throwable e) {
            LOG.warn(e.getMessage() + ". Returning null.");
            return null;
        }
    }

    protected OAuth2RefreshToken deserializeRefreshToken(byte[] token) {
        try {
            return (OAuth2RefreshToken)SerializationUtils.deserialize((byte[])token);
        }
        catch (Throwable e) {
            LOG.warn(e.getMessage() + ". Returning null.");
            return null;
        }
    }

    protected OAuth2Authentication deserializeAuthentication(byte[] authentication) {
        try {
            return (OAuth2Authentication)SerializationUtils.deserialize((byte[])authentication);
        }
        catch (Throwable e) {
            LOG.warn(e.getMessage() + ". Returning null.");
            return null;
        }
    }
}

