/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.blocks.oauth.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.genesys.blocks.model.AuditedVersionedModel;
import org.genesys.blocks.oauth.model.OAuthRole;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.provider.ClientDetails;

@Entity
@Table(name="oauthclient")
public class OAuthClient
extends AuditedVersionedModel
implements ClientDetails {
    private static final long serialVersionUID = -4204753722663196007L;
    @Column(unique=true, nullable=false, length=100)
    private String clientId;
    @Column(nullable=true, length=100)
    private String clientSecret;
    @Column(nullable=true, length=200)
    private String resource;
    @Transient
    private final Set<String> resourceIds = new HashSet<String>();
    @Column(nullable=false)
    boolean autoApprove = false;
    @Column(nullable=true, length=200)
    private String autoApproveScope;
    @Transient
    private final Set<String> autoApproveScopes = new HashSet<String>();
    @Column(nullable=true, length=200)
    private String scope;
    @Transient
    private final Set<String> scopes = new HashSet<String>();
    @Column(nullable=true, length=200)
    private String grants;
    @Transient
    private final Set<String> grantTypes = new HashSet<String>();
    @Column(nullable=true, length=200)
    private String redirect;
    @Transient
    private final Set<String> redirectUris = new HashSet<String>();
    @ElementCollection
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="clientrole", joinColumns={@JoinColumn(name="clientId")})
    @Column(name="oauthclientrole")
    private Collection<OAuthRole> roles = new ArrayList<OAuthRole>();
    @Transient
    private final Map<String, Object> additionalInformation = null;
    private Integer accessTokenValidity;
    private Integer refreshTokenValidity;

    @PrePersist
    private void flatten() {
        this.resource = this.resourceIds.stream().collect(Collectors.joining(";"));
        this.scope = this.scopes.stream().collect(Collectors.joining(";"));
        this.autoApproveScope = this.autoApproveScopes.stream().collect(Collectors.joining(";"));
        this.grants = this.grantTypes.stream().collect(Collectors.joining(";"));
        this.redirect = this.redirectUris.stream().collect(Collectors.joining(";"));
    }

    @PostLoad
    private void inflate() {
        if (this.resource != null) {
            Arrays.stream(StringUtils.split((String)this.resource, (String)";")).filter(r -> StringUtils.isNotBlank((CharSequence)r)).forEach(r -> this.resourceIds.add((String)r));
        }
        if (this.scope != null) {
            Arrays.stream(StringUtils.split((String)this.scope, (String)";")).filter(r -> StringUtils.isNotBlank((CharSequence)r)).forEach(s -> this.scopes.add((String)s));
        }
        if (this.autoApproveScope != null) {
            Arrays.stream(StringUtils.split((String)this.autoApproveScope, (String)";")).filter(r -> StringUtils.isNotBlank((CharSequence)r)).forEach(s -> this.autoApproveScopes.add((String)s));
        }
        if (this.grants != null) {
            Arrays.stream(StringUtils.split((String)this.grants, (String)";")).filter(r -> StringUtils.isNotBlank((CharSequence)r)).forEach(g -> this.grantTypes.add((String)g));
        }
        if (this.redirect != null) {
            Arrays.stream(StringUtils.split((String)this.redirect, (String)";")).filter(r -> StringUtils.isNotBlank((CharSequence)r)).forEach(u -> this.redirectUris.add((String)u));
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getGrants() {
        return this.grants;
    }

    public void setGrants(String grants) {
        this.grants = grants;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public Collection<OAuthRole> getRoles() {
        return this.roles;
    }

    public void setRoles(Collection<OAuthRole> roles) {
        this.roles = roles;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setAutoApprove(boolean autoApprove) {
        this.autoApprove = autoApprove;
    }

    public boolean getAutoApprove() {
        return this.autoApprove;
    }

    protected String getAutoApproveScope() {
        return this.autoApproveScope;
    }

    protected void setAutoApproveScope(String autoApproveScope) {
        this.autoApproveScope = autoApproveScope;
    }

    public Set<String> getAutoApproveScopes() {
        return this.autoApproveScopes;
    }

    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public boolean isSecretRequired() {
        return this.clientSecret != null;
    }

    public boolean isScoped() {
        return !this.scopes.isEmpty();
    }

    public Set<String> getScope() {
        return this.scopes;
    }

    public Set<String> getAuthorizedGrantTypes() {
        return this.grantTypes;
    }

    public Set<String> getRegisteredRedirectUri() {
        return this.redirectUris;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.roles.stream().collect(Collectors.toList());
    }

    public Integer getAccessTokenValiditySeconds() {
        return this.accessTokenValidity;
    }

    public Integer getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    public void setAccessTokenValidity(Integer accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
    }

    public Integer getRefreshTokenValiditySeconds() {
        return this.refreshTokenValidity;
    }

    public Integer getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public void setRefreshTokenValidity(Integer refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
    }

    public boolean isAutoApprove(String scope) {
        return this.autoApprove || this.autoApproveScopes.contains(scope);
    }

    public Map<String, Object> getAdditionalInformation() {
        return this.additionalInformation;
    }
}

