/*
 * Copyright 2017 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.security.service;

import java.util.List;
import java.util.Map;

import org.genesys.blocks.security.model.AclAwareModel;
import org.genesys.blocks.security.model.AclEntry;
import org.genesys.blocks.security.model.AclObjectIdentity;
import org.genesys.blocks.security.model.AclSid;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.userdetails.UserDetails;

public interface CustomAclService {

	void addCreatorPermissions(AclAwareModel target);

	void removePermissions(AclAwareModel target);

	AclObjectIdentity getObjectIdentity(String clazz, long id);

	AclObjectIdentity getObjectIdentity(long id);

	AclObjectIdentity getObjectIdentity(AclAwareModel entity);

	Permission[] getAvailablePermissions(String className);

	Map<String, Map<Integer, Boolean>> getPermissions(long id, String className);

	Map<String, Map<Integer, Boolean>> getPermissions(AclAwareModel entity);

	List<AclEntry> getAclEntries(AclObjectIdentity objectIdentity);

	void updatePermission(AclObjectIdentity entity, String sid, Map<Integer, Boolean> permissionMap);

	List<AclEntry> getAclEntries(AclAwareModel entity);

	List<AclSid> getSids(long id, String className);

	List<AclSid> getSids(AclAwareModel entity);

	List<AclSid> getAllSids();

	boolean addPermissions(long objectIdIdentity, String className, String uuid, boolean principal, Map<Integer, Boolean> permissions);

	AclObjectIdentity ensureObjectIdentity(String className, long objectIdIdentity);

	List<Integer> permissionsBySid(String className, Long id, String sid);

	List<Long> listIdentitiesForSid(Class<? extends AclAwareModel> clazz, UserDetails authUser, Permission permission);
}
