/*
 * Copyright 2017 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.security.persistence;

import org.genesys.blocks.security.model.AclSid;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

public interface AclSidPersistence extends JpaRepository<AclSid, Long> {

	AclSid findBySidAndPrincipal(String sid, boolean principal);

	/**
	 * List ACL SIDs with internal identifiers.
	 * 
	 * @param ids internal (database) SID identifiers
	 * @return ACL SIDs for specified identifiers
	 */
	@Query("select distinct sid from AclSid sid where sid.id in :ids")
	List<AclSid> listById(@Param("ids") Iterable<Long> ids);
}
