/*
 * Copyright 2017 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.security.model;

import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonIgnore;

import org.genesys.blocks.model.BasicModel;

/**
 * ACL SID uniquely identifies any principal or authority in the system ("SID" stands for "security identity").
 */
@Entity
@Table(name = "acl_sid")
public class AclSid extends BasicModel {

	private static final long serialVersionUID = -8665345718313672678L;

	@Column(name = "principal", nullable = false, length = 1)
	private boolean principal;

	@Column(name = "sid", nullable = false, length = 100)
	private String sid;

	@JsonIgnore
	@OneToMany(mappedBy = "ownerSid", fetch = FetchType.LAZY, cascade = CascadeType.REMOVE, orphanRemoval = true)
	private List<AclObjectIdentity> objectIdentities;

	@JsonIgnore
	@OneToMany(mappedBy = "aclSid", fetch = FetchType.LAZY, cascade = CascadeType.REMOVE, orphanRemoval = true)
	private List<AclEntry> aclEntries;

	public boolean isPrincipal() {
		return principal;
	}

	public void setPrincipal(final boolean principal) {
		this.principal = principal;
	}

	public String getSid() {
		return sid;
	}

	public void setSid(final String sid) {
		this.sid = sid;
	}

	public List<AclObjectIdentity> getObjectIdentities() {
		return objectIdentities;
	}

	public void setObjectIdentities(final List<AclObjectIdentity> objectIdentities) {
		this.objectIdentities = objectIdentities;
	}

	public List<AclEntry> getAclEntries() {
		return aclEntries;
	}

	public void setAclEntries(final List<AclEntry> aclEntries) {
		this.aclEntries = aclEntries;
	}
}
