/*
 * Copyright 2017 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.blocks.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.genesys.blocks.security.model.BasicUser;
import org.springframework.data.domain.AuditorAware;
import org.springframework.stereotype.Component;

@Component
public class SpringSecurityAuditorAware implements AuditorAware<Long> {
	public static final Log LOG = LogFactory.getLog(SpringSecurityAuditorAware.class);

	@Override
	public Long getCurrentAuditor() {
		final BasicUser<?> user = SecurityContextUtil.getCurrentUser();

		if (user == null) {
			SpringSecurityAuditorAware.LOG.trace("No User in security context, can't specify createdBy/lastUpdatedBy");
		}

		return user == null ? null : user.getId();
	}

}
