/*
 * Copyright 2017 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.genesys.blocks.security;

import org.genesys.blocks.security.model.BasicUser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityContextUtil {

	public static String getUsername() {
		final Authentication auth = SecurityContextHolder.getContext().getAuthentication();

		if (auth.getPrincipal() instanceof UserDetails) {
			return ((UserDetails) auth.getPrincipal()).getUsername();
		} else {
			return null;
		}
	}

	/**
	 * @return current user
	 */
	@SuppressWarnings("unchecked")
	public static <T extends BasicUser<?>> T getMe() {
		final Authentication auth = SecurityContextHolder.getContext().getAuthentication();

		if (auth != null && auth.getPrincipal() instanceof BasicUser) {
			return (T) auth.getPrincipal();
		} else {
			return null;
		}
	}

	@SuppressWarnings("unchecked")
	public static <T extends BasicUser<?>> T getCurrentUser() {
		final Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
	
		if (authentication != null && authentication.getPrincipal() instanceof BasicUser) {
			return (T) authentication.getPrincipal();
		}
	
		return null;
	}
}
