package org.geneontology.obographs.core.model.meta;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.Meta;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractXrefPropertyValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new XrefPropertyValue.Builder()}.
 */
@Generated(from = "AbstractXrefPropertyValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class XrefPropertyValue
    extends AbstractXrefPropertyValue {
  private final String pred;
  private final String val;
  private final List<String> xrefs;
  private final @Nullable Meta meta;
  private final String lbl;

  private XrefPropertyValue(XrefPropertyValue.Builder builder) {
    this.xrefs = createUnmodifiableList(true, builder.xrefs);
    this.meta = builder.meta;
    if (builder.pred != null) {
      initShim.pred(builder.pred);
    }
    if (builder.val != null) {
      initShim.val(builder.val);
    }
    if (builder.lbl != null) {
      initShim.lbl(builder.lbl);
    }
    this.pred = initShim.getPred();
    this.val = initShim.getVal();
    this.lbl = initShim.getLbl();
    this.initShim = null;
  }

  private XrefPropertyValue(
      String pred,
      String val,
      List<String> xrefs,
      @Nullable Meta meta,
      String lbl) {
    this.pred = pred;
    this.val = val;
    this.xrefs = xrefs;
    this.meta = meta;
    this.lbl = lbl;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "AbstractXrefPropertyValue", generator = "Immutables")
  private final class InitShim {
    private byte predBuildStage = STAGE_UNINITIALIZED;
    private String pred;

    String getPred() {
      if (predBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (predBuildStage == STAGE_UNINITIALIZED) {
        predBuildStage = STAGE_INITIALIZING;
        this.pred = Objects.requireNonNull(XrefPropertyValue.super.getPred(), "pred");
        predBuildStage = STAGE_INITIALIZED;
      }
      return this.pred;
    }

    void pred(String pred) {
      this.pred = pred;
      predBuildStage = STAGE_INITIALIZED;
    }

    private byte valBuildStage = STAGE_UNINITIALIZED;
    private String val;

    String getVal() {
      if (valBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (valBuildStage == STAGE_UNINITIALIZED) {
        valBuildStage = STAGE_INITIALIZING;
        this.val = Objects.requireNonNull(XrefPropertyValue.super.getVal(), "val");
        valBuildStage = STAGE_INITIALIZED;
      }
      return this.val;
    }

    void val(String val) {
      this.val = val;
      valBuildStage = STAGE_INITIALIZED;
    }

    private byte lblBuildStage = STAGE_UNINITIALIZED;
    private String lbl;

    String getLbl() {
      if (lblBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (lblBuildStage == STAGE_UNINITIALIZED) {
        lblBuildStage = STAGE_INITIALIZING;
        this.lbl = Objects.requireNonNull(XrefPropertyValue.super.getLbl(), "lbl");
        lblBuildStage = STAGE_INITIALIZED;
      }
      return this.lbl;
    }

    void lbl(String lbl) {
      this.lbl = lbl;
      lblBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (predBuildStage == STAGE_INITIALIZING) attributes.add("pred");
      if (valBuildStage == STAGE_INITIALIZING) attributes.add("val");
      if (lblBuildStage == STAGE_INITIALIZING) attributes.add("lbl");
      return "Cannot build XrefPropertyValue, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Predicates correspond to OWL properties. Like all preds in this datamodel,
   * a pred is represented as a String which denotes a CURIE
   * 
   * @return the pred
   */
  @JsonProperty
  @Override
  public String getPred() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPred()
        : this.pred;
  }

  /**
   * The value of the property-value
   * @return the val
   */
  @JsonProperty
  @Override
  public String getVal() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getVal()
        : this.val;
  }

  /**
   * An array denoting objects that support the property value assertion
   * @return the xrefs
   */
  @JsonProperty
  @Override
  public List<String> getXrefs() {
    return xrefs;
  }

  /**
   * @return The value of the {@code meta} attribute
   */
  @JsonProperty
  @Override
  public @Nullable Meta getMeta() {
    return meta;
  }

  /**
   * @return the lbl
   */
  @JsonProperty
  @Override
  public String getLbl() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLbl()
        : this.lbl;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractXrefPropertyValue#getPred() pred} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pred
   * @return A modified copy of the {@code this} object
   */
  public final XrefPropertyValue withPred(String value) {
    String newValue = Objects.requireNonNull(value, "pred");
    if (this.pred.equals(newValue)) return this;
    return new XrefPropertyValue(newValue, this.val, this.xrefs, this.meta, this.lbl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractXrefPropertyValue#getVal() val} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for val
   * @return A modified copy of the {@code this} object
   */
  public final XrefPropertyValue withVal(String value) {
    String newValue = Objects.requireNonNull(value, "val");
    if (this.val.equals(newValue)) return this;
    return new XrefPropertyValue(this.pred, newValue, this.xrefs, this.meta, this.lbl);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractXrefPropertyValue#getXrefs() xrefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final XrefPropertyValue withXrefs(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new XrefPropertyValue(this.pred, this.val, newValue, this.meta, this.lbl);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractXrefPropertyValue#getXrefs() xrefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of xrefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final XrefPropertyValue withXrefs(Iterable<String> elements) {
    if (this.xrefs == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new XrefPropertyValue(this.pred, this.val, newValue, this.meta, this.lbl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractXrefPropertyValue#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final XrefPropertyValue withMeta(@Nullable Meta value) {
    if (this.meta == value) return this;
    return new XrefPropertyValue(this.pred, this.val, this.xrefs, value, this.lbl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractXrefPropertyValue#getLbl() lbl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lbl
   * @return A modified copy of the {@code this} object
   */
  public final XrefPropertyValue withLbl(String value) {
    String newValue = Objects.requireNonNull(value, "lbl");
    if (this.lbl.equals(newValue)) return this;
    return new XrefPropertyValue(this.pred, this.val, this.xrefs, this.meta, newValue);
  }

  /**
   * This instance is equal to all instances of {@code XrefPropertyValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof XrefPropertyValue
        && equalTo(0, (XrefPropertyValue) another);
  }

  private boolean equalTo(int synthetic, XrefPropertyValue another) {
    return pred.equals(another.pred)
        && val.equals(another.val)
        && xrefs.equals(another.xrefs)
        && Objects.equals(meta, another.meta)
        && lbl.equals(another.lbl);
  }

  /**
   * Computes a hash code from attributes: {@code pred}, {@code val}, {@code xrefs}, {@code meta}, {@code lbl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + pred.hashCode();
    h += (h << 5) + val.hashCode();
    h += (h << 5) + xrefs.hashCode();
    h += (h << 5) + Objects.hashCode(meta);
    h += (h << 5) + lbl.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code XrefPropertyValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "XrefPropertyValue{"
        + "pred=" + pred
        + ", val=" + val
        + ", xrefs=" + xrefs
        + ", meta=" + meta
        + ", lbl=" + lbl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractXrefPropertyValue", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractXrefPropertyValue {
    @Nullable String pred;
    @Nullable String val;
    @Nullable List<String> xrefs = Collections.emptyList();
    @Nullable Meta meta;
    @Nullable String lbl;
    @JsonProperty
    public void setPred(String pred) {
      this.pred = pred;
    }
    @JsonProperty
    public void setVal(String val) {
      this.val = val;
    }
    @JsonProperty
    public void setXrefs(List<String> xrefs) {
      this.xrefs = xrefs;
    }
    @JsonProperty
    public void setMeta(@Nullable Meta meta) {
      this.meta = meta;
    }
    @JsonProperty
    public void setLbl(String lbl) {
      this.lbl = lbl;
    }
    @Override
    public String getPred() { throw new UnsupportedOperationException(); }
    @Override
    public String getVal() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getXrefs() { throw new UnsupportedOperationException(); }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public String getLbl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static XrefPropertyValue fromJson(Json json) {
    XrefPropertyValue.Builder builder = new XrefPropertyValue.Builder();
    if (json.pred != null) {
      builder.pred(json.pred);
    }
    if (json.val != null) {
      builder.val(json.val);
    }
    if (json.xrefs != null) {
      builder.addAllXrefs(json.xrefs);
    }
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.lbl != null) {
      builder.lbl(json.lbl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractXrefPropertyValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable XrefPropertyValue instance
   */
  public static XrefPropertyValue copyOf(AbstractXrefPropertyValue instance) {
    if (instance instanceof XrefPropertyValue) {
      return (XrefPropertyValue) instance;
    }
    return new XrefPropertyValue.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link XrefPropertyValue XrefPropertyValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractXrefPropertyValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String pred;
    private @Nullable String val;
    private List<String> xrefs = new ArrayList<String>();
    private @Nullable Meta meta;
    private @Nullable String lbl;

    /**
     * Creates a builder for {@link XrefPropertyValue XrefPropertyValue} instances.
     * <pre>
     * new XrefPropertyValue.Builder()
     *    .pred(String) // optional {@link AbstractXrefPropertyValue#getPred() pred}
     *    .val(String) // optional {@link AbstractXrefPropertyValue#getVal() val}
     *    .addXref|addAllXrefs(String) // {@link AbstractXrefPropertyValue#getXrefs() xrefs} elements
     *    .meta(org.geneontology.obographs.core.model.Meta | null) // nullable {@link AbstractXrefPropertyValue#getMeta() meta}
     *    .lbl(String) // optional {@link AbstractXrefPropertyValue#getLbl() lbl}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.meta.AbstractXrefPropertyValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractXrefPropertyValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.meta.PropertyValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PropertyValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractXrefPropertyValue) {
        AbstractXrefPropertyValue instance = (AbstractXrefPropertyValue) object;
        if ((bits & 0x1L) == 0) {
          val(instance.getVal());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          addAllXrefs(instance.getXrefs());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          pred(instance.getPred());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x8L;
        }
        lbl(instance.getLbl());
      }
      if (object instanceof PropertyValue) {
        PropertyValue instance = (PropertyValue) object;
        if ((bits & 0x1L) == 0) {
          val(instance.getVal());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          addAllXrefs(instance.getXrefs());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          pred(instance.getPred());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x8L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractXrefPropertyValue#getPred() pred} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractXrefPropertyValue#getPred() pred}.</em>
     * @param pred The value for pred 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pred(String pred) {
      this.pred = Objects.requireNonNull(pred, "pred");
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractXrefPropertyValue#getVal() val} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractXrefPropertyValue#getVal() val}.</em>
     * @param val The value for val 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder val(String val) {
      this.val = Objects.requireNonNull(val, "val");
      return this;
    }

    /**
     * Adds one element to {@link AbstractXrefPropertyValue#getXrefs() xrefs} list.
     * @param element A xrefs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addXref(String element) {
      this.xrefs.add(Objects.requireNonNull(element, "xrefs element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractXrefPropertyValue#getXrefs() xrefs} list.
     * @param elements An array of xrefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addXrefs(String... elements) {
      for (String element : elements) {
        this.xrefs.add(Objects.requireNonNull(element, "xrefs element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractXrefPropertyValue#getXrefs() xrefs} list.
     * @param elements An iterable of xrefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder xrefs(Iterable<String> elements) {
      this.xrefs.clear();
      return addAllXrefs(elements);
    }

    /**
     * Adds elements to {@link AbstractXrefPropertyValue#getXrefs() xrefs} list.
     * @param elements An iterable of xrefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllXrefs(Iterable<String> elements) {
      for (String element : elements) {
        this.xrefs.add(Objects.requireNonNull(element, "xrefs element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractXrefPropertyValue#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(@Nullable Meta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractXrefPropertyValue#getLbl() lbl} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractXrefPropertyValue#getLbl() lbl}.</em>
     * @param lbl The value for lbl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lbl(String lbl) {
      this.lbl = Objects.requireNonNull(lbl, "lbl");
      return this;
    }

    /**
     * Builds a new {@link XrefPropertyValue XrefPropertyValue}.
     * @return An immutable instance of XrefPropertyValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public XrefPropertyValue build() {
      return new XrefPropertyValue(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
