package org.geneontology.obographs.core.model.meta;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.Meta;
import org.immutables.value.Generated;

/**
 * A {@link PropertyValue} that represents a an alternative term for a node
 * @author cjm
 */
@Generated(from = "AbstractSynonymPropertyValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class SynonymPropertyValue
    extends AbstractSynonymPropertyValue {
  private final String pred;
  private final String val;
  private final List<String> xrefs;
  private final @Nullable Meta meta;
  private final String synonymType;

  private SynonymPropertyValue(SynonymPropertyValue.Builder builder) {
    this.xrefs = createUnmodifiableList(true, builder.xrefs);
    this.meta = builder.meta;
    if (builder.pred != null) {
      initShim.pred(builder.pred);
    }
    if (builder.val != null) {
      initShim.val(builder.val);
    }
    if (builder.synonymType != null) {
      initShim.synonymType(builder.synonymType);
    }
    this.pred = initShim.getPred();
    this.val = initShim.getVal();
    this.synonymType = initShim.getSynonymType();
    this.initShim = null;
  }

  private SynonymPropertyValue(
      String pred,
      String val,
      List<String> xrefs,
      @Nullable Meta meta,
      String synonymType) {
    this.pred = pred;
    this.val = val;
    this.xrefs = xrefs;
    this.meta = meta;
    this.synonymType = synonymType;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "AbstractSynonymPropertyValue", generator = "Immutables")
  private final class InitShim {
    private byte predBuildStage = STAGE_UNINITIALIZED;
    private String pred;

    String getPred() {
      if (predBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (predBuildStage == STAGE_UNINITIALIZED) {
        predBuildStage = STAGE_INITIALIZING;
        this.pred = Objects.requireNonNull(SynonymPropertyValue.super.getPred(), "pred");
        predBuildStage = STAGE_INITIALIZED;
      }
      return this.pred;
    }

    void pred(String pred) {
      this.pred = pred;
      predBuildStage = STAGE_INITIALIZED;
    }

    private byte valBuildStage = STAGE_UNINITIALIZED;
    private String val;

    String getVal() {
      if (valBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (valBuildStage == STAGE_UNINITIALIZED) {
        valBuildStage = STAGE_INITIALIZING;
        this.val = Objects.requireNonNull(SynonymPropertyValue.super.getVal(), "val");
        valBuildStage = STAGE_INITIALIZED;
      }
      return this.val;
    }

    void val(String val) {
      this.val = val;
      valBuildStage = STAGE_INITIALIZED;
    }

    private byte synonymTypeBuildStage = STAGE_UNINITIALIZED;
    private String synonymType;

    String getSynonymType() {
      if (synonymTypeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (synonymTypeBuildStage == STAGE_UNINITIALIZED) {
        synonymTypeBuildStage = STAGE_INITIALIZING;
        this.synonymType = Objects.requireNonNull(SynonymPropertyValue.super.getSynonymType(), "synonymType");
        synonymTypeBuildStage = STAGE_INITIALIZED;
      }
      return this.synonymType;
    }

    void synonymType(String synonymType) {
      this.synonymType = synonymType;
      synonymTypeBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (predBuildStage == STAGE_INITIALIZING) attributes.add("pred");
      if (valBuildStage == STAGE_INITIALIZING) attributes.add("val");
      if (synonymTypeBuildStage == STAGE_INITIALIZING) attributes.add("synonymType");
      return "Cannot build SynonymPropertyValue, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Predicates correspond to OWL properties. Like all preds in this datamodel,
   * a pred is represented as a String which denotes a CURIE
   * 
   * @return the pred
   */
  @JsonProperty
  @Override
  public String getPred() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPred()
        : this.pred;
  }

  /**
   * The value of the property-value
   * @return the val
   */
  @JsonProperty
  @Override
  public String getVal() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getVal()
        : this.val;
  }

  /**
   * An array denoting objects that support the property value assertion
   * @return the xrefs
   */
  @JsonProperty
  @Override
  public List<String> getXrefs() {
    return xrefs;
  }

  /**
   * @return The value of the {@code meta} attribute
   */
  @JsonProperty
  @Override
  public @Nullable Meta getMeta() {
    return meta;
  }

  /**
   * @return The value of the {@code synonymType} attribute
   */
  @JsonProperty
  @Override
  public String getSynonymType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSynonymType()
        : this.synonymType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSynonymPropertyValue#getPred() pred} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pred
   * @return A modified copy of the {@code this} object
   */
  public final SynonymPropertyValue withPred(String value) {
    String newValue = Objects.requireNonNull(value, "pred");
    if (this.pred.equals(newValue)) return this;
    return new SynonymPropertyValue(newValue, this.val, this.xrefs, this.meta, this.synonymType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSynonymPropertyValue#getVal() val} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for val
   * @return A modified copy of the {@code this} object
   */
  public final SynonymPropertyValue withVal(String value) {
    String newValue = Objects.requireNonNull(value, "val");
    if (this.val.equals(newValue)) return this;
    return new SynonymPropertyValue(this.pred, newValue, this.xrefs, this.meta, this.synonymType);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSynonymPropertyValue#getXrefs() xrefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SynonymPropertyValue withXrefs(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SynonymPropertyValue(this.pred, this.val, newValue, this.meta, this.synonymType);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSynonymPropertyValue#getXrefs() xrefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of xrefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final SynonymPropertyValue withXrefs(Iterable<String> elements) {
    if (this.xrefs == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SynonymPropertyValue(this.pred, this.val, newValue, this.meta, this.synonymType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSynonymPropertyValue#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final SynonymPropertyValue withMeta(@Nullable Meta value) {
    if (this.meta == value) return this;
    return new SynonymPropertyValue(this.pred, this.val, this.xrefs, value, this.synonymType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSynonymPropertyValue#getSynonymType() synonymType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for synonymType
   * @return A modified copy of the {@code this} object
   */
  public final SynonymPropertyValue withSynonymType(String value) {
    String newValue = Objects.requireNonNull(value, "synonymType");
    if (this.synonymType.equals(newValue)) return this;
    return new SynonymPropertyValue(this.pred, this.val, this.xrefs, this.meta, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SynonymPropertyValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SynonymPropertyValue
        && equalTo(0, (SynonymPropertyValue) another);
  }

  private boolean equalTo(int synthetic, SynonymPropertyValue another) {
    return pred.equals(another.pred)
        && val.equals(another.val)
        && xrefs.equals(another.xrefs)
        && Objects.equals(meta, another.meta)
        && synonymType.equals(another.synonymType);
  }

  /**
   * Computes a hash code from attributes: {@code pred}, {@code val}, {@code xrefs}, {@code meta}, {@code synonymType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + pred.hashCode();
    h += (h << 5) + val.hashCode();
    h += (h << 5) + xrefs.hashCode();
    h += (h << 5) + Objects.hashCode(meta);
    h += (h << 5) + synonymType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SynonymPropertyValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SynonymPropertyValue{"
        + "pred=" + pred
        + ", val=" + val
        + ", xrefs=" + xrefs
        + ", meta=" + meta
        + ", synonymType=" + synonymType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractSynonymPropertyValue", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractSynonymPropertyValue {
    @Nullable String pred;
    @Nullable String val;
    @Nullable List<String> xrefs = Collections.emptyList();
    @Nullable Meta meta;
    @Nullable String synonymType;
    @JsonProperty
    public void setPred(String pred) {
      this.pred = pred;
    }
    @JsonProperty
    public void setVal(String val) {
      this.val = val;
    }
    @JsonProperty
    public void setXrefs(List<String> xrefs) {
      this.xrefs = xrefs;
    }
    @JsonProperty
    public void setMeta(@Nullable Meta meta) {
      this.meta = meta;
    }
    @JsonProperty
    public void setSynonymType(String synonymType) {
      this.synonymType = synonymType;
    }
    @Override
    public String getPred() { throw new UnsupportedOperationException(); }
    @Override
    public String getVal() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getXrefs() { throw new UnsupportedOperationException(); }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public String getSynonymType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SynonymPropertyValue fromJson(Json json) {
    SynonymPropertyValue.Builder builder = new SynonymPropertyValue.Builder();
    if (json.pred != null) {
      builder.pred(json.pred);
    }
    if (json.val != null) {
      builder.val(json.val);
    }
    if (json.xrefs != null) {
      builder.addAllXrefs(json.xrefs);
    }
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.synonymType != null) {
      builder.synonymType(json.synonymType);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractSynonymPropertyValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SynonymPropertyValue instance
   */
  public static SynonymPropertyValue copyOf(AbstractSynonymPropertyValue instance) {
    if (instance instanceof SynonymPropertyValue) {
      return (SynonymPropertyValue) instance;
    }
    return new SynonymPropertyValue.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link SynonymPropertyValue SynonymPropertyValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractSynonymPropertyValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String pred;
    private @Nullable String val;
    private List<String> xrefs = new ArrayList<String>();
    private @Nullable Meta meta;
    private @Nullable String synonymType;

    /**
     * Creates a builder for {@link SynonymPropertyValue SynonymPropertyValue} instances.
     * <pre>
     * new SynonymPropertyValue.Builder()
     *    .pred(String) // optional {@link AbstractSynonymPropertyValue#getPred() pred}
     *    .val(String) // optional {@link AbstractSynonymPropertyValue#getVal() val}
     *    .addXref|addAllXrefs(String) // {@link AbstractSynonymPropertyValue#getXrefs() xrefs} elements
     *    .meta(org.geneontology.obographs.core.model.Meta | null) // nullable {@link AbstractSynonymPropertyValue#getMeta() meta}
     *    .synonymType(String) // optional {@link AbstractSynonymPropertyValue#getSynonymType() synonymType}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.meta.AbstractSynonymPropertyValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractSynonymPropertyValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.meta.PropertyValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PropertyValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractSynonymPropertyValue) {
        AbstractSynonymPropertyValue instance = (AbstractSynonymPropertyValue) object;
        if ((bits & 0x1L) == 0) {
          val(instance.getVal());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          addAllXrefs(instance.getXrefs());
          bits |= 0x2L;
        }
        synonymType(instance.getSynonymType());
        if ((bits & 0x4L) == 0) {
          pred(instance.getPred());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x8L;
        }
      }
      if (object instanceof PropertyValue) {
        PropertyValue instance = (PropertyValue) object;
        if ((bits & 0x1L) == 0) {
          val(instance.getVal());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          addAllXrefs(instance.getXrefs());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          pred(instance.getPred());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x8L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractSynonymPropertyValue#getPred() pred} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractSynonymPropertyValue#getPred() pred}.</em>
     * @param pred The value for pred 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pred(String pred) {
      this.pred = Objects.requireNonNull(pred, "pred");
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSynonymPropertyValue#getVal() val} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractSynonymPropertyValue#getVal() val}.</em>
     * @param val The value for val 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder val(String val) {
      this.val = Objects.requireNonNull(val, "val");
      return this;
    }

    /**
     * Adds one element to {@link AbstractSynonymPropertyValue#getXrefs() xrefs} list.
     * @param element A xrefs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addXref(String element) {
      this.xrefs.add(Objects.requireNonNull(element, "xrefs element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractSynonymPropertyValue#getXrefs() xrefs} list.
     * @param elements An array of xrefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addXrefs(String... elements) {
      for (String element : elements) {
        this.xrefs.add(Objects.requireNonNull(element, "xrefs element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractSynonymPropertyValue#getXrefs() xrefs} list.
     * @param elements An iterable of xrefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder xrefs(Iterable<String> elements) {
      this.xrefs.clear();
      return addAllXrefs(elements);
    }

    /**
     * Adds elements to {@link AbstractSynonymPropertyValue#getXrefs() xrefs} list.
     * @param elements An iterable of xrefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllXrefs(Iterable<String> elements) {
      for (String element : elements) {
        this.xrefs.add(Objects.requireNonNull(element, "xrefs element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSynonymPropertyValue#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(@Nullable Meta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSynonymPropertyValue#getSynonymType() synonymType} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractSynonymPropertyValue#getSynonymType() synonymType}.</em>
     * @param synonymType The value for synonymType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder synonymType(String synonymType) {
      this.synonymType = Objects.requireNonNull(synonymType, "synonymType");
      return this;
    }

    /**
     * Builds a new {@link SynonymPropertyValue SynonymPropertyValue}.
     * @return An immutable instance of SynonymPropertyValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SynonymPropertyValue build() {
      return new SynonymPropertyValue(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
