package org.geneontology.obographs.core.model.axiom;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.Meta;
import org.immutables.value.Generated;

/**
 * P <- P1 ... Pn
 * 
 * 
 * @author cjm
 */
@Generated(from = "AbstractPropertyChainAxiom", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class PropertyChainAxiom
    extends AbstractPropertyChainAxiom {
  private final @Nullable Meta meta;
  private final String predicateId;
  private final List<String> chainPredicateIds;

  private PropertyChainAxiom(
      @Nullable Meta meta,
      String predicateId,
      List<String> chainPredicateIds) {
    this.meta = meta;
    this.predicateId = predicateId;
    this.chainPredicateIds = chainPredicateIds;
  }

  /**
   * @return the meta
   */
  @JsonProperty
  @Override
  public @Nullable Meta getMeta() {
    return meta;
  }

  /**
   * @return the predicateId
   */
  @JsonProperty
  @Override
  public String getPredicateId() {
    return predicateId;
  }

  /**
   * @return the chainPredicateIds
   */
  @JsonProperty
  @Override
  public List<String> getChainPredicateIds() {
    return chainPredicateIds;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractPropertyChainAxiom#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final PropertyChainAxiom withMeta(@Nullable Meta value) {
    if (this.meta == value) return this;
    return new PropertyChainAxiom(value, this.predicateId, this.chainPredicateIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractPropertyChainAxiom#getPredicateId() predicateId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for predicateId
   * @return A modified copy of the {@code this} object
   */
  public final PropertyChainAxiom withPredicateId(String value) {
    String newValue = Objects.requireNonNull(value, "predicateId");
    if (this.predicateId.equals(newValue)) return this;
    return new PropertyChainAxiom(this.meta, newValue, this.chainPredicateIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractPropertyChainAxiom#getChainPredicateIds() chainPredicateIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final PropertyChainAxiom withChainPredicateIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new PropertyChainAxiom(this.meta, this.predicateId, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractPropertyChainAxiom#getChainPredicateIds() chainPredicateIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of chainPredicateIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final PropertyChainAxiom withChainPredicateIds(Iterable<String> elements) {
    if (this.chainPredicateIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new PropertyChainAxiom(this.meta, this.predicateId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code PropertyChainAxiom} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof PropertyChainAxiom
        && equalTo(0, (PropertyChainAxiom) another);
  }

  private boolean equalTo(int synthetic, PropertyChainAxiom another) {
    return Objects.equals(meta, another.meta)
        && predicateId.equals(another.predicateId)
        && chainPredicateIds.equals(another.chainPredicateIds);
  }

  /**
   * Computes a hash code from attributes: {@code meta}, {@code predicateId}, {@code chainPredicateIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(meta);
    h += (h << 5) + predicateId.hashCode();
    h += (h << 5) + chainPredicateIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PropertyChainAxiom} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PropertyChainAxiom{"
        + "meta=" + meta
        + ", predicateId=" + predicateId
        + ", chainPredicateIds=" + chainPredicateIds
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractPropertyChainAxiom", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractPropertyChainAxiom {
    @Nullable Meta meta;
    @Nullable String predicateId;
    @Nullable List<String> chainPredicateIds = Collections.emptyList();
    @JsonProperty
    public void setMeta(@Nullable Meta meta) {
      this.meta = meta;
    }
    @JsonProperty
    public void setPredicateId(String predicateId) {
      this.predicateId = predicateId;
    }
    @JsonProperty
    public void setChainPredicateIds(List<String> chainPredicateIds) {
      this.chainPredicateIds = chainPredicateIds;
    }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public String getPredicateId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getChainPredicateIds() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static PropertyChainAxiom fromJson(Json json) {
    PropertyChainAxiom.Builder builder = new PropertyChainAxiom.Builder();
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.predicateId != null) {
      builder.predicateId(json.predicateId);
    }
    if (json.chainPredicateIds != null) {
      builder.addAllChainPredicateIds(json.chainPredicateIds);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractPropertyChainAxiom} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PropertyChainAxiom instance
   */
  public static PropertyChainAxiom copyOf(AbstractPropertyChainAxiom instance) {
    if (instance instanceof PropertyChainAxiom) {
      return (PropertyChainAxiom) instance;
    }
    return new PropertyChainAxiom.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link PropertyChainAxiom PropertyChainAxiom}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractPropertyChainAxiom", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PREDICATE_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Meta meta;
    private @Nullable String predicateId;
    private List<String> chainPredicateIds = new ArrayList<String>();

    /**
     * Creates a builder for {@link PropertyChainAxiom PropertyChainAxiom} instances.
     * <pre>
     * new PropertyChainAxiom.Builder()
     *    .meta(org.geneontology.obographs.core.model.Meta | null) // nullable {@link AbstractPropertyChainAxiom#getMeta() meta}
     *    .predicateId(String) // required {@link AbstractPropertyChainAxiom#getPredicateId() predicateId}
     *    .addChainPredicateId|addAllChainPredicateIds(String) // {@link AbstractPropertyChainAxiom#getChainPredicateIds() chainPredicateIds} elements
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.axiom.AbstractPropertyChainAxiom} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractPropertyChainAxiom instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.axiom.Axiom} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Axiom instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractPropertyChainAxiom) {
        AbstractPropertyChainAxiom instance = (AbstractPropertyChainAxiom) object;
        addAllChainPredicateIds(instance.getChainPredicateIds());
        predicateId(instance.getPredicateId());
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof Axiom) {
        Axiom instance = (Axiom) object;
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractPropertyChainAxiom#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(@Nullable Meta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractPropertyChainAxiom#getPredicateId() predicateId} attribute.
     * @param predicateId The value for predicateId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder predicateId(String predicateId) {
      this.predicateId = Objects.requireNonNull(predicateId, "predicateId");
      initBits &= ~INIT_BIT_PREDICATE_ID;
      return this;
    }

    /**
     * Adds one element to {@link AbstractPropertyChainAxiom#getChainPredicateIds() chainPredicateIds} list.
     * @param element A chainPredicateIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChainPredicateId(String element) {
      this.chainPredicateIds.add(Objects.requireNonNull(element, "chainPredicateIds element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractPropertyChainAxiom#getChainPredicateIds() chainPredicateIds} list.
     * @param elements An array of chainPredicateIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChainPredicateIds(String... elements) {
      for (String element : elements) {
        this.chainPredicateIds.add(Objects.requireNonNull(element, "chainPredicateIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractPropertyChainAxiom#getChainPredicateIds() chainPredicateIds} list.
     * @param elements An iterable of chainPredicateIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder chainPredicateIds(Iterable<String> elements) {
      this.chainPredicateIds.clear();
      return addAllChainPredicateIds(elements);
    }

    /**
     * Adds elements to {@link AbstractPropertyChainAxiom#getChainPredicateIds() chainPredicateIds} list.
     * @param elements An iterable of chainPredicateIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChainPredicateIds(Iterable<String> elements) {
      for (String element : elements) {
        this.chainPredicateIds.add(Objects.requireNonNull(element, "chainPredicateIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link PropertyChainAxiom PropertyChainAxiom}.
     * @return An immutable instance of PropertyChainAxiom
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PropertyChainAxiom build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PropertyChainAxiom(meta, predicateId, createUnmodifiableList(true, chainPredicateIds));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PREDICATE_ID) != 0) attributes.add("predicateId");
      return "Cannot build PropertyChainAxiom, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
