package org.geneontology.obographs.core.model.axiom;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.Meta;
import org.immutables.value.Generated;

/**
 * Corresponds to an axiom of the form C = X1 and ... and Xn,
 * Where X_i is either a named class or OWL Restriction
 * 
 * 
 * @author cjm
 */
@Generated(from = "AbstractLogicalDefinitionAxiom", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class LogicalDefinitionAxiom
    extends AbstractLogicalDefinitionAxiom {
  private final @Nullable Meta meta;
  private final String definedClassId;
  private final List<String> genusIds;
  private final List<ExistentialRestrictionExpression> restrictions;

  private LogicalDefinitionAxiom(
      @Nullable Meta meta,
      String definedClassId,
      List<String> genusIds,
      List<ExistentialRestrictionExpression> restrictions) {
    this.meta = meta;
    this.definedClassId = definedClassId;
    this.genusIds = genusIds;
    this.restrictions = restrictions;
  }

  /**
   * @return the meta
   */
  @JsonProperty
  @Override
  public @Nullable Meta getMeta() {
    return meta;
  }

  /**
   * @return the representativeNodeId
   */
  @JsonProperty
  @Override
  public String getDefinedClassId() {
    return definedClassId;
  }

  /**
   * @return the nodeIds
   */
  @JsonProperty
  @Override
  public List<String> getGenusIds() {
    return genusIds;
  }

  /**
   * @return the restrictions
   */
  @JsonProperty
  @Override
  public List<ExistentialRestrictionExpression> getRestrictions() {
    return restrictions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractLogicalDefinitionAxiom#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final LogicalDefinitionAxiom withMeta(@Nullable Meta value) {
    if (this.meta == value) return this;
    return new LogicalDefinitionAxiom(value, this.definedClassId, this.genusIds, this.restrictions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractLogicalDefinitionAxiom#getDefinedClassId() definedClassId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for definedClassId
   * @return A modified copy of the {@code this} object
   */
  public final LogicalDefinitionAxiom withDefinedClassId(String value) {
    String newValue = Objects.requireNonNull(value, "definedClassId");
    if (this.definedClassId.equals(newValue)) return this;
    return new LogicalDefinitionAxiom(this.meta, newValue, this.genusIds, this.restrictions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractLogicalDefinitionAxiom#getGenusIds() genusIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final LogicalDefinitionAxiom withGenusIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new LogicalDefinitionAxiom(this.meta, this.definedClassId, newValue, this.restrictions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractLogicalDefinitionAxiom#getGenusIds() genusIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of genusIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final LogicalDefinitionAxiom withGenusIds(Iterable<String> elements) {
    if (this.genusIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new LogicalDefinitionAxiom(this.meta, this.definedClassId, newValue, this.restrictions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractLogicalDefinitionAxiom#getRestrictions() restrictions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final LogicalDefinitionAxiom withRestrictions(ExistentialRestrictionExpression... elements) {
    List<ExistentialRestrictionExpression> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new LogicalDefinitionAxiom(this.meta, this.definedClassId, this.genusIds, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractLogicalDefinitionAxiom#getRestrictions() restrictions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of restrictions elements to set
   * @return A modified copy of {@code this} object
   */
  public final LogicalDefinitionAxiom withRestrictions(Iterable<? extends ExistentialRestrictionExpression> elements) {
    if (this.restrictions == elements) return this;
    List<ExistentialRestrictionExpression> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new LogicalDefinitionAxiom(this.meta, this.definedClassId, this.genusIds, newValue);
  }

  /**
   * This instance is equal to all instances of {@code LogicalDefinitionAxiom} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof LogicalDefinitionAxiom
        && equalTo(0, (LogicalDefinitionAxiom) another);
  }

  private boolean equalTo(int synthetic, LogicalDefinitionAxiom another) {
    return Objects.equals(meta, another.meta)
        && definedClassId.equals(another.definedClassId)
        && genusIds.equals(another.genusIds)
        && restrictions.equals(another.restrictions);
  }

  /**
   * Computes a hash code from attributes: {@code meta}, {@code definedClassId}, {@code genusIds}, {@code restrictions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(meta);
    h += (h << 5) + definedClassId.hashCode();
    h += (h << 5) + genusIds.hashCode();
    h += (h << 5) + restrictions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LogicalDefinitionAxiom} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LogicalDefinitionAxiom{"
        + "meta=" + meta
        + ", definedClassId=" + definedClassId
        + ", genusIds=" + genusIds
        + ", restrictions=" + restrictions
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractLogicalDefinitionAxiom", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractLogicalDefinitionAxiom {
    @Nullable Meta meta;
    @Nullable String definedClassId;
    @Nullable List<String> genusIds = Collections.emptyList();
    @Nullable List<ExistentialRestrictionExpression> restrictions = Collections.emptyList();
    @JsonProperty
    public void setMeta(@Nullable Meta meta) {
      this.meta = meta;
    }
    @JsonProperty
    public void setDefinedClassId(String definedClassId) {
      this.definedClassId = definedClassId;
    }
    @JsonProperty
    public void setGenusIds(List<String> genusIds) {
      this.genusIds = genusIds;
    }
    @JsonProperty
    public void setRestrictions(List<ExistentialRestrictionExpression> restrictions) {
      this.restrictions = restrictions;
    }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public String getDefinedClassId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getGenusIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<ExistentialRestrictionExpression> getRestrictions() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static LogicalDefinitionAxiom fromJson(Json json) {
    LogicalDefinitionAxiom.Builder builder = new LogicalDefinitionAxiom.Builder();
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.definedClassId != null) {
      builder.definedClassId(json.definedClassId);
    }
    if (json.genusIds != null) {
      builder.addAllGenusIds(json.genusIds);
    }
    if (json.restrictions != null) {
      builder.addAllRestrictions(json.restrictions);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractLogicalDefinitionAxiom} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LogicalDefinitionAxiom instance
   */
  public static LogicalDefinitionAxiom copyOf(AbstractLogicalDefinitionAxiom instance) {
    if (instance instanceof LogicalDefinitionAxiom) {
      return (LogicalDefinitionAxiom) instance;
    }
    return new LogicalDefinitionAxiom.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link LogicalDefinitionAxiom LogicalDefinitionAxiom}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractLogicalDefinitionAxiom", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DEFINED_CLASS_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Meta meta;
    private @Nullable String definedClassId;
    private List<String> genusIds = new ArrayList<String>();
    private List<ExistentialRestrictionExpression> restrictions = new ArrayList<ExistentialRestrictionExpression>();

    /**
     * Creates a builder for {@link LogicalDefinitionAxiom LogicalDefinitionAxiom} instances.
     * <pre>
     * new LogicalDefinitionAxiom.Builder()
     *    .meta(org.geneontology.obographs.core.model.Meta | null) // nullable {@link AbstractLogicalDefinitionAxiom#getMeta() meta}
     *    .definedClassId(String) // required {@link AbstractLogicalDefinitionAxiom#getDefinedClassId() definedClassId}
     *    .addGenusId|addAllGenusIds(String) // {@link AbstractLogicalDefinitionAxiom#getGenusIds() genusIds} elements
     *    .addRestriction|addAllRestrictions(ExistentialRestrictionExpression) // {@link AbstractLogicalDefinitionAxiom#getRestrictions() restrictions} elements
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.axiom.AbstractLogicalDefinitionAxiom} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractLogicalDefinitionAxiom instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.axiom.Axiom} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Axiom instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractLogicalDefinitionAxiom) {
        AbstractLogicalDefinitionAxiom instance = (AbstractLogicalDefinitionAxiom) object;
        addAllRestrictions(instance.getRestrictions());
        addAllGenusIds(instance.getGenusIds());
        definedClassId(instance.getDefinedClassId());
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof Axiom) {
        Axiom instance = (Axiom) object;
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractLogicalDefinitionAxiom#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(@Nullable Meta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractLogicalDefinitionAxiom#getDefinedClassId() definedClassId} attribute.
     * @param definedClassId The value for definedClassId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder definedClassId(String definedClassId) {
      this.definedClassId = Objects.requireNonNull(definedClassId, "definedClassId");
      initBits &= ~INIT_BIT_DEFINED_CLASS_ID;
      return this;
    }

    /**
     * Adds one element to {@link AbstractLogicalDefinitionAxiom#getGenusIds() genusIds} list.
     * @param element A genusIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGenusId(String element) {
      this.genusIds.add(Objects.requireNonNull(element, "genusIds element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractLogicalDefinitionAxiom#getGenusIds() genusIds} list.
     * @param elements An array of genusIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGenusIds(String... elements) {
      for (String element : elements) {
        this.genusIds.add(Objects.requireNonNull(element, "genusIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractLogicalDefinitionAxiom#getGenusIds() genusIds} list.
     * @param elements An iterable of genusIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder genusIds(Iterable<String> elements) {
      this.genusIds.clear();
      return addAllGenusIds(elements);
    }

    /**
     * Adds elements to {@link AbstractLogicalDefinitionAxiom#getGenusIds() genusIds} list.
     * @param elements An iterable of genusIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGenusIds(Iterable<String> elements) {
      for (String element : elements) {
        this.genusIds.add(Objects.requireNonNull(element, "genusIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractLogicalDefinitionAxiom#getRestrictions() restrictions} list.
     * @param element A restrictions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRestriction(ExistentialRestrictionExpression element) {
      this.restrictions.add(Objects.requireNonNull(element, "restrictions element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractLogicalDefinitionAxiom#getRestrictions() restrictions} list.
     * @param elements An array of restrictions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRestrictions(ExistentialRestrictionExpression... elements) {
      for (ExistentialRestrictionExpression element : elements) {
        this.restrictions.add(Objects.requireNonNull(element, "restrictions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractLogicalDefinitionAxiom#getRestrictions() restrictions} list.
     * @param elements An iterable of restrictions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder restrictions(Iterable<? extends ExistentialRestrictionExpression> elements) {
      this.restrictions.clear();
      return addAllRestrictions(elements);
    }

    /**
     * Adds elements to {@link AbstractLogicalDefinitionAxiom#getRestrictions() restrictions} list.
     * @param elements An iterable of restrictions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRestrictions(Iterable<? extends ExistentialRestrictionExpression> elements) {
      for (ExistentialRestrictionExpression element : elements) {
        this.restrictions.add(Objects.requireNonNull(element, "restrictions element"));
      }
      return this;
    }

    /**
     * Builds a new {@link LogicalDefinitionAxiom LogicalDefinitionAxiom}.
     * @return An immutable instance of LogicalDefinitionAxiom
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public LogicalDefinitionAxiom build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new LogicalDefinitionAxiom(
          meta,
          definedClassId,
          createUnmodifiableList(true, genusIds),
          createUnmodifiableList(true, restrictions));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DEFINED_CLASS_ID) != 0) attributes.add("definedClassId");
      return "Cannot build LogicalDefinitionAxiom, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
