package org.geneontology.obographs.core.model.axiom;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Corresponds to an axiom of the form C = X1 and ... and Xn,
 * Where X_i is either a named class or OWL Restriction
 * 
 * 
 * @author cjm
 */
@Generated(from = "AbstractExistentialRestrictionExpression", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ExistentialRestrictionExpression
    extends AbstractExistentialRestrictionExpression {
  private final String propertyId;
  private final String fillerId;

  private ExistentialRestrictionExpression(String propertyId, String fillerId) {
    this.propertyId = propertyId;
    this.fillerId = fillerId;
  }

  /**
   * @return the propertyId
   */
  @JsonProperty
  @Override
  public String getPropertyId() {
    return propertyId;
  }

  /**
   * @return the representativeNodeId
   */
  @JsonProperty
  @Override
  public String getFillerId() {
    return fillerId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractExistentialRestrictionExpression#getPropertyId() propertyId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for propertyId
   * @return A modified copy of the {@code this} object
   */
  public final ExistentialRestrictionExpression withPropertyId(String value) {
    String newValue = Objects.requireNonNull(value, "propertyId");
    if (this.propertyId.equals(newValue)) return this;
    return new ExistentialRestrictionExpression(newValue, this.fillerId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractExistentialRestrictionExpression#getFillerId() fillerId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fillerId
   * @return A modified copy of the {@code this} object
   */
  public final ExistentialRestrictionExpression withFillerId(String value) {
    String newValue = Objects.requireNonNull(value, "fillerId");
    if (this.fillerId.equals(newValue)) return this;
    return new ExistentialRestrictionExpression(this.propertyId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ExistentialRestrictionExpression} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ExistentialRestrictionExpression
        && equalTo(0, (ExistentialRestrictionExpression) another);
  }

  private boolean equalTo(int synthetic, ExistentialRestrictionExpression another) {
    return propertyId.equals(another.propertyId)
        && fillerId.equals(another.fillerId);
  }

  /**
   * Computes a hash code from attributes: {@code propertyId}, {@code fillerId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + propertyId.hashCode();
    h += (h << 5) + fillerId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExistentialRestrictionExpression} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExistentialRestrictionExpression{"
        + "propertyId=" + propertyId
        + ", fillerId=" + fillerId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractExistentialRestrictionExpression", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends AbstractExistentialRestrictionExpression {
    @Nullable String propertyId;
    @Nullable String fillerId;
    @JsonProperty
    public void setPropertyId(String propertyId) {
      this.propertyId = propertyId;
    }
    @JsonProperty
    public void setFillerId(String fillerId) {
      this.fillerId = fillerId;
    }
    @Override
    public String getPropertyId() { throw new UnsupportedOperationException(); }
    @Override
    public String getFillerId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ExistentialRestrictionExpression fromJson(Json json) {
    ExistentialRestrictionExpression.Builder builder = new ExistentialRestrictionExpression.Builder();
    if (json.propertyId != null) {
      builder.propertyId(json.propertyId);
    }
    if (json.fillerId != null) {
      builder.fillerId(json.fillerId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractExistentialRestrictionExpression} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExistentialRestrictionExpression instance
   */
  public static ExistentialRestrictionExpression copyOf(AbstractExistentialRestrictionExpression instance) {
    if (instance instanceof ExistentialRestrictionExpression) {
      return (ExistentialRestrictionExpression) instance;
    }
    return new ExistentialRestrictionExpression.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ExistentialRestrictionExpression ExistentialRestrictionExpression}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractExistentialRestrictionExpression", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROPERTY_ID = 0x1L;
    private static final long INIT_BIT_FILLER_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String propertyId;
    private @Nullable String fillerId;

    /**
     * Creates a builder for {@link ExistentialRestrictionExpression ExistentialRestrictionExpression} instances.
     * <pre>
     * new ExistentialRestrictionExpression.Builder()
     *    .propertyId(String) // required {@link AbstractExistentialRestrictionExpression#getPropertyId() propertyId}
     *    .fillerId(String) // required {@link AbstractExistentialRestrictionExpression#getFillerId() fillerId}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractExistentialRestrictionExpression} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractExistentialRestrictionExpression instance) {
      Objects.requireNonNull(instance, "instance");
      propertyId(instance.getPropertyId());
      fillerId(instance.getFillerId());
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractExistentialRestrictionExpression#getPropertyId() propertyId} attribute.
     * @param propertyId The value for propertyId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder propertyId(String propertyId) {
      this.propertyId = Objects.requireNonNull(propertyId, "propertyId");
      initBits &= ~INIT_BIT_PROPERTY_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractExistentialRestrictionExpression#getFillerId() fillerId} attribute.
     * @param fillerId The value for fillerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fillerId(String fillerId) {
      this.fillerId = Objects.requireNonNull(fillerId, "fillerId");
      initBits &= ~INIT_BIT_FILLER_ID;
      return this;
    }

    /**
     * Builds a new {@link ExistentialRestrictionExpression ExistentialRestrictionExpression}.
     * @return An immutable instance of ExistentialRestrictionExpression
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ExistentialRestrictionExpression build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ExistentialRestrictionExpression(propertyId, fillerId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROPERTY_ID) != 0) attributes.add("propertyId");
      if ((initBits & INIT_BIT_FILLER_ID) != 0) attributes.add("fillerId");
      return "Cannot build ExistentialRestrictionExpression, some of required attributes are not set " + attributes;
    }
  }
}
