package org.geneontology.obographs.core.model.axiom;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.Meta;
import org.immutables.value.Generated;

/**
 * A set of nodes that all stand in a mutual equivalence or identity relationship to one another
 * <p>
 * Corresponds to Node in the OWLAPI
 * 
 * 
 * @author cjm
 */
@Generated(from = "AbstractEquivalentNodesSet", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class EquivalentNodesSet
    extends AbstractEquivalentNodesSet {
  private final @Nullable Meta meta;
  private final String representativeNodeId;
  private final Set<String> nodeIds;

  private EquivalentNodesSet(EquivalentNodesSet.Builder builder) {
    this.meta = builder.meta;
    this.nodeIds = createUnmodifiableSet(builder.nodeIds);
    this.representativeNodeId = builder.representativeNodeId != null
        ? builder.representativeNodeId
        : Objects.requireNonNull(super.getRepresentativeNodeId(), "representativeNodeId");
  }

  private EquivalentNodesSet(
      @Nullable Meta meta,
      String representativeNodeId,
      Set<String> nodeIds) {
    this.meta = meta;
    this.representativeNodeId = representativeNodeId;
    this.nodeIds = nodeIds;
  }

  /**
   * @return the meta
   */
  @JsonProperty
  @Override
  public @Nullable Meta getMeta() {
    return meta;
  }

  /**
   * @return the representativeNodeId
   */
  @JsonProperty
  @Override
  public String getRepresentativeNodeId() {
    return representativeNodeId;
  }

  /**
   * @return the nodeIds
   */
  @JsonProperty
  @Override
  public Set<String> getNodeIds() {
    return nodeIds;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractEquivalentNodesSet#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final EquivalentNodesSet withMeta(@Nullable Meta value) {
    if (this.meta == value) return this;
    return new EquivalentNodesSet(value, this.representativeNodeId, this.nodeIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractEquivalentNodesSet#getRepresentativeNodeId() representativeNodeId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for representativeNodeId
   * @return A modified copy of the {@code this} object
   */
  public final EquivalentNodesSet withRepresentativeNodeId(String value) {
    String newValue = Objects.requireNonNull(value, "representativeNodeId");
    if (this.representativeNodeId.equals(newValue)) return this;
    return new EquivalentNodesSet(this.meta, newValue, this.nodeIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractEquivalentNodesSet#getNodeIds() nodeIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final EquivalentNodesSet withNodeIds(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new EquivalentNodesSet(this.meta, this.representativeNodeId, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractEquivalentNodesSet#getNodeIds() nodeIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nodeIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final EquivalentNodesSet withNodeIds(Iterable<String> elements) {
    if (this.nodeIds == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new EquivalentNodesSet(this.meta, this.representativeNodeId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code EquivalentNodesSet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof EquivalentNodesSet
        && equalTo(0, (EquivalentNodesSet) another);
  }

  private boolean equalTo(int synthetic, EquivalentNodesSet another) {
    return Objects.equals(meta, another.meta)
        && representativeNodeId.equals(another.representativeNodeId)
        && nodeIds.equals(another.nodeIds);
  }

  /**
   * Computes a hash code from attributes: {@code meta}, {@code representativeNodeId}, {@code nodeIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(meta);
    h += (h << 5) + representativeNodeId.hashCode();
    h += (h << 5) + nodeIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EquivalentNodesSet} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EquivalentNodesSet{"
        + "meta=" + meta
        + ", representativeNodeId=" + representativeNodeId
        + ", nodeIds=" + nodeIds
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractEquivalentNodesSet", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractEquivalentNodesSet {
    @Nullable Meta meta;
    @Nullable String representativeNodeId;
    @Nullable Set<String> nodeIds = Collections.emptySet();
    @JsonProperty
    public void setMeta(@Nullable Meta meta) {
      this.meta = meta;
    }
    @JsonProperty
    public void setRepresentativeNodeId(String representativeNodeId) {
      this.representativeNodeId = representativeNodeId;
    }
    @JsonProperty
    public void setNodeIds(Set<String> nodeIds) {
      this.nodeIds = nodeIds;
    }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public String getRepresentativeNodeId() { throw new UnsupportedOperationException(); }
    @Override
    public Set<String> getNodeIds() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static EquivalentNodesSet fromJson(Json json) {
    EquivalentNodesSet.Builder builder = new EquivalentNodesSet.Builder();
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.representativeNodeId != null) {
      builder.representativeNodeId(json.representativeNodeId);
    }
    if (json.nodeIds != null) {
      builder.addAllNodeIds(json.nodeIds);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractEquivalentNodesSet} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EquivalentNodesSet instance
   */
  public static EquivalentNodesSet copyOf(AbstractEquivalentNodesSet instance) {
    if (instance instanceof EquivalentNodesSet) {
      return (EquivalentNodesSet) instance;
    }
    return new EquivalentNodesSet.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link EquivalentNodesSet EquivalentNodesSet}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractEquivalentNodesSet", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Meta meta;
    private @Nullable String representativeNodeId;
    private List<String> nodeIds = new ArrayList<String>();

    /**
     * Creates a builder for {@link EquivalentNodesSet EquivalentNodesSet} instances.
     * <pre>
     * new EquivalentNodesSet.Builder()
     *    .meta(org.geneontology.obographs.core.model.Meta | null) // nullable {@link AbstractEquivalentNodesSet#getMeta() meta}
     *    .representativeNodeId(String) // optional {@link AbstractEquivalentNodesSet#getRepresentativeNodeId() representativeNodeId}
     *    .addNodeId|addAllNodeIds(String) // {@link AbstractEquivalentNodesSet#getNodeIds() nodeIds} elements
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.axiom.AbstractEquivalentNodesSet} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractEquivalentNodesSet instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.axiom.Axiom} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Axiom instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractEquivalentNodesSet) {
        AbstractEquivalentNodesSet instance = (AbstractEquivalentNodesSet) object;
        addAllNodeIds(instance.getNodeIds());
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
        representativeNodeId(instance.getRepresentativeNodeId());
      }
      if (object instanceof Axiom) {
        Axiom instance = (Axiom) object;
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractEquivalentNodesSet#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(@Nullable Meta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractEquivalentNodesSet#getRepresentativeNodeId() representativeNodeId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractEquivalentNodesSet#getRepresentativeNodeId() representativeNodeId}.</em>
     * @param representativeNodeId The value for representativeNodeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder representativeNodeId(String representativeNodeId) {
      this.representativeNodeId = Objects.requireNonNull(representativeNodeId, "representativeNodeId");
      return this;
    }

    /**
     * Adds one element to {@link AbstractEquivalentNodesSet#getNodeIds() nodeIds} set.
     * @param element A nodeIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNodeId(String element) {
      this.nodeIds.add(Objects.requireNonNull(element, "nodeIds element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractEquivalentNodesSet#getNodeIds() nodeIds} set.
     * @param elements An array of nodeIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNodeIds(String... elements) {
      for (String element : elements) {
        this.nodeIds.add(Objects.requireNonNull(element, "nodeIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractEquivalentNodesSet#getNodeIds() nodeIds} set.
     * @param elements An iterable of nodeIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nodeIds(Iterable<String> elements) {
      this.nodeIds.clear();
      return addAllNodeIds(elements);
    }

    /**
     * Adds elements to {@link AbstractEquivalentNodesSet#getNodeIds() nodeIds} set.
     * @param elements An iterable of nodeIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNodeIds(Iterable<String> elements) {
      for (String element : elements) {
        this.nodeIds.add(Objects.requireNonNull(element, "nodeIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link EquivalentNodesSet EquivalentNodesSet}.
     * @return An immutable instance of EquivalentNodesSet
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public EquivalentNodesSet build() {
      return new EquivalentNodesSet(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size() * 4 / 3 + 1);
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
