package org.geneontology.obographs.core.model.axiom;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.Edge;
import org.geneontology.obographs.core.model.Meta;
import org.immutables.value.Generated;

/**
 * This combined ObjectPropertyDomain, ObjectPropertyRange, and some AllValuesFrom expressions into a single convenience structure
 * @author cjm
 */
@Generated(from = "AbstractDomainRangeAxiom", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class DomainRangeAxiom
    extends AbstractDomainRangeAxiom {
  private final @Nullable Meta meta;
  private final String predicateId;
  private final Set<String> domainClassIds;
  private final Set<String> rangeClassIds;
  private final Set<Edge> allValuesFromEdges;

  private DomainRangeAxiom(
      @Nullable Meta meta,
      String predicateId,
      Set<String> domainClassIds,
      Set<String> rangeClassIds,
      Set<Edge> allValuesFromEdges) {
    this.meta = meta;
    this.predicateId = predicateId;
    this.domainClassIds = domainClassIds;
    this.rangeClassIds = rangeClassIds;
    this.allValuesFromEdges = allValuesFromEdges;
  }

  /**
   * @return the meta
   */
  @JsonProperty
  @Override
  public @Nullable Meta getMeta() {
    return meta;
  }

  /**
   * @return the predicateId
   */
  @JsonProperty
  @Override
  public String getPredicateId() {
    return predicateId;
  }

  /**
   * For multiple domains, this is treated as intersection
   * @return the domainClassIds
   */
  @JsonProperty
  @Override
  public Set<String> getDomainClassIds() {
    return domainClassIds;
  }

  /**
   * For multiple ranges, this is treated as intersection
   * @return the rangeClassIds
   */
  @JsonProperty
  @Override
  public Set<String> getRangeClassIds() {
    return rangeClassIds;
  }

  /**
   * Set of edges representing `X SubClassOf P only Y` axioms.
   * <p>
   * Note that these are not in the main graph.edges object, as the edge
   * graph is intended to be an existential graph. Most applications that do
   * not perform a reasoning function have no use for universal axioms.
   * @return the allValuesFromEdges
   */
  @JsonProperty
  @Override
  public Set<Edge> getAllValuesFromEdges() {
    return allValuesFromEdges;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractDomainRangeAxiom#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final DomainRangeAxiom withMeta(@Nullable Meta value) {
    if (this.meta == value) return this;
    return new DomainRangeAxiom(value, this.predicateId, this.domainClassIds, this.rangeClassIds, this.allValuesFromEdges);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractDomainRangeAxiom#getPredicateId() predicateId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for predicateId
   * @return A modified copy of the {@code this} object
   */
  public final DomainRangeAxiom withPredicateId(String value) {
    String newValue = Objects.requireNonNull(value, "predicateId");
    if (this.predicateId.equals(newValue)) return this;
    return new DomainRangeAxiom(this.meta, newValue, this.domainClassIds, this.rangeClassIds, this.allValuesFromEdges);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractDomainRangeAxiom#getDomainClassIds() domainClassIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final DomainRangeAxiom withDomainClassIds(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new DomainRangeAxiom(this.meta, this.predicateId, newValue, this.rangeClassIds, this.allValuesFromEdges);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractDomainRangeAxiom#getDomainClassIds() domainClassIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of domainClassIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final DomainRangeAxiom withDomainClassIds(Iterable<String> elements) {
    if (this.domainClassIds == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new DomainRangeAxiom(this.meta, this.predicateId, newValue, this.rangeClassIds, this.allValuesFromEdges);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractDomainRangeAxiom#getRangeClassIds() rangeClassIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final DomainRangeAxiom withRangeClassIds(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new DomainRangeAxiom(this.meta, this.predicateId, this.domainClassIds, newValue, this.allValuesFromEdges);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractDomainRangeAxiom#getRangeClassIds() rangeClassIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of rangeClassIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final DomainRangeAxiom withRangeClassIds(Iterable<String> elements) {
    if (this.rangeClassIds == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new DomainRangeAxiom(this.meta, this.predicateId, this.domainClassIds, newValue, this.allValuesFromEdges);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractDomainRangeAxiom#getAllValuesFromEdges() allValuesFromEdges}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final DomainRangeAxiom withAllValuesFromEdges(Edge... elements) {
    Set<Edge> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new DomainRangeAxiom(this.meta, this.predicateId, this.domainClassIds, this.rangeClassIds, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractDomainRangeAxiom#getAllValuesFromEdges() allValuesFromEdges}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of allValuesFromEdges elements to set
   * @return A modified copy of {@code this} object
   */
  public final DomainRangeAxiom withAllValuesFromEdges(Iterable<? extends Edge> elements) {
    if (this.allValuesFromEdges == elements) return this;
    Set<Edge> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new DomainRangeAxiom(this.meta, this.predicateId, this.domainClassIds, this.rangeClassIds, newValue);
  }

  /**
   * This instance is equal to all instances of {@code DomainRangeAxiom} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof DomainRangeAxiom
        && equalTo(0, (DomainRangeAxiom) another);
  }

  private boolean equalTo(int synthetic, DomainRangeAxiom another) {
    return Objects.equals(meta, another.meta)
        && predicateId.equals(another.predicateId)
        && domainClassIds.equals(another.domainClassIds)
        && rangeClassIds.equals(another.rangeClassIds)
        && allValuesFromEdges.equals(another.allValuesFromEdges);
  }

  /**
   * Computes a hash code from attributes: {@code meta}, {@code predicateId}, {@code domainClassIds}, {@code rangeClassIds}, {@code allValuesFromEdges}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(meta);
    h += (h << 5) + predicateId.hashCode();
    h += (h << 5) + domainClassIds.hashCode();
    h += (h << 5) + rangeClassIds.hashCode();
    h += (h << 5) + allValuesFromEdges.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DomainRangeAxiom} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DomainRangeAxiom{"
        + "meta=" + meta
        + ", predicateId=" + predicateId
        + ", domainClassIds=" + domainClassIds
        + ", rangeClassIds=" + rangeClassIds
        + ", allValuesFromEdges=" + allValuesFromEdges
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractDomainRangeAxiom", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractDomainRangeAxiom {
    @Nullable Meta meta;
    @Nullable String predicateId;
    @Nullable Set<String> domainClassIds = Collections.emptySet();
    @Nullable Set<String> rangeClassIds = Collections.emptySet();
    @Nullable Set<Edge> allValuesFromEdges = Collections.emptySet();
    @JsonProperty
    public void setMeta(@Nullable Meta meta) {
      this.meta = meta;
    }
    @JsonProperty
    public void setPredicateId(String predicateId) {
      this.predicateId = predicateId;
    }
    @JsonProperty
    public void setDomainClassIds(Set<String> domainClassIds) {
      this.domainClassIds = domainClassIds;
    }
    @JsonProperty
    public void setRangeClassIds(Set<String> rangeClassIds) {
      this.rangeClassIds = rangeClassIds;
    }
    @JsonProperty
    public void setAllValuesFromEdges(Set<Edge> allValuesFromEdges) {
      this.allValuesFromEdges = allValuesFromEdges;
    }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public String getPredicateId() { throw new UnsupportedOperationException(); }
    @Override
    public Set<String> getDomainClassIds() { throw new UnsupportedOperationException(); }
    @Override
    public Set<String> getRangeClassIds() { throw new UnsupportedOperationException(); }
    @Override
    public Set<Edge> getAllValuesFromEdges() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static DomainRangeAxiom fromJson(Json json) {
    DomainRangeAxiom.Builder builder = new DomainRangeAxiom.Builder();
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.predicateId != null) {
      builder.predicateId(json.predicateId);
    }
    if (json.domainClassIds != null) {
      builder.addAllDomainClassIds(json.domainClassIds);
    }
    if (json.rangeClassIds != null) {
      builder.addAllRangeClassIds(json.rangeClassIds);
    }
    if (json.allValuesFromEdges != null) {
      builder.addAllAllValuesFromEdges(json.allValuesFromEdges);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractDomainRangeAxiom} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DomainRangeAxiom instance
   */
  public static DomainRangeAxiom copyOf(AbstractDomainRangeAxiom instance) {
    if (instance instanceof DomainRangeAxiom) {
      return (DomainRangeAxiom) instance;
    }
    return new DomainRangeAxiom.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link DomainRangeAxiom DomainRangeAxiom}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractDomainRangeAxiom", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PREDICATE_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Meta meta;
    private @Nullable String predicateId;
    private List<String> domainClassIds = new ArrayList<String>();
    private List<String> rangeClassIds = new ArrayList<String>();
    private List<Edge> allValuesFromEdges = new ArrayList<Edge>();

    /**
     * Creates a builder for {@link DomainRangeAxiom DomainRangeAxiom} instances.
     * <pre>
     * new DomainRangeAxiom.Builder()
     *    .meta(org.geneontology.obographs.core.model.Meta | null) // nullable {@link AbstractDomainRangeAxiom#getMeta() meta}
     *    .predicateId(String) // required {@link AbstractDomainRangeAxiom#getPredicateId() predicateId}
     *    .addDomainClassId|addAllDomainClassIds(String) // {@link AbstractDomainRangeAxiom#getDomainClassIds() domainClassIds} elements
     *    .addRangeClassId|addAllRangeClassIds(String) // {@link AbstractDomainRangeAxiom#getRangeClassIds() rangeClassIds} elements
     *    .addAllValuesFromEdge|addAllAllValuesFromEdges(org.geneontology.obographs.core.model.Edge) // {@link AbstractDomainRangeAxiom#getAllValuesFromEdges() allValuesFromEdges} elements
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.axiom.AbstractDomainRangeAxiom} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractDomainRangeAxiom instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.axiom.Axiom} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Axiom instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractDomainRangeAxiom) {
        AbstractDomainRangeAxiom instance = (AbstractDomainRangeAxiom) object;
        addAllDomainClassIds(instance.getDomainClassIds());
        predicateId(instance.getPredicateId());
        addAllRangeClassIds(instance.getRangeClassIds());
        addAllAllValuesFromEdges(instance.getAllValuesFromEdges());
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof Axiom) {
        Axiom instance = (Axiom) object;
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractDomainRangeAxiom#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(@Nullable Meta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractDomainRangeAxiom#getPredicateId() predicateId} attribute.
     * @param predicateId The value for predicateId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder predicateId(String predicateId) {
      this.predicateId = Objects.requireNonNull(predicateId, "predicateId");
      initBits &= ~INIT_BIT_PREDICATE_ID;
      return this;
    }

    /**
     * Adds one element to {@link AbstractDomainRangeAxiom#getDomainClassIds() domainClassIds} set.
     * @param element A domainClassIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDomainClassId(String element) {
      this.domainClassIds.add(Objects.requireNonNull(element, "domainClassIds element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractDomainRangeAxiom#getDomainClassIds() domainClassIds} set.
     * @param elements An array of domainClassIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDomainClassIds(String... elements) {
      for (String element : elements) {
        this.domainClassIds.add(Objects.requireNonNull(element, "domainClassIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractDomainRangeAxiom#getDomainClassIds() domainClassIds} set.
     * @param elements An iterable of domainClassIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainClassIds(Iterable<String> elements) {
      this.domainClassIds.clear();
      return addAllDomainClassIds(elements);
    }

    /**
     * Adds elements to {@link AbstractDomainRangeAxiom#getDomainClassIds() domainClassIds} set.
     * @param elements An iterable of domainClassIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomainClassIds(Iterable<String> elements) {
      for (String element : elements) {
        this.domainClassIds.add(Objects.requireNonNull(element, "domainClassIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractDomainRangeAxiom#getRangeClassIds() rangeClassIds} set.
     * @param element A rangeClassIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRangeClassId(String element) {
      this.rangeClassIds.add(Objects.requireNonNull(element, "rangeClassIds element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractDomainRangeAxiom#getRangeClassIds() rangeClassIds} set.
     * @param elements An array of rangeClassIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRangeClassIds(String... elements) {
      for (String element : elements) {
        this.rangeClassIds.add(Objects.requireNonNull(element, "rangeClassIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractDomainRangeAxiom#getRangeClassIds() rangeClassIds} set.
     * @param elements An iterable of rangeClassIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rangeClassIds(Iterable<String> elements) {
      this.rangeClassIds.clear();
      return addAllRangeClassIds(elements);
    }

    /**
     * Adds elements to {@link AbstractDomainRangeAxiom#getRangeClassIds() rangeClassIds} set.
     * @param elements An iterable of rangeClassIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRangeClassIds(Iterable<String> elements) {
      for (String element : elements) {
        this.rangeClassIds.add(Objects.requireNonNull(element, "rangeClassIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractDomainRangeAxiom#getAllValuesFromEdges() allValuesFromEdges} set.
     * @param element A allValuesFromEdges element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllValuesFromEdge(Edge element) {
      this.allValuesFromEdges.add(Objects.requireNonNull(element, "allValuesFromEdges element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractDomainRangeAxiom#getAllValuesFromEdges() allValuesFromEdges} set.
     * @param elements An array of allValuesFromEdges elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllValuesFromEdges(Edge... elements) {
      for (Edge element : elements) {
        this.allValuesFromEdges.add(Objects.requireNonNull(element, "allValuesFromEdges element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractDomainRangeAxiom#getAllValuesFromEdges() allValuesFromEdges} set.
     * @param elements An iterable of allValuesFromEdges elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allValuesFromEdges(Iterable<? extends Edge> elements) {
      this.allValuesFromEdges.clear();
      return addAllAllValuesFromEdges(elements);
    }

    /**
     * Adds elements to {@link AbstractDomainRangeAxiom#getAllValuesFromEdges() allValuesFromEdges} set.
     * @param elements An iterable of allValuesFromEdges elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllValuesFromEdges(Iterable<? extends Edge> elements) {
      for (Edge element : elements) {
        this.allValuesFromEdges.add(Objects.requireNonNull(element, "allValuesFromEdges element"));
      }
      return this;
    }

    /**
     * Builds a new {@link DomainRangeAxiom DomainRangeAxiom}.
     * @return An immutable instance of DomainRangeAxiom
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DomainRangeAxiom build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DomainRangeAxiom(
          meta,
          predicateId,
          createUnmodifiableSet(domainClassIds),
          createUnmodifiableSet(rangeClassIds),
          createUnmodifiableSet(allValuesFromEdges));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PREDICATE_ID) != 0) attributes.add("predicateId");
      return "Cannot build DomainRangeAxiom, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size() * 4 / 3 + 1);
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
