package org.geneontology.obographs.core.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A graph node corresponds to a class, individual or property
 * <p>
 * ![Node UML](node-uml.png)
 * 
 * @startuml node-uml.png
 * class Node {
 *   String id
 * }
 * class Meta
 * 
 * Node-->Meta : 0..1
 * @enduml
 * 
 * @author cjm
 */
@Generated(from = "AbstractNode", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class Node extends AbstractNode {
  private final @Nullable Meta meta;
  private final String id;
  private final String label;
  private final @Nullable AbstractNode.RDFTYPES type;
  private final @Nullable AbstractNode.PropertyType propertyType;

  private Node(Node.Builder builder) {
    this.meta = builder.meta;
    this.type = builder.type;
    this.propertyType = builder.propertyType;
    if (builder.id != null) {
      initShim.id(builder.id);
    }
    if (builder.label != null) {
      initShim.label(builder.label);
    }
    this.id = initShim.getId();
    this.label = initShim.getLabel();
    this.initShim = null;
  }

  private Node(
      @Nullable Meta meta,
      String id,
      String label,
      @Nullable AbstractNode.RDFTYPES type,
      @Nullable AbstractNode.PropertyType propertyType) {
    this.meta = meta;
    this.id = id;
    this.label = label;
    this.type = type;
    this.propertyType = propertyType;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "AbstractNode", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(Node.super.getId(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void id(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte labelBuildStage = STAGE_UNINITIALIZED;
    private String label;

    String getLabel() {
      if (labelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (labelBuildStage == STAGE_UNINITIALIZED) {
        labelBuildStage = STAGE_INITIALIZING;
        this.label = Objects.requireNonNull(Node.super.getLabel(), "label");
        labelBuildStage = STAGE_INITIALIZED;
      }
      return this.label;
    }

    void label(String label) {
      this.label = label;
      labelBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (labelBuildStage == STAGE_INITIALIZING) attributes.add("label");
      return "Cannot build Node, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return the meta
   */
  @JsonProperty
  @Override
  public @Nullable Meta getMeta() {
    return meta;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("lbl")
  @Override
  public String getLabel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLabel()
        : this.label;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public @Nullable AbstractNode.RDFTYPES getType() {
    return type;
  }

  /**
   * @return The value of the {@code propertyType} attribute
   */
  @JsonProperty
  @Override
  public @Nullable AbstractNode.PropertyType getPropertyType() {
    return propertyType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractNode#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Node withMeta(@Nullable Meta value) {
    if (this.meta == value) return this;
    return new Node(value, this.id, this.label, this.type, this.propertyType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractNode#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final Node withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new Node(this.meta, newValue, this.label, this.type, this.propertyType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractNode#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final Node withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new Node(this.meta, this.id, newValue, this.type, this.propertyType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractNode#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Node withType(@Nullable AbstractNode.RDFTYPES value) {
    if (this.type == value) return this;
    return new Node(this.meta, this.id, this.label, value, this.propertyType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractNode#getPropertyType() propertyType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for propertyType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Node withPropertyType(@Nullable AbstractNode.PropertyType value) {
    if (this.propertyType == value) return this;
    return new Node(this.meta, this.id, this.label, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code Node} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Node
        && equalTo(0, (Node) another);
  }

  private boolean equalTo(int synthetic, Node another) {
    return Objects.equals(meta, another.meta)
        && id.equals(another.id)
        && label.equals(another.label)
        && Objects.equals(type, another.type)
        && Objects.equals(propertyType, another.propertyType);
  }

  /**
   * Computes a hash code from attributes: {@code meta}, {@code id}, {@code label}, {@code type}, {@code propertyType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(meta);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + label.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(propertyType);
    return h;
  }

  /**
   * Prints the immutable value {@code Node} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Node{"
        + "meta=" + meta
        + ", id=" + id
        + ", label=" + label
        + ", type=" + type
        + ", propertyType=" + propertyType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractNode", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractNode {
    @Nullable Meta meta;
    @Nullable String id;
    @Nullable String label;
    @Nullable AbstractNode.RDFTYPES type;
    @Nullable AbstractNode.PropertyType propertyType;
    @JsonProperty
    public void setMeta(@Nullable Meta meta) {
      this.meta = meta;
    }
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("lbl")
    public void setLabel(String label) {
      this.label = label;
    }
    @JsonProperty
    public void setType(@Nullable AbstractNode.RDFTYPES type) {
      this.type = type;
    }
    @JsonProperty
    public void setPropertyType(@Nullable AbstractNode.PropertyType propertyType) {
      this.propertyType = propertyType;
    }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public AbstractNode.RDFTYPES getType() { throw new UnsupportedOperationException(); }
    @Override
    public AbstractNode.PropertyType getPropertyType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Node fromJson(Json json) {
    Node.Builder builder = new Node.Builder();
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.label != null) {
      builder.label(json.label);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.propertyType != null) {
      builder.propertyType(json.propertyType);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractNode} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Node instance
   */
  public static Node copyOf(AbstractNode instance) {
    if (instance instanceof Node) {
      return (Node) instance;
    }
    return new Node.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link Node Node}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractNode", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Meta meta;
    private @Nullable String id;
    private @Nullable String label;
    private @Nullable AbstractNode.RDFTYPES type;
    private @Nullable AbstractNode.PropertyType propertyType;

    /**
     * Creates a builder for {@link Node Node} instances.
     * <pre>
     * new Node.Builder()
     *    .meta(org.geneontology.obographs.core.model.Meta | null) // nullable {@link AbstractNode#getMeta() meta}
     *    .id(String) // optional {@link AbstractNode#getId() id}
     *    .label(String) // optional {@link AbstractNode#getLabel() label}
     *    .type(org.geneontology.obographs.core.model.AbstractNode.RDFTYPES | null) // nullable {@link AbstractNode#getType() type}
     *    .propertyType(org.geneontology.obographs.core.model.AbstractNode.PropertyType | null) // nullable {@link AbstractNode#getPropertyType() propertyType}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.NodeOrEdge} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(NodeOrEdge instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.AbstractNode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractNode instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof NodeOrEdge) {
        NodeOrEdge instance = (NodeOrEdge) object;
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractNode) {
        AbstractNode instance = (AbstractNode) object;
        label(instance.getLabel());
        id(instance.getId());
        @Nullable AbstractNode.RDFTYPES typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
        @Nullable AbstractNode.PropertyType propertyTypeValue = instance.getPropertyType();
        if (propertyTypeValue != null) {
          propertyType(propertyTypeValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractNode#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(@Nullable Meta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractNode#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractNode#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractNode#getLabel() label} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractNode#getLabel() label}.</em>
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractNode#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable AbstractNode.RDFTYPES type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractNode#getPropertyType() propertyType} attribute.
     * @param propertyType The value for propertyType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder propertyType(@Nullable AbstractNode.PropertyType propertyType) {
      this.propertyType = propertyType;
      return this;
    }

    /**
     * Builds a new {@link Node Node}.
     * @return An immutable instance of Node
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Node build() {
      return new Node(this);
    }
  }
}
