package org.geneontology.obographs.core.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.meta.*;
import org.immutables.value.Generated;

/**
 * A holder for metadata
 * The information in a Meta object consists sets of {@link PropertyValue} objects,
 * which associate the Meta object holder with some value via some property.
 * The set of PropertyValue objects can be partitioned into two subsets:
 *  1. PropertyValues corresponding to a specific explicitly modeled property type (e.g synonym)
 *  2. generic {@link BasicPropertyValue}s - anything property not explicitly modeled
 * @author cjm
 */
@Generated(from = "AbstractMeta", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class Meta extends AbstractMeta {
  private final @Nullable DefinitionPropertyValue definition;
  private final List<String> comments;
  private final List<String> subsets;
  private final List<SynonymPropertyValue> synonyms;
  private final List<XrefPropertyValue> xrefs;
  private final List<String> xrefsValues;
  private final List<BasicPropertyValue> basicPropertyValues;
  private final String version;
  private final boolean deprecated;

  private Meta(Meta.Builder builder) {
    this.definition = builder.definition;
    this.comments = createUnmodifiableList(true, builder.comments);
    this.subsets = createUnmodifiableList(true, builder.subsets);
    this.synonyms = createUnmodifiableList(true, builder.synonyms);
    this.xrefs = createUnmodifiableList(true, builder.xrefs);
    this.basicPropertyValues = createUnmodifiableList(true, builder.basicPropertyValues);
    if (builder.xrefsValuesIsSet()) {
      initShim.xrefsValues(createUnmodifiableList(true, builder.xrefsValues));
    }
    if (builder.version != null) {
      initShim.version(builder.version);
    }
    if (builder.deprecatedIsSet()) {
      initShim.deprecated(builder.deprecated);
    }
    this.xrefsValues = initShim.getXrefsValues();
    this.version = initShim.getVersion();
    this.deprecated = initShim.getDeprecated();
    this.initShim = null;
  }

  private Meta(
      @Nullable DefinitionPropertyValue definition,
      List<String> comments,
      List<String> subsets,
      List<SynonymPropertyValue> synonyms,
      List<XrefPropertyValue> xrefs,
      List<String> xrefsValues,
      List<BasicPropertyValue> basicPropertyValues,
      String version,
      boolean deprecated) {
    this.definition = definition;
    this.comments = comments;
    this.subsets = subsets;
    this.synonyms = synonyms;
    this.xrefs = xrefs;
    this.xrefsValues = xrefsValues;
    this.basicPropertyValues = basicPropertyValues;
    this.version = version;
    this.deprecated = deprecated;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "AbstractMeta", generator = "Immutables")
  private final class InitShim {
    private byte xrefsValuesBuildStage = STAGE_UNINITIALIZED;
    private List<String> xrefsValues;

    List<String> getXrefsValues() {
      if (xrefsValuesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (xrefsValuesBuildStage == STAGE_UNINITIALIZED) {
        xrefsValuesBuildStage = STAGE_INITIALIZING;
        this.xrefsValues = createUnmodifiableList(false, createSafeList(Meta.super.getXrefsValues(), true, false));
        xrefsValuesBuildStage = STAGE_INITIALIZED;
      }
      return this.xrefsValues;
    }

    void xrefsValues(List<String> xrefsValues) {
      this.xrefsValues = xrefsValues;
      xrefsValuesBuildStage = STAGE_INITIALIZED;
    }

    private byte versionBuildStage = STAGE_UNINITIALIZED;
    private String version;

    String getVersion() {
      if (versionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (versionBuildStage == STAGE_UNINITIALIZED) {
        versionBuildStage = STAGE_INITIALIZING;
        this.version = Objects.requireNonNull(Meta.super.getVersion(), "version");
        versionBuildStage = STAGE_INITIALIZED;
      }
      return this.version;
    }

    void version(String version) {
      this.version = version;
      versionBuildStage = STAGE_INITIALIZED;
    }

    private byte deprecatedBuildStage = STAGE_UNINITIALIZED;
    private boolean deprecated;

    boolean getDeprecated() {
      if (deprecatedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (deprecatedBuildStage == STAGE_UNINITIALIZED) {
        deprecatedBuildStage = STAGE_INITIALIZING;
        this.deprecated = Meta.super.getDeprecated();
        deprecatedBuildStage = STAGE_INITIALIZED;
      }
      return this.deprecated;
    }

    void deprecated(boolean deprecated) {
      this.deprecated = deprecated;
      deprecatedBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (xrefsValuesBuildStage == STAGE_INITIALIZING) attributes.add("xrefsValues");
      if (versionBuildStage == STAGE_INITIALIZING) attributes.add("version");
      if (deprecatedBuildStage == STAGE_INITIALIZING) attributes.add("deprecated");
      return "Cannot build Meta, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code definition} attribute
   */
  @JsonProperty
  @Override
  public @Nullable DefinitionPropertyValue getDefinition() {
    return definition;
  }

  /**
   * @return The value of the {@code comments} attribute
   */
  @JsonProperty
  @Override
  public List<String> getComments() {
    return comments;
  }

  /**
   * @return The value of the {@code subsets} attribute
   */
  @JsonProperty
  @Override
  public List<String> getSubsets() {
    return subsets;
  }

  /**
   * @return The value of the {@code synonyms} attribute
   */
  @JsonProperty
  @Override
  public List<SynonymPropertyValue> getSynonyms() {
    return synonyms;
  }

  /**
   * @return The value of the {@code xrefs} attribute
   */
  @JsonProperty
  @Override
  public List<XrefPropertyValue> getXrefs() {
    return xrefs;
  }

  /**
   * @return The value of the {@code xrefsValues} attribute
   */
  @JsonProperty("xrefsValues")
  @JsonIgnore
  @Override
  public List<String> getXrefsValues() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getXrefsValues()
        : this.xrefsValues;
  }

  /**
   * @return The value of the {@code basicPropertyValues} attribute
   */
  @JsonProperty
  @Override
  public List<BasicPropertyValue> getBasicPropertyValues() {
    return basicPropertyValues;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty
  @Override
  public String getVersion() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getVersion()
        : this.version;
  }

  /**
   * @return The value of the {@code deprecated} attribute
   */
  @JsonProperty
  @Override
  public boolean getDeprecated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDeprecated()
        : this.deprecated;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractMeta#getDefinition() definition} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for definition (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Meta withDefinition(@Nullable DefinitionPropertyValue value) {
    if (this.definition == value) return this;
    return new Meta(
        value,
        this.comments,
        this.subsets,
        this.synonyms,
        this.xrefs,
        this.xrefsValues,
        this.basicPropertyValues,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getComments() comments}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withComments(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Meta(
        this.definition,
        newValue,
        this.subsets,
        this.synonyms,
        this.xrefs,
        this.xrefsValues,
        this.basicPropertyValues,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getComments() comments}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of comments elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withComments(Iterable<String> elements) {
    if (this.comments == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Meta(
        this.definition,
        newValue,
        this.subsets,
        this.synonyms,
        this.xrefs,
        this.xrefsValues,
        this.basicPropertyValues,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getSubsets() subsets}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withSubsets(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Meta(
        this.definition,
        this.comments,
        newValue,
        this.synonyms,
        this.xrefs,
        this.xrefsValues,
        this.basicPropertyValues,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getSubsets() subsets}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of subsets elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withSubsets(Iterable<String> elements) {
    if (this.subsets == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Meta(
        this.definition,
        this.comments,
        newValue,
        this.synonyms,
        this.xrefs,
        this.xrefsValues,
        this.basicPropertyValues,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getSynonyms() synonyms}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withSynonyms(SynonymPropertyValue... elements) {
    List<SynonymPropertyValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Meta(
        this.definition,
        this.comments,
        this.subsets,
        newValue,
        this.xrefs,
        this.xrefsValues,
        this.basicPropertyValues,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getSynonyms() synonyms}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of synonyms elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withSynonyms(Iterable<? extends SynonymPropertyValue> elements) {
    if (this.synonyms == elements) return this;
    List<SynonymPropertyValue> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Meta(
        this.definition,
        this.comments,
        this.subsets,
        newValue,
        this.xrefs,
        this.xrefsValues,
        this.basicPropertyValues,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getXrefs() xrefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withXrefs(XrefPropertyValue... elements) {
    List<XrefPropertyValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Meta(
        this.definition,
        this.comments,
        this.subsets,
        this.synonyms,
        newValue,
        this.xrefsValues,
        this.basicPropertyValues,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getXrefs() xrefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of xrefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withXrefs(Iterable<? extends XrefPropertyValue> elements) {
    if (this.xrefs == elements) return this;
    List<XrefPropertyValue> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Meta(
        this.definition,
        this.comments,
        this.subsets,
        this.synonyms,
        newValue,
        this.xrefsValues,
        this.basicPropertyValues,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getXrefsValues() xrefsValues}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withXrefsValues(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Meta(
        this.definition,
        this.comments,
        this.subsets,
        this.synonyms,
        this.xrefs,
        newValue,
        this.basicPropertyValues,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getXrefsValues() xrefsValues}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of xrefsValues elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withXrefsValues(Iterable<String> elements) {
    if (this.xrefsValues == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Meta(
        this.definition,
        this.comments,
        this.subsets,
        this.synonyms,
        this.xrefs,
        newValue,
        this.basicPropertyValues,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getBasicPropertyValues() basicPropertyValues}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withBasicPropertyValues(BasicPropertyValue... elements) {
    List<BasicPropertyValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Meta(
        this.definition,
        this.comments,
        this.subsets,
        this.synonyms,
        this.xrefs,
        this.xrefsValues,
        newValue,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractMeta#getBasicPropertyValues() basicPropertyValues}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of basicPropertyValues elements to set
   * @return A modified copy of {@code this} object
   */
  public final Meta withBasicPropertyValues(Iterable<? extends BasicPropertyValue> elements) {
    if (this.basicPropertyValues == elements) return this;
    List<BasicPropertyValue> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Meta(
        this.definition,
        this.comments,
        this.subsets,
        this.synonyms,
        this.xrefs,
        this.xrefsValues,
        newValue,
        this.version,
        this.deprecated);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractMeta#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final Meta withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new Meta(
        this.definition,
        this.comments,
        this.subsets,
        this.synonyms,
        this.xrefs,
        this.xrefsValues,
        this.basicPropertyValues,
        newValue,
        this.deprecated);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractMeta#getDeprecated() deprecated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deprecated
   * @return A modified copy of the {@code this} object
   */
  public final Meta withDeprecated(boolean value) {
    if (this.deprecated == value) return this;
    return new Meta(
        this.definition,
        this.comments,
        this.subsets,
        this.synonyms,
        this.xrefs,
        this.xrefsValues,
        this.basicPropertyValues,
        this.version,
        value);
  }

  /**
   * This instance is equal to all instances of {@code Meta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Meta
        && equalTo(0, (Meta) another);
  }

  private boolean equalTo(int synthetic, Meta another) {
    return Objects.equals(definition, another.definition)
        && comments.equals(another.comments)
        && subsets.equals(another.subsets)
        && synonyms.equals(another.synonyms)
        && xrefs.equals(another.xrefs)
        && xrefsValues.equals(another.xrefsValues)
        && basicPropertyValues.equals(another.basicPropertyValues)
        && version.equals(another.version)
        && deprecated == another.deprecated;
  }

  /**
   * Computes a hash code from attributes: {@code definition}, {@code comments}, {@code subsets}, {@code synonyms}, {@code xrefs}, {@code xrefsValues}, {@code basicPropertyValues}, {@code version}, {@code deprecated}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(definition);
    h += (h << 5) + comments.hashCode();
    h += (h << 5) + subsets.hashCode();
    h += (h << 5) + synonyms.hashCode();
    h += (h << 5) + xrefs.hashCode();
    h += (h << 5) + xrefsValues.hashCode();
    h += (h << 5) + basicPropertyValues.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + Boolean.hashCode(deprecated);
    return h;
  }

  /**
   * Prints the immutable value {@code Meta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Meta{"
        + "definition=" + definition
        + ", comments=" + comments
        + ", subsets=" + subsets
        + ", synonyms=" + synonyms
        + ", xrefs=" + xrefs
        + ", xrefsValues=" + xrefsValues
        + ", basicPropertyValues=" + basicPropertyValues
        + ", version=" + version
        + ", deprecated=" + deprecated
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractMeta", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractMeta {
    @Nullable DefinitionPropertyValue definition;
    @Nullable List<String> comments = Collections.emptyList();
    @Nullable List<String> subsets = Collections.emptyList();
    @Nullable List<SynonymPropertyValue> synonyms = Collections.emptyList();
    @Nullable List<XrefPropertyValue> xrefs = Collections.emptyList();
    @Nullable List<String> xrefsValues = Collections.emptyList();
    boolean xrefsValuesIsSet;
    @Nullable List<BasicPropertyValue> basicPropertyValues = Collections.emptyList();
    @Nullable String version;
    boolean deprecated;
    boolean deprecatedIsSet;
    @JsonProperty
    public void setDefinition(@Nullable DefinitionPropertyValue definition) {
      this.definition = definition;
    }
    @JsonProperty
    public void setComments(List<String> comments) {
      this.comments = comments;
    }
    @JsonProperty
    public void setSubsets(List<String> subsets) {
      this.subsets = subsets;
    }
    @JsonProperty
    public void setSynonyms(List<SynonymPropertyValue> synonyms) {
      this.synonyms = synonyms;
    }
    @JsonProperty
    public void setXrefs(List<XrefPropertyValue> xrefs) {
      this.xrefs = xrefs;
    }
    @JsonProperty("xrefsValues")
    @JsonIgnore
    public void setXrefsValues(List<String> xrefsValues) {
      this.xrefsValues = xrefsValues;
      this.xrefsValuesIsSet = null != xrefsValues;
    }
    @JsonProperty
    public void setBasicPropertyValues(List<BasicPropertyValue> basicPropertyValues) {
      this.basicPropertyValues = basicPropertyValues;
    }
    @JsonProperty
    public void setVersion(String version) {
      this.version = version;
    }
    @JsonProperty
    public void setDeprecated(boolean deprecated) {
      this.deprecated = deprecated;
      this.deprecatedIsSet = true;
    }
    @Override
    public DefinitionPropertyValue getDefinition() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getComments() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSubsets() { throw new UnsupportedOperationException(); }
    @Override
    public List<SynonymPropertyValue> getSynonyms() { throw new UnsupportedOperationException(); }
    @Override
    public List<XrefPropertyValue> getXrefs() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getXrefsValues() { throw new UnsupportedOperationException(); }
    @Override
    public List<BasicPropertyValue> getBasicPropertyValues() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getDeprecated() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Meta fromJson(Json json) {
    Meta.Builder builder = new Meta.Builder();
    if (json.definition != null) {
      builder.definition(json.definition);
    }
    if (json.comments != null) {
      builder.addAllComments(json.comments);
    }
    if (json.subsets != null) {
      builder.addAllSubsets(json.subsets);
    }
    if (json.synonyms != null) {
      builder.addAllSynonyms(json.synonyms);
    }
    if (json.xrefs != null) {
      builder.addAllXrefs(json.xrefs);
    }
    if (json.xrefsValuesIsSet) {
      builder.addAllXrefsValues(json.xrefsValues);
    }
    if (json.basicPropertyValues != null) {
      builder.addAllBasicPropertyValues(json.basicPropertyValues);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.deprecatedIsSet) {
      builder.deprecated(json.deprecated);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractMeta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Meta instance
   */
  public static Meta copyOf(AbstractMeta instance) {
    if (instance instanceof Meta) {
      return (Meta) instance;
    }
    return new Meta.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link Meta Meta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractMeta", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_XREFS_VALUES = 0x1L;
    private static final long OPT_BIT_DEPRECATED = 0x2L;
    private long optBits;

    private @Nullable DefinitionPropertyValue definition;
    private List<String> comments = new ArrayList<String>();
    private List<String> subsets = new ArrayList<String>();
    private List<SynonymPropertyValue> synonyms = new ArrayList<SynonymPropertyValue>();
    private List<XrefPropertyValue> xrefs = new ArrayList<XrefPropertyValue>();
    private List<String> xrefsValues = new ArrayList<String>();
    private List<BasicPropertyValue> basicPropertyValues = new ArrayList<BasicPropertyValue>();
    private @Nullable String version;
    private boolean deprecated;

    /**
     * Creates a builder for {@link Meta Meta} instances.
     * <pre>
     * new Meta.Builder()
     *    .definition(DefinitionPropertyValue | null) // nullable {@link AbstractMeta#getDefinition() definition}
     *    .addComment|addAllComments(String) // {@link AbstractMeta#getComments() comments} elements
     *    .addSubset|addAllSubsets(String) // {@link AbstractMeta#getSubsets() subsets} elements
     *    .addSynonym|addAllSynonyms(SynonymPropertyValue) // {@link AbstractMeta#getSynonyms() synonyms} elements
     *    .addXref|addAllXrefs(XrefPropertyValue) // {@link AbstractMeta#getXrefs() xrefs} elements
     *    .addXrefsValue|addAllXrefsValues(String) // {@link AbstractMeta#getXrefsValues() xrefsValues} elements
     *    .addBasicPropertyValue|addAllBasicPropertyValues(BasicPropertyValue) // {@link AbstractMeta#getBasicPropertyValues() basicPropertyValues} elements
     *    .version(String) // optional {@link AbstractMeta#getVersion() version}
     *    .deprecated(boolean) // optional {@link AbstractMeta#getDeprecated() deprecated}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractMeta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractMeta instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable DefinitionPropertyValue definitionValue = instance.getDefinition();
      if (definitionValue != null) {
        definition(definitionValue);
      }
      addAllComments(instance.getComments());
      addAllSubsets(instance.getSubsets());
      addAllSynonyms(instance.getSynonyms());
      addAllXrefs(instance.getXrefs());
      addAllXrefsValues(instance.getXrefsValues());
      addAllBasicPropertyValues(instance.getBasicPropertyValues());
      version(instance.getVersion());
      deprecated(instance.getDeprecated());
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractMeta#getDefinition() definition} attribute.
     * @param definition The value for definition (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder definition(@Nullable DefinitionPropertyValue definition) {
      this.definition = definition;
      return this;
    }

    /**
     * Adds one element to {@link AbstractMeta#getComments() comments} list.
     * @param element A comments element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addComment(String element) {
      this.comments.add(Objects.requireNonNull(element, "comments element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractMeta#getComments() comments} list.
     * @param elements An array of comments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addComments(String... elements) {
      for (String element : elements) {
        this.comments.add(Objects.requireNonNull(element, "comments element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractMeta#getComments() comments} list.
     * @param elements An iterable of comments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder comments(Iterable<String> elements) {
      this.comments.clear();
      return addAllComments(elements);
    }

    /**
     * Adds elements to {@link AbstractMeta#getComments() comments} list.
     * @param elements An iterable of comments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllComments(Iterable<String> elements) {
      for (String element : elements) {
        this.comments.add(Objects.requireNonNull(element, "comments element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractMeta#getSubsets() subsets} list.
     * @param element A subsets element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSubset(String element) {
      this.subsets.add(Objects.requireNonNull(element, "subsets element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractMeta#getSubsets() subsets} list.
     * @param elements An array of subsets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSubsets(String... elements) {
      for (String element : elements) {
        this.subsets.add(Objects.requireNonNull(element, "subsets element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractMeta#getSubsets() subsets} list.
     * @param elements An iterable of subsets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder subsets(Iterable<String> elements) {
      this.subsets.clear();
      return addAllSubsets(elements);
    }

    /**
     * Adds elements to {@link AbstractMeta#getSubsets() subsets} list.
     * @param elements An iterable of subsets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSubsets(Iterable<String> elements) {
      for (String element : elements) {
        this.subsets.add(Objects.requireNonNull(element, "subsets element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractMeta#getSynonyms() synonyms} list.
     * @param element A synonyms element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSynonym(SynonymPropertyValue element) {
      this.synonyms.add(Objects.requireNonNull(element, "synonyms element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractMeta#getSynonyms() synonyms} list.
     * @param elements An array of synonyms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSynonyms(SynonymPropertyValue... elements) {
      for (SynonymPropertyValue element : elements) {
        this.synonyms.add(Objects.requireNonNull(element, "synonyms element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractMeta#getSynonyms() synonyms} list.
     * @param elements An iterable of synonyms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder synonyms(Iterable<? extends SynonymPropertyValue> elements) {
      this.synonyms.clear();
      return addAllSynonyms(elements);
    }

    /**
     * Adds elements to {@link AbstractMeta#getSynonyms() synonyms} list.
     * @param elements An iterable of synonyms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSynonyms(Iterable<? extends SynonymPropertyValue> elements) {
      for (SynonymPropertyValue element : elements) {
        this.synonyms.add(Objects.requireNonNull(element, "synonyms element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractMeta#getXrefs() xrefs} list.
     * @param element A xrefs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addXref(XrefPropertyValue element) {
      this.xrefs.add(Objects.requireNonNull(element, "xrefs element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractMeta#getXrefs() xrefs} list.
     * @param elements An array of xrefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addXrefs(XrefPropertyValue... elements) {
      for (XrefPropertyValue element : elements) {
        this.xrefs.add(Objects.requireNonNull(element, "xrefs element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractMeta#getXrefs() xrefs} list.
     * @param elements An iterable of xrefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder xrefs(Iterable<? extends XrefPropertyValue> elements) {
      this.xrefs.clear();
      return addAllXrefs(elements);
    }

    /**
     * Adds elements to {@link AbstractMeta#getXrefs() xrefs} list.
     * @param elements An iterable of xrefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllXrefs(Iterable<? extends XrefPropertyValue> elements) {
      for (XrefPropertyValue element : elements) {
        this.xrefs.add(Objects.requireNonNull(element, "xrefs element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractMeta#getXrefsValues() xrefsValues} list.
     * @param element A xrefsValues element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addXrefsValue(String element) {
      this.xrefsValues.add(Objects.requireNonNull(element, "xrefsValues element"));
      optBits |= OPT_BIT_XREFS_VALUES;
      return this;
    }

    /**
     * Adds elements to {@link AbstractMeta#getXrefsValues() xrefsValues} list.
     * @param elements An array of xrefsValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addXrefsValues(String... elements) {
      for (String element : elements) {
        this.xrefsValues.add(Objects.requireNonNull(element, "xrefsValues element"));
      }
      optBits |= OPT_BIT_XREFS_VALUES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractMeta#getXrefsValues() xrefsValues} list.
     * @param elements An iterable of xrefsValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder xrefsValues(Iterable<String> elements) {
      this.xrefsValues.clear();
      return addAllXrefsValues(elements);
    }

    /**
     * Adds elements to {@link AbstractMeta#getXrefsValues() xrefsValues} list.
     * @param elements An iterable of xrefsValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllXrefsValues(Iterable<String> elements) {
      for (String element : elements) {
        this.xrefsValues.add(Objects.requireNonNull(element, "xrefsValues element"));
      }
      optBits |= OPT_BIT_XREFS_VALUES;
      return this;
    }

    /**
     * Adds one element to {@link AbstractMeta#getBasicPropertyValues() basicPropertyValues} list.
     * @param element A basicPropertyValues element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBasicPropertyValue(BasicPropertyValue element) {
      this.basicPropertyValues.add(Objects.requireNonNull(element, "basicPropertyValues element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractMeta#getBasicPropertyValues() basicPropertyValues} list.
     * @param elements An array of basicPropertyValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBasicPropertyValues(BasicPropertyValue... elements) {
      for (BasicPropertyValue element : elements) {
        this.basicPropertyValues.add(Objects.requireNonNull(element, "basicPropertyValues element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractMeta#getBasicPropertyValues() basicPropertyValues} list.
     * @param elements An iterable of basicPropertyValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder basicPropertyValues(Iterable<? extends BasicPropertyValue> elements) {
      this.basicPropertyValues.clear();
      return addAllBasicPropertyValues(elements);
    }

    /**
     * Adds elements to {@link AbstractMeta#getBasicPropertyValues() basicPropertyValues} list.
     * @param elements An iterable of basicPropertyValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBasicPropertyValues(Iterable<? extends BasicPropertyValue> elements) {
      for (BasicPropertyValue element : elements) {
        this.basicPropertyValues.add(Objects.requireNonNull(element, "basicPropertyValues element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractMeta#getVersion() version} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractMeta#getVersion() version}.</em>
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractMeta#getDeprecated() deprecated} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractMeta#getDeprecated() deprecated}.</em>
     * @param deprecated The value for deprecated 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder deprecated(boolean deprecated) {
      this.deprecated = deprecated;
      optBits |= OPT_BIT_DEPRECATED;
      return this;
    }

    /**
     * Builds a new {@link Meta Meta}.
     * @return An immutable instance of Meta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Meta build() {
      return new Meta(this);
    }

    private boolean xrefsValuesIsSet() {
      return (optBits & OPT_BIT_XREFS_VALUES) != 0;
    }

    private boolean deprecatedIsSet() {
      return (optBits & OPT_BIT_DEPRECATED) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
