package org.geneontology.obographs.core.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Holds a collection of graphs, plus document-level metadata
 * 
 * ## Model
 * 
 * ![Node UML](graphdocument.png)
 *  
 * @startuml graphdocument.png
 * class GraphDocument
 * class Graph
 * class Meta
 * 
 * GraphDocument-->Graph : 0..*
 * GraphDocument-->Meta : 0..*
 * @enduml
 * 
 * @author cjm
 */
@Generated(from = "AbstractGraphDocument", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class GraphDocument extends AbstractGraphDocument {
  private final @Nullable Object context;
  private final @Nullable Meta meta;
  private final List<Graph> graphs;

  private GraphDocument(
      @Nullable Object context,
      @Nullable Meta meta,
      List<Graph> graphs) {
    this.context = context;
    this.meta = meta;
    this.graphs = graphs;
  }

  /**
   * The JSON-LD context for this document. This needs to be an unstructured
   * Object, since it could be either a list or a map. We don't want to store
   * it here as a Context because we want to roundtrip it the way it is written
   * in the document.
   */
  @JsonProperty("@context")
  @Override
  public @Nullable Object getContext() {
    return context;
  }

  /**
   * @return the meta
   */
  @JsonProperty
  @Override
  public @Nullable Meta getMeta() {
    return meta;
  }

  /**
   * @return the graphs
   */
  @JsonProperty
  @Override
  public List<Graph> getGraphs() {
    return graphs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractGraphDocument#getContext() context} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GraphDocument withContext(@Nullable Object value) {
    if (this.context == value) return this;
    return new GraphDocument(value, this.meta, this.graphs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractGraphDocument#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GraphDocument withMeta(@Nullable Meta value) {
    if (this.meta == value) return this;
    return new GraphDocument(this.context, value, this.graphs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraphDocument#getGraphs() graphs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final GraphDocument withGraphs(Graph... elements) {
    List<Graph> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new GraphDocument(this.context, this.meta, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraphDocument#getGraphs() graphs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of graphs elements to set
   * @return A modified copy of {@code this} object
   */
  public final GraphDocument withGraphs(Iterable<? extends Graph> elements) {
    if (this.graphs == elements) return this;
    List<Graph> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new GraphDocument(this.context, this.meta, newValue);
  }

  /**
   * This instance is equal to all instances of {@code GraphDocument} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof GraphDocument
        && equalTo(0, (GraphDocument) another);
  }

  private boolean equalTo(int synthetic, GraphDocument another) {
    return Objects.equals(context, another.context)
        && Objects.equals(meta, another.meta)
        && graphs.equals(another.graphs);
  }

  /**
   * Computes a hash code from attributes: {@code context}, {@code meta}, {@code graphs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(meta);
    h += (h << 5) + graphs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GraphDocument} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GraphDocument{"
        + "context=" + context
        + ", meta=" + meta
        + ", graphs=" + graphs
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractGraphDocument", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractGraphDocument {
    @Nullable Object context;
    @Nullable Meta meta;
    @Nullable List<Graph> graphs = Collections.emptyList();
    @JsonProperty("@context")
    public void setContext(@Nullable Object context) {
      this.context = context;
    }
    @JsonProperty
    public void setMeta(@Nullable Meta meta) {
      this.meta = meta;
    }
    @JsonProperty
    public void setGraphs(List<Graph> graphs) {
      this.graphs = graphs;
    }
    @Override
    public Object getContext() { throw new UnsupportedOperationException(); }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public List<Graph> getGraphs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GraphDocument fromJson(Json json) {
    GraphDocument.Builder builder = new GraphDocument.Builder();
    if (json.context != null) {
      builder.context(json.context);
    }
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.graphs != null) {
      builder.addAllGraphs(json.graphs);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractGraphDocument} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GraphDocument instance
   */
  public static GraphDocument copyOf(AbstractGraphDocument instance) {
    if (instance instanceof GraphDocument) {
      return (GraphDocument) instance;
    }
    return new GraphDocument.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link GraphDocument GraphDocument}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractGraphDocument", generator = "Immutables")
  @NotThreadSafe
  @JsonPropertyOrder({"context", "meta", "graphs"})
  public static final class Builder {
    private @Nullable Object context;
    private @Nullable Meta meta;
    private List<Graph> graphs = new ArrayList<Graph>();

    /**
     * Creates a builder for {@link GraphDocument GraphDocument} instances.
     * <pre>
     * new GraphDocument.Builder()
     *    .context(Object | null) // nullable {@link AbstractGraphDocument#getContext() context}
     *    .meta(org.geneontology.obographs.core.model.Meta | null) // nullable {@link AbstractGraphDocument#getMeta() meta}
     *    .addGraph|addAllGraphs(Graph) // {@link AbstractGraphDocument#getGraphs() graphs} elements
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractGraphDocument} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractGraphDocument instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Object contextValue = instance.getContext();
      if (contextValue != null) {
        context(contextValue);
      }
      @Nullable Meta metaValue = instance.getMeta();
      if (metaValue != null) {
        meta(metaValue);
      }
      addAllGraphs(instance.getGraphs());
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractGraphDocument#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("@context")
    public final Builder context(@Nullable Object context) {
      this.context = context;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractGraphDocument#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty
    public final Builder meta(@Nullable Meta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Adds one element to {@link AbstractGraphDocument#getGraphs() graphs} list.
     * @param element A graphs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGraph(Graph element) {
      this.graphs.add(Objects.requireNonNull(element, "graphs element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractGraphDocument#getGraphs() graphs} list.
     * @param elements An array of graphs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGraphs(Graph... elements) {
      for (Graph element : elements) {
        this.graphs.add(Objects.requireNonNull(element, "graphs element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractGraphDocument#getGraphs() graphs} list.
     * @param elements An iterable of graphs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty
    public final Builder graphs(Iterable<? extends Graph> elements) {
      this.graphs.clear();
      return addAllGraphs(elements);
    }

    /**
     * Adds elements to {@link AbstractGraphDocument#getGraphs() graphs} list.
     * @param elements An iterable of graphs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGraphs(Iterable<? extends Graph> elements) {
      for (Graph element : elements) {
        this.graphs.add(Objects.requireNonNull(element, "graphs element"));
      }
      return this;
    }

    /**
     * Builds a new {@link GraphDocument GraphDocument}.
     * @return An immutable instance of GraphDocument
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GraphDocument build() {
      return new GraphDocument(context, meta, createUnmodifiableList(true, graphs));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
