package org.geneontology.obographs.core.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.axiom.DomainRangeAxiom;
import org.geneontology.obographs.core.model.axiom.EquivalentNodesSet;
import org.geneontology.obographs.core.model.axiom.LogicalDefinitionAxiom;
import org.geneontology.obographs.core.model.axiom.PropertyChainAxiom;
import org.immutables.value.Generated;

/**
 * A graph object holds a collection of nodes and edges
 * 
 * Corresponds to a Named Graph in RDF, and an Ontology in OWL
 * 
 * Note: there is no assumption that either nodes or edges are unique to a graph
 * 
 * ## Basic OBO Graphs
 * 
 * ![Node UML](node-bog.png)
 *  * 
 * @startuml node-bog.png
 * class Graph
 * class Node
 * class Edge
 * 
 * Graph-->Node : 0..*
 * Graph-->Edge : 0..*
 * @enduml
 * 
 * @author cjm
 */
@Generated(from = "AbstractGraph", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class Graph extends AbstractGraph {
  private final String id;
  private final String lbl;
  private final @Nullable Meta meta;
  private final List<Node> nodes;
  private final List<Edge> edges;
  private final List<EquivalentNodesSet> equivalentNodesSets;
  private final List<LogicalDefinitionAxiom> logicalDefinitionAxioms;
  private final List<DomainRangeAxiom> domainRangeAxioms;
  private final List<PropertyChainAxiom> propertyChainAxioms;

  private Graph(Graph.Builder builder) {
    this.meta = builder.meta;
    this.nodes = createUnmodifiableList(true, builder.nodes);
    this.edges = createUnmodifiableList(true, builder.edges);
    this.equivalentNodesSets = createUnmodifiableList(true, builder.equivalentNodesSets);
    this.logicalDefinitionAxioms = createUnmodifiableList(true, builder.logicalDefinitionAxioms);
    this.domainRangeAxioms = createUnmodifiableList(true, builder.domainRangeAxioms);
    this.propertyChainAxioms = createUnmodifiableList(true, builder.propertyChainAxioms);
    if (builder.id != null) {
      initShim.id(builder.id);
    }
    if (builder.lbl != null) {
      initShim.lbl(builder.lbl);
    }
    this.id = initShim.getId();
    this.lbl = initShim.getLbl();
    this.initShim = null;
  }

  private Graph(
      String id,
      String lbl,
      @Nullable Meta meta,
      List<Node> nodes,
      List<Edge> edges,
      List<EquivalentNodesSet> equivalentNodesSets,
      List<LogicalDefinitionAxiom> logicalDefinitionAxioms,
      List<DomainRangeAxiom> domainRangeAxioms,
      List<PropertyChainAxiom> propertyChainAxioms) {
    this.id = id;
    this.lbl = lbl;
    this.meta = meta;
    this.nodes = nodes;
    this.edges = edges;
    this.equivalentNodesSets = equivalentNodesSets;
    this.logicalDefinitionAxioms = logicalDefinitionAxioms;
    this.domainRangeAxioms = domainRangeAxioms;
    this.propertyChainAxioms = propertyChainAxioms;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "AbstractGraph", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(Graph.super.getId(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void id(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte lblBuildStage = STAGE_UNINITIALIZED;
    private String lbl;

    String getLbl() {
      if (lblBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (lblBuildStage == STAGE_UNINITIALIZED) {
        lblBuildStage = STAGE_INITIALIZING;
        this.lbl = Objects.requireNonNull(Graph.super.getLbl(), "lbl");
        lblBuildStage = STAGE_INITIALIZED;
      }
      return this.lbl;
    }

    void lbl(String lbl) {
      this.lbl = lbl;
      lblBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (lblBuildStage == STAGE_INITIALIZING) attributes.add("lbl");
      return "Cannot build Graph, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return the id
   */
  @JsonProperty
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return the lbl
   */
  @JsonProperty
  @Override
  public String getLbl() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLbl()
        : this.lbl;
  }

  /**
   * @return the meta
   */
  @JsonProperty
  @Override
  public @Nullable Meta getMeta() {
    return meta;
  }

  /**
   * @return the nodes
   */
  @JsonProperty
  @Override
  public List<Node> getNodes() {
    return nodes;
  }

  /**
   * @return the edges
   */
  @JsonProperty
  @Override
  public List<Edge> getEdges() {
    return edges;
  }

  /**
   * @return the equivalentNodesSet
   */
  @JsonProperty
  @Override
  public List<EquivalentNodesSet> getEquivalentNodesSets() {
    return equivalentNodesSets;
  }

  /**
   * @return the logicalDefinitionAxioms
   */
  @JsonProperty
  @Override
  public List<LogicalDefinitionAxiom> getLogicalDefinitionAxioms() {
    return logicalDefinitionAxioms;
  }

  /**
   * @return the domainRangeAxioms
   */
  @JsonProperty
  @Override
  public List<DomainRangeAxiom> getDomainRangeAxioms() {
    return domainRangeAxioms;
  }

  /**
   * @return the propertyChainAxioms
   */
  @JsonProperty
  @Override
  public List<PropertyChainAxiom> getPropertyChainAxioms() {
    return propertyChainAxioms;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractGraph#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final Graph withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new Graph(
        newValue,
        this.lbl,
        this.meta,
        this.nodes,
        this.edges,
        this.equivalentNodesSets,
        this.logicalDefinitionAxioms,
        this.domainRangeAxioms,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractGraph#getLbl() lbl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lbl
   * @return A modified copy of the {@code this} object
   */
  public final Graph withLbl(String value) {
    String newValue = Objects.requireNonNull(value, "lbl");
    if (this.lbl.equals(newValue)) return this;
    return new Graph(
        this.id,
        newValue,
        this.meta,
        this.nodes,
        this.edges,
        this.equivalentNodesSets,
        this.logicalDefinitionAxioms,
        this.domainRangeAxioms,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractGraph#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Graph withMeta(@Nullable Meta value) {
    if (this.meta == value) return this;
    return new Graph(
        this.id,
        this.lbl,
        value,
        this.nodes,
        this.edges,
        this.equivalentNodesSets,
        this.logicalDefinitionAxioms,
        this.domainRangeAxioms,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getNodes() nodes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withNodes(Node... elements) {
    List<Node> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        newValue,
        this.edges,
        this.equivalentNodesSets,
        this.logicalDefinitionAxioms,
        this.domainRangeAxioms,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getNodes() nodes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nodes elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withNodes(Iterable<? extends Node> elements) {
    if (this.nodes == elements) return this;
    List<Node> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        newValue,
        this.edges,
        this.equivalentNodesSets,
        this.logicalDefinitionAxioms,
        this.domainRangeAxioms,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getEdges() edges}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withEdges(Edge... elements) {
    List<Edge> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        this.nodes,
        newValue,
        this.equivalentNodesSets,
        this.logicalDefinitionAxioms,
        this.domainRangeAxioms,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getEdges() edges}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of edges elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withEdges(Iterable<? extends Edge> elements) {
    if (this.edges == elements) return this;
    List<Edge> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        this.nodes,
        newValue,
        this.equivalentNodesSets,
        this.logicalDefinitionAxioms,
        this.domainRangeAxioms,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getEquivalentNodesSets() equivalentNodesSets}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withEquivalentNodesSets(EquivalentNodesSet... elements) {
    List<EquivalentNodesSet> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        this.nodes,
        this.edges,
        newValue,
        this.logicalDefinitionAxioms,
        this.domainRangeAxioms,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getEquivalentNodesSets() equivalentNodesSets}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of equivalentNodesSets elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withEquivalentNodesSets(Iterable<? extends EquivalentNodesSet> elements) {
    if (this.equivalentNodesSets == elements) return this;
    List<EquivalentNodesSet> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        this.nodes,
        this.edges,
        newValue,
        this.logicalDefinitionAxioms,
        this.domainRangeAxioms,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getLogicalDefinitionAxioms() logicalDefinitionAxioms}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withLogicalDefinitionAxioms(LogicalDefinitionAxiom... elements) {
    List<LogicalDefinitionAxiom> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        this.nodes,
        this.edges,
        this.equivalentNodesSets,
        newValue,
        this.domainRangeAxioms,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getLogicalDefinitionAxioms() logicalDefinitionAxioms}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of logicalDefinitionAxioms elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withLogicalDefinitionAxioms(Iterable<? extends LogicalDefinitionAxiom> elements) {
    if (this.logicalDefinitionAxioms == elements) return this;
    List<LogicalDefinitionAxiom> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        this.nodes,
        this.edges,
        this.equivalentNodesSets,
        newValue,
        this.domainRangeAxioms,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getDomainRangeAxioms() domainRangeAxioms}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withDomainRangeAxioms(DomainRangeAxiom... elements) {
    List<DomainRangeAxiom> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        this.nodes,
        this.edges,
        this.equivalentNodesSets,
        this.logicalDefinitionAxioms,
        newValue,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getDomainRangeAxioms() domainRangeAxioms}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of domainRangeAxioms elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withDomainRangeAxioms(Iterable<? extends DomainRangeAxiom> elements) {
    if (this.domainRangeAxioms == elements) return this;
    List<DomainRangeAxiom> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        this.nodes,
        this.edges,
        this.equivalentNodesSets,
        this.logicalDefinitionAxioms,
        newValue,
        this.propertyChainAxioms);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getPropertyChainAxioms() propertyChainAxioms}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withPropertyChainAxioms(PropertyChainAxiom... elements) {
    List<PropertyChainAxiom> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        this.nodes,
        this.edges,
        this.equivalentNodesSets,
        this.logicalDefinitionAxioms,
        this.domainRangeAxioms,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractGraph#getPropertyChainAxioms() propertyChainAxioms}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of propertyChainAxioms elements to set
   * @return A modified copy of {@code this} object
   */
  public final Graph withPropertyChainAxioms(Iterable<? extends PropertyChainAxiom> elements) {
    if (this.propertyChainAxioms == elements) return this;
    List<PropertyChainAxiom> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Graph(
        this.id,
        this.lbl,
        this.meta,
        this.nodes,
        this.edges,
        this.equivalentNodesSets,
        this.logicalDefinitionAxioms,
        this.domainRangeAxioms,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code Graph} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Graph
        && equalTo(0, (Graph) another);
  }

  private boolean equalTo(int synthetic, Graph another) {
    return id.equals(another.id)
        && lbl.equals(another.lbl)
        && Objects.equals(meta, another.meta)
        && nodes.equals(another.nodes)
        && edges.equals(another.edges)
        && equivalentNodesSets.equals(another.equivalentNodesSets)
        && logicalDefinitionAxioms.equals(another.logicalDefinitionAxioms)
        && domainRangeAxioms.equals(another.domainRangeAxioms)
        && propertyChainAxioms.equals(another.propertyChainAxioms);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code lbl}, {@code meta}, {@code nodes}, {@code edges}, {@code equivalentNodesSets}, {@code logicalDefinitionAxioms}, {@code domainRangeAxioms}, {@code propertyChainAxioms}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + lbl.hashCode();
    h += (h << 5) + Objects.hashCode(meta);
    h += (h << 5) + nodes.hashCode();
    h += (h << 5) + edges.hashCode();
    h += (h << 5) + equivalentNodesSets.hashCode();
    h += (h << 5) + logicalDefinitionAxioms.hashCode();
    h += (h << 5) + domainRangeAxioms.hashCode();
    h += (h << 5) + propertyChainAxioms.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Graph} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Graph{"
        + "id=" + id
        + ", lbl=" + lbl
        + ", meta=" + meta
        + ", nodes=" + nodes
        + ", edges=" + edges
        + ", equivalentNodesSets=" + equivalentNodesSets
        + ", logicalDefinitionAxioms=" + logicalDefinitionAxioms
        + ", domainRangeAxioms=" + domainRangeAxioms
        + ", propertyChainAxioms=" + propertyChainAxioms
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractGraph", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractGraph {
    @Nullable String id;
    @Nullable String lbl;
    @Nullable Meta meta;
    @Nullable List<Node> nodes = Collections.emptyList();
    @Nullable List<Edge> edges = Collections.emptyList();
    @Nullable List<EquivalentNodesSet> equivalentNodesSets = Collections.emptyList();
    @Nullable List<LogicalDefinitionAxiom> logicalDefinitionAxioms = Collections.emptyList();
    @Nullable List<DomainRangeAxiom> domainRangeAxioms = Collections.emptyList();
    @Nullable List<PropertyChainAxiom> propertyChainAxioms = Collections.emptyList();
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty
    public void setLbl(String lbl) {
      this.lbl = lbl;
    }
    @JsonProperty
    public void setMeta(@Nullable Meta meta) {
      this.meta = meta;
    }
    @JsonProperty
    public void setNodes(List<Node> nodes) {
      this.nodes = nodes;
    }
    @JsonProperty
    public void setEdges(List<Edge> edges) {
      this.edges = edges;
    }
    @JsonProperty
    public void setEquivalentNodesSets(List<EquivalentNodesSet> equivalentNodesSets) {
      this.equivalentNodesSets = equivalentNodesSets;
    }
    @JsonProperty
    public void setLogicalDefinitionAxioms(List<LogicalDefinitionAxiom> logicalDefinitionAxioms) {
      this.logicalDefinitionAxioms = logicalDefinitionAxioms;
    }
    @JsonProperty
    public void setDomainRangeAxioms(List<DomainRangeAxiom> domainRangeAxioms) {
      this.domainRangeAxioms = domainRangeAxioms;
    }
    @JsonProperty
    public void setPropertyChainAxioms(List<PropertyChainAxiom> propertyChainAxioms) {
      this.propertyChainAxioms = propertyChainAxioms;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getLbl() { throw new UnsupportedOperationException(); }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public List<Node> getNodes() { throw new UnsupportedOperationException(); }
    @Override
    public List<Edge> getEdges() { throw new UnsupportedOperationException(); }
    @Override
    public List<EquivalentNodesSet> getEquivalentNodesSets() { throw new UnsupportedOperationException(); }
    @Override
    public List<LogicalDefinitionAxiom> getLogicalDefinitionAxioms() { throw new UnsupportedOperationException(); }
    @Override
    public List<DomainRangeAxiom> getDomainRangeAxioms() { throw new UnsupportedOperationException(); }
    @Override
    public List<PropertyChainAxiom> getPropertyChainAxioms() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Graph fromJson(Json json) {
    Graph.Builder builder = new Graph.Builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.lbl != null) {
      builder.lbl(json.lbl);
    }
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.nodes != null) {
      builder.addAllNodes(json.nodes);
    }
    if (json.edges != null) {
      builder.addAllEdges(json.edges);
    }
    if (json.equivalentNodesSets != null) {
      builder.addAllEquivalentNodesSets(json.equivalentNodesSets);
    }
    if (json.logicalDefinitionAxioms != null) {
      builder.addAllLogicalDefinitionAxioms(json.logicalDefinitionAxioms);
    }
    if (json.domainRangeAxioms != null) {
      builder.addAllDomainRangeAxioms(json.domainRangeAxioms);
    }
    if (json.propertyChainAxioms != null) {
      builder.addAllPropertyChainAxioms(json.propertyChainAxioms);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractGraph} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Graph instance
   */
  public static Graph copyOf(AbstractGraph instance) {
    if (instance instanceof Graph) {
      return (Graph) instance;
    }
    return new Graph.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link Graph Graph}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractGraph", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String lbl;
    private @Nullable Meta meta;
    private List<Node> nodes = new ArrayList<Node>();
    private List<Edge> edges = new ArrayList<Edge>();
    private List<EquivalentNodesSet> equivalentNodesSets = new ArrayList<EquivalentNodesSet>();
    private List<LogicalDefinitionAxiom> logicalDefinitionAxioms = new ArrayList<LogicalDefinitionAxiom>();
    private List<DomainRangeAxiom> domainRangeAxioms = new ArrayList<DomainRangeAxiom>();
    private List<PropertyChainAxiom> propertyChainAxioms = new ArrayList<PropertyChainAxiom>();

    /**
     * Creates a builder for {@link Graph Graph} instances.
     * <pre>
     * new Graph.Builder()
     *    .id(String) // optional {@link AbstractGraph#getId() id}
     *    .lbl(String) // optional {@link AbstractGraph#getLbl() lbl}
     *    .meta(org.geneontology.obographs.core.model.Meta | null) // nullable {@link AbstractGraph#getMeta() meta}
     *    .addNode|addAllNodes(Node) // {@link AbstractGraph#getNodes() nodes} elements
     *    .addEdge|addAllEdges(Edge) // {@link AbstractGraph#getEdges() edges} elements
     *    .addEquivalentNodesSet|addAllEquivalentNodesSets(org.geneontology.obographs.core.model.axiom.EquivalentNodesSet) // {@link AbstractGraph#getEquivalentNodesSets() equivalentNodesSets} elements
     *    .addLogicalDefinitionAxiom|addAllLogicalDefinitionAxioms(org.geneontology.obographs.core.model.axiom.LogicalDefinitionAxiom) // {@link AbstractGraph#getLogicalDefinitionAxioms() logicalDefinitionAxioms} elements
     *    .addDomainRangeAxiom|addAllDomainRangeAxioms(org.geneontology.obographs.core.model.axiom.DomainRangeAxiom) // {@link AbstractGraph#getDomainRangeAxioms() domainRangeAxioms} elements
     *    .addPropertyChainAxiom|addAllPropertyChainAxioms(org.geneontology.obographs.core.model.axiom.PropertyChainAxiom) // {@link AbstractGraph#getPropertyChainAxioms() propertyChainAxioms} elements
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractGraph} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractGraph instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      lbl(instance.getLbl());
      @Nullable Meta metaValue = instance.getMeta();
      if (metaValue != null) {
        meta(metaValue);
      }
      addAllNodes(instance.getNodes());
      addAllEdges(instance.getEdges());
      addAllEquivalentNodesSets(instance.getEquivalentNodesSets());
      addAllLogicalDefinitionAxioms(instance.getLogicalDefinitionAxioms());
      addAllDomainRangeAxioms(instance.getDomainRangeAxioms());
      addAllPropertyChainAxioms(instance.getPropertyChainAxioms());
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractGraph#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractGraph#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractGraph#getLbl() lbl} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractGraph#getLbl() lbl}.</em>
     * @param lbl The value for lbl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lbl(String lbl) {
      this.lbl = Objects.requireNonNull(lbl, "lbl");
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractGraph#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(@Nullable Meta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Adds one element to {@link AbstractGraph#getNodes() nodes} list.
     * @param element A nodes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNode(Node element) {
      this.nodes.add(Objects.requireNonNull(element, "nodes element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractGraph#getNodes() nodes} list.
     * @param elements An array of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNodes(Node... elements) {
      for (Node element : elements) {
        this.nodes.add(Objects.requireNonNull(element, "nodes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractGraph#getNodes() nodes} list.
     * @param elements An iterable of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nodes(Iterable<? extends Node> elements) {
      this.nodes.clear();
      return addAllNodes(elements);
    }

    /**
     * Adds elements to {@link AbstractGraph#getNodes() nodes} list.
     * @param elements An iterable of nodes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNodes(Iterable<? extends Node> elements) {
      for (Node element : elements) {
        this.nodes.add(Objects.requireNonNull(element, "nodes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractGraph#getEdges() edges} list.
     * @param element A edges element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEdge(Edge element) {
      this.edges.add(Objects.requireNonNull(element, "edges element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractGraph#getEdges() edges} list.
     * @param elements An array of edges elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEdges(Edge... elements) {
      for (Edge element : elements) {
        this.edges.add(Objects.requireNonNull(element, "edges element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractGraph#getEdges() edges} list.
     * @param elements An iterable of edges elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder edges(Iterable<? extends Edge> elements) {
      this.edges.clear();
      return addAllEdges(elements);
    }

    /**
     * Adds elements to {@link AbstractGraph#getEdges() edges} list.
     * @param elements An iterable of edges elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEdges(Iterable<? extends Edge> elements) {
      for (Edge element : elements) {
        this.edges.add(Objects.requireNonNull(element, "edges element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractGraph#getEquivalentNodesSets() equivalentNodesSets} list.
     * @param element A equivalentNodesSets element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEquivalentNodesSet(EquivalentNodesSet element) {
      this.equivalentNodesSets.add(Objects.requireNonNull(element, "equivalentNodesSets element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractGraph#getEquivalentNodesSets() equivalentNodesSets} list.
     * @param elements An array of equivalentNodesSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEquivalentNodesSets(EquivalentNodesSet... elements) {
      for (EquivalentNodesSet element : elements) {
        this.equivalentNodesSets.add(Objects.requireNonNull(element, "equivalentNodesSets element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractGraph#getEquivalentNodesSets() equivalentNodesSets} list.
     * @param elements An iterable of equivalentNodesSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder equivalentNodesSets(Iterable<? extends EquivalentNodesSet> elements) {
      this.equivalentNodesSets.clear();
      return addAllEquivalentNodesSets(elements);
    }

    /**
     * Adds elements to {@link AbstractGraph#getEquivalentNodesSets() equivalentNodesSets} list.
     * @param elements An iterable of equivalentNodesSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEquivalentNodesSets(Iterable<? extends EquivalentNodesSet> elements) {
      for (EquivalentNodesSet element : elements) {
        this.equivalentNodesSets.add(Objects.requireNonNull(element, "equivalentNodesSets element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractGraph#getLogicalDefinitionAxioms() logicalDefinitionAxioms} list.
     * @param element A logicalDefinitionAxioms element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLogicalDefinitionAxiom(LogicalDefinitionAxiom element) {
      this.logicalDefinitionAxioms.add(Objects.requireNonNull(element, "logicalDefinitionAxioms element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractGraph#getLogicalDefinitionAxioms() logicalDefinitionAxioms} list.
     * @param elements An array of logicalDefinitionAxioms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLogicalDefinitionAxioms(LogicalDefinitionAxiom... elements) {
      for (LogicalDefinitionAxiom element : elements) {
        this.logicalDefinitionAxioms.add(Objects.requireNonNull(element, "logicalDefinitionAxioms element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractGraph#getLogicalDefinitionAxioms() logicalDefinitionAxioms} list.
     * @param elements An iterable of logicalDefinitionAxioms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder logicalDefinitionAxioms(Iterable<? extends LogicalDefinitionAxiom> elements) {
      this.logicalDefinitionAxioms.clear();
      return addAllLogicalDefinitionAxioms(elements);
    }

    /**
     * Adds elements to {@link AbstractGraph#getLogicalDefinitionAxioms() logicalDefinitionAxioms} list.
     * @param elements An iterable of logicalDefinitionAxioms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLogicalDefinitionAxioms(Iterable<? extends LogicalDefinitionAxiom> elements) {
      for (LogicalDefinitionAxiom element : elements) {
        this.logicalDefinitionAxioms.add(Objects.requireNonNull(element, "logicalDefinitionAxioms element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractGraph#getDomainRangeAxioms() domainRangeAxioms} list.
     * @param element A domainRangeAxioms element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDomainRangeAxiom(DomainRangeAxiom element) {
      this.domainRangeAxioms.add(Objects.requireNonNull(element, "domainRangeAxioms element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractGraph#getDomainRangeAxioms() domainRangeAxioms} list.
     * @param elements An array of domainRangeAxioms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDomainRangeAxioms(DomainRangeAxiom... elements) {
      for (DomainRangeAxiom element : elements) {
        this.domainRangeAxioms.add(Objects.requireNonNull(element, "domainRangeAxioms element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractGraph#getDomainRangeAxioms() domainRangeAxioms} list.
     * @param elements An iterable of domainRangeAxioms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainRangeAxioms(Iterable<? extends DomainRangeAxiom> elements) {
      this.domainRangeAxioms.clear();
      return addAllDomainRangeAxioms(elements);
    }

    /**
     * Adds elements to {@link AbstractGraph#getDomainRangeAxioms() domainRangeAxioms} list.
     * @param elements An iterable of domainRangeAxioms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomainRangeAxioms(Iterable<? extends DomainRangeAxiom> elements) {
      for (DomainRangeAxiom element : elements) {
        this.domainRangeAxioms.add(Objects.requireNonNull(element, "domainRangeAxioms element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractGraph#getPropertyChainAxioms() propertyChainAxioms} list.
     * @param element A propertyChainAxioms element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPropertyChainAxiom(PropertyChainAxiom element) {
      this.propertyChainAxioms.add(Objects.requireNonNull(element, "propertyChainAxioms element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractGraph#getPropertyChainAxioms() propertyChainAxioms} list.
     * @param elements An array of propertyChainAxioms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPropertyChainAxioms(PropertyChainAxiom... elements) {
      for (PropertyChainAxiom element : elements) {
        this.propertyChainAxioms.add(Objects.requireNonNull(element, "propertyChainAxioms element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractGraph#getPropertyChainAxioms() propertyChainAxioms} list.
     * @param elements An iterable of propertyChainAxioms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder propertyChainAxioms(Iterable<? extends PropertyChainAxiom> elements) {
      this.propertyChainAxioms.clear();
      return addAllPropertyChainAxioms(elements);
    }

    /**
     * Adds elements to {@link AbstractGraph#getPropertyChainAxioms() propertyChainAxioms} list.
     * @param elements An iterable of propertyChainAxioms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPropertyChainAxioms(Iterable<? extends PropertyChainAxiom> elements) {
      for (PropertyChainAxiom element : elements) {
        this.propertyChainAxioms.add(Objects.requireNonNull(element, "propertyChainAxioms element"));
      }
      return this;
    }

    /**
     * Builds a new {@link Graph Graph}.
     * @return An immutable instance of Graph
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Graph build() {
      return new Graph(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
