package org.geneontology.obographs.core.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * An edge connects two nodes via a predicate
 * @author cjm
 */
@Generated(from = "AbstractEdge", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class Edge extends AbstractEdge {
  private final @Nullable Meta meta;
  private final String sub;
  private final String pred;
  private final String obj;

  private Edge(
      @Nullable Meta meta,
      String sub,
      String pred,
      String obj) {
    this.meta = meta;
    this.sub = sub;
    this.pred = pred;
    this.obj = obj;
  }

  /**
   * @return the meta
   */
  @JsonProperty
  @Override
  public @Nullable Meta getMeta() {
    return meta;
  }

  /**
   * @return The value of the {@code sub} attribute
   */
  @JsonProperty
  @Override
  public String getSub() {
    return sub;
  }

  /**
   * @return The value of the {@code pred} attribute
   */
  @JsonProperty
  @Override
  public String getPred() {
    return pred;
  }

  /**
   * @return The value of the {@code obj} attribute
   */
  @JsonProperty
  @Override
  public String getObj() {
    return obj;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractEdge#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Edge withMeta(@Nullable Meta value) {
    if (this.meta == value) return this;
    return new Edge(value, this.sub, this.pred, this.obj);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractEdge#getSub() sub} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sub
   * @return A modified copy of the {@code this} object
   */
  public final Edge withSub(String value) {
    String newValue = Objects.requireNonNull(value, "sub");
    if (this.sub.equals(newValue)) return this;
    return new Edge(this.meta, newValue, this.pred, this.obj);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractEdge#getPred() pred} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pred
   * @return A modified copy of the {@code this} object
   */
  public final Edge withPred(String value) {
    String newValue = Objects.requireNonNull(value, "pred");
    if (this.pred.equals(newValue)) return this;
    return new Edge(this.meta, this.sub, newValue, this.obj);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractEdge#getObj() obj} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for obj
   * @return A modified copy of the {@code this} object
   */
  public final Edge withObj(String value) {
    String newValue = Objects.requireNonNull(value, "obj");
    if (this.obj.equals(newValue)) return this;
    return new Edge(this.meta, this.sub, this.pred, newValue);
  }

  /**
   * This instance is equal to all instances of {@code Edge} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Edge
        && equalTo(0, (Edge) another);
  }

  private boolean equalTo(int synthetic, Edge another) {
    return Objects.equals(meta, another.meta)
        && sub.equals(another.sub)
        && pred.equals(another.pred)
        && obj.equals(another.obj);
  }

  /**
   * Computes a hash code from attributes: {@code meta}, {@code sub}, {@code pred}, {@code obj}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(meta);
    h += (h << 5) + sub.hashCode();
    h += (h << 5) + pred.hashCode();
    h += (h << 5) + obj.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Edge} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Edge{"
        + "meta=" + meta
        + ", sub=" + sub
        + ", pred=" + pred
        + ", obj=" + obj
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AbstractEdge", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractEdge {
    @Nullable Meta meta;
    @Nullable String sub;
    @Nullable String pred;
    @Nullable String obj;
    @JsonProperty
    public void setMeta(@Nullable Meta meta) {
      this.meta = meta;
    }
    @JsonProperty
    public void setSub(String sub) {
      this.sub = sub;
    }
    @JsonProperty
    public void setPred(String pred) {
      this.pred = pred;
    }
    @JsonProperty
    public void setObj(String obj) {
      this.obj = obj;
    }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public String getSub() { throw new UnsupportedOperationException(); }
    @Override
    public String getPred() { throw new UnsupportedOperationException(); }
    @Override
    public String getObj() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Edge fromJson(Json json) {
    Edge.Builder builder = new Edge.Builder();
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.sub != null) {
      builder.sub(json.sub);
    }
    if (json.pred != null) {
      builder.pred(json.pred);
    }
    if (json.obj != null) {
      builder.obj(json.obj);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractEdge} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Edge instance
   */
  public static Edge copyOf(AbstractEdge instance) {
    if (instance instanceof Edge) {
      return (Edge) instance;
    }
    return new Edge.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link Edge Edge}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractEdge", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SUB = 0x1L;
    private static final long INIT_BIT_PRED = 0x2L;
    private static final long INIT_BIT_OBJ = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Meta meta;
    private @Nullable String sub;
    private @Nullable String pred;
    private @Nullable String obj;

    /**
     * Creates a builder for {@link Edge Edge} instances.
     * <pre>
     * new Edge.Builder()
     *    .meta(org.geneontology.obographs.core.model.Meta | null) // nullable {@link AbstractEdge#getMeta() meta}
     *    .sub(String) // required {@link AbstractEdge#getSub() sub}
     *    .pred(String) // required {@link AbstractEdge#getPred() pred}
     *    .obj(String) // required {@link AbstractEdge#getObj() obj}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.NodeOrEdge} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(NodeOrEdge instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.geneontology.obographs.core.model.AbstractEdge} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractEdge instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof NodeOrEdge) {
        NodeOrEdge instance = (NodeOrEdge) object;
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractEdge) {
        AbstractEdge instance = (AbstractEdge) object;
        sub(instance.getSub());
        pred(instance.getPred());
        if ((bits & 0x1L) == 0) {
          @Nullable Meta metaValue = instance.getMeta();
          if (metaValue != null) {
            meta(metaValue);
          }
          bits |= 0x1L;
        }
        obj(instance.getObj());
      }
    }

    /**
     * Initializes the value for the {@link AbstractEdge#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(@Nullable Meta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractEdge#getSub() sub} attribute.
     * @param sub The value for sub 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sub(String sub) {
      this.sub = Objects.requireNonNull(sub, "sub");
      initBits &= ~INIT_BIT_SUB;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractEdge#getPred() pred} attribute.
     * @param pred The value for pred 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pred(String pred) {
      this.pred = Objects.requireNonNull(pred, "pred");
      initBits &= ~INIT_BIT_PRED;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractEdge#getObj() obj} attribute.
     * @param obj The value for obj 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder obj(String obj) {
      this.obj = Objects.requireNonNull(obj, "obj");
      initBits &= ~INIT_BIT_OBJ;
      return this;
    }

    /**
     * Builds a new {@link Edge Edge}.
     * @return An immutable instance of Edge
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Edge build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Edge(meta, sub, pred, obj);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SUB) != 0) attributes.add("sub");
      if ((initBits & INIT_BIT_PRED) != 0) attributes.add("pred");
      if ((initBits & INIT_BIT_OBJ) != 0) attributes.add("obj");
      return "Cannot build Edge, some of required attributes are not set " + attributes;
    }
  }
}
