/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model.meta;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.meta.AbstractDefinitionPropertyValue;
import org.geneontology.obographs.core.model.meta.PropertyValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractDefinitionPropertyValue", generator="Immutables")
@Immutable
public final class DefinitionPropertyValue
extends AbstractDefinitionPropertyValue {
    private final String pred;
    private final String val;
    private final ImmutableList<String> xrefs;
    @Nullable
    private final Meta meta;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private DefinitionPropertyValue(Builder builder) {
        this.xrefs = builder.xrefs.build();
        this.meta = builder.meta;
        if (builder.pred != null) {
            this.initShim.pred(builder.pred);
        }
        if (builder.val != null) {
            this.initShim.val(builder.val);
        }
        this.pred = this.initShim.getPred();
        this.val = this.initShim.getVal();
        this.initShim = null;
    }

    private DefinitionPropertyValue(String pred, String val, ImmutableList<String> xrefs, @Nullable Meta meta) {
        this.pred = pred;
        this.val = val;
        this.xrefs = xrefs;
        this.meta = meta;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public String getPred() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPred() : this.pred;
    }

    @Override
    @JsonProperty
    public String getVal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getVal() : this.val;
    }

    @JsonProperty
    public ImmutableList<String> getXrefs() {
        return this.xrefs;
    }

    @Override
    @JsonProperty
    @Nullable
    public Meta getMeta() {
        return this.meta;
    }

    public final DefinitionPropertyValue withPred(String value) {
        String newValue = Objects.requireNonNull(value, "pred");
        if (this.pred.equals(newValue)) {
            return this;
        }
        return new DefinitionPropertyValue(newValue, this.val, this.xrefs, this.meta);
    }

    public final DefinitionPropertyValue withVal(String value) {
        String newValue = Objects.requireNonNull(value, "val");
        if (this.val.equals(newValue)) {
            return this;
        }
        return new DefinitionPropertyValue(this.pred, newValue, this.xrefs, this.meta);
    }

    public final DefinitionPropertyValue withXrefs(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new DefinitionPropertyValue(this.pred, this.val, (ImmutableList<String>)newValue, this.meta);
    }

    public final DefinitionPropertyValue withXrefs(Iterable<String> elements) {
        if (this.xrefs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new DefinitionPropertyValue(this.pred, this.val, (ImmutableList<String>)newValue, this.meta);
    }

    public final DefinitionPropertyValue withMeta(@Nullable Meta value) {
        if (this.meta == value) {
            return this;
        }
        return new DefinitionPropertyValue(this.pred, this.val, this.xrefs, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DefinitionPropertyValue && this.equalTo((DefinitionPropertyValue)another);
    }

    private boolean equalTo(DefinitionPropertyValue another) {
        return this.pred.equals(another.pred) && this.val.equals(another.val) && this.xrefs.equals(another.xrefs) && Objects.equals(this.meta, another.meta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pred.hashCode();
        h += (h << 5) + this.val.hashCode();
        h += (h << 5) + this.xrefs.hashCode();
        h += (h << 5) + Objects.hashCode(this.meta);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DefinitionPropertyValue").omitNullValues().add("pred", (Object)this.pred).add("val", (Object)this.val).add("xrefs", this.xrefs).add("meta", (Object)this.meta).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static DefinitionPropertyValue fromJson(Json json) {
        Builder builder = new Builder();
        if (json.pred != null) {
            builder.pred(json.pred);
        }
        if (json.val != null) {
            builder.val(json.val);
        }
        if (json.xrefs != null) {
            builder.addAllXrefs(json.xrefs);
        }
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        return builder.build();
    }

    public static DefinitionPropertyValue copyOf(AbstractDefinitionPropertyValue instance) {
        if (instance instanceof DefinitionPropertyValue) {
            return (DefinitionPropertyValue)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="AbstractDefinitionPropertyValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String pred;
        @Nullable
        private String val;
        private ImmutableList.Builder<String> xrefs = ImmutableList.builder();
        @Nullable
        private Meta meta;

        @CanIgnoreReturnValue
        public final Builder from(PropertyValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AbstractDefinitionPropertyValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof PropertyValue) {
                PropertyValue instance = (PropertyValue)object;
                this.val(instance.getVal());
                this.addAllXrefs(instance.getXrefs());
                this.pred(instance.getPred());
                Meta metaValue = instance.getMeta();
                if (metaValue != null) {
                    this.meta(metaValue);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder pred(String pred) {
            this.pred = Objects.requireNonNull(pred, "pred");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder val(String val) {
            this.val = Objects.requireNonNull(val, "val");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXref(String element) {
            this.xrefs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXrefs(String ... elements) {
            this.xrefs.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xrefs(Iterable<String> elements) {
            this.xrefs = ImmutableList.builder();
            return this.addAllXrefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllXrefs(Iterable<String> elements) {
            this.xrefs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder meta(@Nullable Meta meta) {
            this.meta = meta;
            return this;
        }

        public DefinitionPropertyValue build() {
            return new DefinitionPropertyValue(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractDefinitionPropertyValue", generator="Immutables")
    static final class Json
    extends AbstractDefinitionPropertyValue {
        @Nullable
        String pred;
        @Nullable
        String val;
        @Nullable
        List<String> xrefs = ImmutableList.of();
        @Nullable
        Meta meta;

        Json() {
        }

        @JsonProperty
        public void setPred(String pred) {
            this.pred = pred;
        }

        @JsonProperty
        public void setVal(String val) {
            this.val = val;
        }

        @JsonProperty
        public void setXrefs(List<String> xrefs) {
            this.xrefs = xrefs;
        }

        @JsonProperty
        public void setMeta(@Nullable Meta meta) {
            this.meta = meta;
        }

        @Override
        public String getPred() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getXrefs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Meta getMeta() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AbstractDefinitionPropertyValue", generator="Immutables")
    private final class InitShim {
        private byte predBuildStage = 0;
        private String pred;
        private byte valBuildStage = 0;
        private String val;

        private InitShim() {
        }

        String getPred() {
            if (this.predBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.predBuildStage == 0) {
                this.predBuildStage = (byte)-1;
                this.pred = Objects.requireNonNull(DefinitionPropertyValue.super.getPred(), "pred");
                this.predBuildStage = 1;
            }
            return this.pred;
        }

        void pred(String pred) {
            this.pred = pred;
            this.predBuildStage = 1;
        }

        String getVal() {
            if (this.valBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.valBuildStage == 0) {
                this.valBuildStage = (byte)-1;
                this.val = Objects.requireNonNull(DefinitionPropertyValue.super.getVal(), "val");
                this.valBuildStage = 1;
            }
            return this.val;
        }

        void val(String val) {
            this.val = val;
            this.valBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.predBuildStage == -1) {
                attributes.add("pred");
            }
            if (this.valBuildStage == -1) {
                attributes.add("val");
            }
            return "Cannot build DefinitionPropertyValue, attribute initializers form cycle " + attributes;
        }
    }
}

