/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model.meta;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Collections;
import java.util.List;
import org.geneontology.obographs.core.model.meta.PropertyValue;
import org.immutables.value.Value;

@JsonPropertyOrder(value={"synonymType", "pred", "val", "xrefs", "meta"})
@Value.Immutable
public abstract class AbstractSynonymPropertyValue
implements PropertyValue {
    @JsonProperty
    @Value.Default
    public String getSynonymType() {
        return "";
    }

    @JsonIgnore
    public boolean isExact() {
        return this.getPred().equals("hasExactSynonym");
    }

    @JsonIgnore
    public boolean isRelated() {
        return this.getPred().equals("hasRelatedSynonym");
    }

    @JsonIgnore
    public boolean isBroad() {
        return this.getPred().equals("hasBroadSynonym");
    }

    @JsonIgnore
    public boolean isNarrow() {
        return this.getPred().equals("hasNarrowSynonym");
    }

    @JsonIgnore
    public List<String> getTypes() {
        if (this.getMeta() != null) {
            return this.getMeta().getSubsets();
        }
        return Collections.emptyList();
    }

    public static enum SCOPES {
        EXACT,
        NARROW,
        BROAD,
        RELATED;


        public String pred() {
            switch (this) {
                case EXACT: {
                    return "hasExactSynonym";
                }
                case RELATED: {
                    return "hasRelatedSynonym";
                }
                case BROAD: {
                    return "hasBroadSynonym";
                }
                case NARROW: {
                    return "hasNarrowSynonym";
                }
            }
            return "hasRelatedSynonym";
        }
    }
}

