/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model.axiom;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.axiom.AbstractPropertyChainAxiom;
import org.geneontology.obographs.core.model.axiom.Axiom;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractPropertyChainAxiom", generator="Immutables")
@Immutable
public final class PropertyChainAxiom
extends AbstractPropertyChainAxiom {
    @Nullable
    private final Meta meta;
    private final String predicateId;
    private final ImmutableList<String> chainPredicateIds;

    private PropertyChainAxiom(@Nullable Meta meta, String predicateId, ImmutableList<String> chainPredicateIds) {
        this.meta = meta;
        this.predicateId = predicateId;
        this.chainPredicateIds = chainPredicateIds;
    }

    @Override
    @JsonProperty
    @Nullable
    public Meta getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty
    public String getPredicateId() {
        return this.predicateId;
    }

    @JsonProperty
    public ImmutableList<String> getChainPredicateIds() {
        return this.chainPredicateIds;
    }

    public final PropertyChainAxiom withMeta(@Nullable Meta value) {
        if (this.meta == value) {
            return this;
        }
        return new PropertyChainAxiom(value, this.predicateId, this.chainPredicateIds);
    }

    public final PropertyChainAxiom withPredicateId(String value) {
        String newValue = Objects.requireNonNull(value, "predicateId");
        if (this.predicateId.equals(newValue)) {
            return this;
        }
        return new PropertyChainAxiom(this.meta, newValue, this.chainPredicateIds);
    }

    public final PropertyChainAxiom withChainPredicateIds(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new PropertyChainAxiom(this.meta, this.predicateId, (ImmutableList<String>)newValue);
    }

    public final PropertyChainAxiom withChainPredicateIds(Iterable<String> elements) {
        if (this.chainPredicateIds == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new PropertyChainAxiom(this.meta, this.predicateId, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PropertyChainAxiom && this.equalTo((PropertyChainAxiom)another);
    }

    private boolean equalTo(PropertyChainAxiom another) {
        return Objects.equals(this.meta, another.meta) && this.predicateId.equals(another.predicateId) && this.chainPredicateIds.equals(another.chainPredicateIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.meta);
        h += (h << 5) + this.predicateId.hashCode();
        h += (h << 5) + this.chainPredicateIds.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PropertyChainAxiom").omitNullValues().add("meta", (Object)this.meta).add("predicateId", (Object)this.predicateId).add("chainPredicateIds", this.chainPredicateIds).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static PropertyChainAxiom fromJson(Json json) {
        Builder builder = new Builder();
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        if (json.predicateId != null) {
            builder.predicateId(json.predicateId);
        }
        if (json.chainPredicateIds != null) {
            builder.addAllChainPredicateIds(json.chainPredicateIds);
        }
        return builder.build();
    }

    public static PropertyChainAxiom copyOf(AbstractPropertyChainAxiom instance) {
        if (instance instanceof PropertyChainAxiom) {
            return (PropertyChainAxiom)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="AbstractPropertyChainAxiom", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PREDICATE_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private Meta meta;
        @Nullable
        private String predicateId;
        private ImmutableList.Builder<String> chainPredicateIds = ImmutableList.builder();

        @CanIgnoreReturnValue
        public final Builder from(AbstractPropertyChainAxiom instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Axiom instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Meta metaValue;
            Axiom instance;
            if (object instanceof AbstractPropertyChainAxiom) {
                instance = (AbstractPropertyChainAxiom)object;
                this.predicateId(((AbstractPropertyChainAxiom)instance).getPredicateId());
                this.addAllChainPredicateIds(((AbstractPropertyChainAxiom)instance).getChainPredicateIds());
            }
            if (object instanceof Axiom && (metaValue = (instance = (Axiom)object).getMeta()) != null) {
                this.meta(metaValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder meta(@Nullable Meta meta) {
            this.meta = meta;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder predicateId(String predicateId) {
            this.predicateId = Objects.requireNonNull(predicateId, "predicateId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChainPredicateId(String element) {
            this.chainPredicateIds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChainPredicateIds(String ... elements) {
            this.chainPredicateIds.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder chainPredicateIds(Iterable<String> elements) {
            this.chainPredicateIds = ImmutableList.builder();
            return this.addAllChainPredicateIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllChainPredicateIds(Iterable<String> elements) {
            this.chainPredicateIds.addAll(elements);
            return this;
        }

        public PropertyChainAxiom build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PropertyChainAxiom(this.meta, this.predicateId, (ImmutableList<String>)this.chainPredicateIds.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("predicateId");
            }
            return "Cannot build PropertyChainAxiom, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractPropertyChainAxiom", generator="Immutables")
    static final class Json
    extends AbstractPropertyChainAxiom {
        @Nullable
        Meta meta;
        @Nullable
        String predicateId;
        @Nullable
        List<String> chainPredicateIds = ImmutableList.of();

        Json() {
        }

        @JsonProperty
        public void setMeta(@Nullable Meta meta) {
            this.meta = meta;
        }

        @JsonProperty
        public void setPredicateId(String predicateId) {
            this.predicateId = predicateId;
        }

        @JsonProperty
        public void setChainPredicateIds(List<String> chainPredicateIds) {
            this.chainPredicateIds = chainPredicateIds;
        }

        @Override
        public Meta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPredicateId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getChainPredicateIds() {
            throw new UnsupportedOperationException();
        }
    }
}

