/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model.axiom;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.axiom.AbstractLogicalDefinitionAxiom;
import org.geneontology.obographs.core.model.axiom.Axiom;
import org.geneontology.obographs.core.model.axiom.ExistentialRestrictionExpression;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractLogicalDefinitionAxiom", generator="Immutables")
@Immutable
public final class LogicalDefinitionAxiom
extends AbstractLogicalDefinitionAxiom {
    @Nullable
    private final Meta meta;
    private final String definedClassId;
    private final ImmutableList<String> genusIds;
    private final ImmutableList<ExistentialRestrictionExpression> restrictions;

    private LogicalDefinitionAxiom(@Nullable Meta meta, String definedClassId, ImmutableList<String> genusIds, ImmutableList<ExistentialRestrictionExpression> restrictions) {
        this.meta = meta;
        this.definedClassId = definedClassId;
        this.genusIds = genusIds;
        this.restrictions = restrictions;
    }

    @Override
    @JsonProperty
    @Nullable
    public Meta getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty
    public String getDefinedClassId() {
        return this.definedClassId;
    }

    @JsonProperty
    public ImmutableList<String> getGenusIds() {
        return this.genusIds;
    }

    @JsonProperty
    public ImmutableList<ExistentialRestrictionExpression> getRestrictions() {
        return this.restrictions;
    }

    public final LogicalDefinitionAxiom withMeta(@Nullable Meta value) {
        if (this.meta == value) {
            return this;
        }
        return new LogicalDefinitionAxiom(value, this.definedClassId, this.genusIds, this.restrictions);
    }

    public final LogicalDefinitionAxiom withDefinedClassId(String value) {
        String newValue = Objects.requireNonNull(value, "definedClassId");
        if (this.definedClassId.equals(newValue)) {
            return this;
        }
        return new LogicalDefinitionAxiom(this.meta, newValue, this.genusIds, this.restrictions);
    }

    public final LogicalDefinitionAxiom withGenusIds(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new LogicalDefinitionAxiom(this.meta, this.definedClassId, (ImmutableList<String>)newValue, this.restrictions);
    }

    public final LogicalDefinitionAxiom withGenusIds(Iterable<String> elements) {
        if (this.genusIds == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new LogicalDefinitionAxiom(this.meta, this.definedClassId, (ImmutableList<String>)newValue, this.restrictions);
    }

    public final LogicalDefinitionAxiom withRestrictions(ExistentialRestrictionExpression ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new LogicalDefinitionAxiom(this.meta, this.definedClassId, this.genusIds, (ImmutableList<ExistentialRestrictionExpression>)newValue);
    }

    public final LogicalDefinitionAxiom withRestrictions(Iterable<? extends ExistentialRestrictionExpression> elements) {
        if (this.restrictions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new LogicalDefinitionAxiom(this.meta, this.definedClassId, this.genusIds, (ImmutableList<ExistentialRestrictionExpression>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LogicalDefinitionAxiom && this.equalTo((LogicalDefinitionAxiom)another);
    }

    private boolean equalTo(LogicalDefinitionAxiom another) {
        return Objects.equals(this.meta, another.meta) && this.definedClassId.equals(another.definedClassId) && this.genusIds.equals(another.genusIds) && this.restrictions.equals(another.restrictions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.meta);
        h += (h << 5) + this.definedClassId.hashCode();
        h += (h << 5) + this.genusIds.hashCode();
        h += (h << 5) + this.restrictions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LogicalDefinitionAxiom").omitNullValues().add("meta", (Object)this.meta).add("definedClassId", (Object)this.definedClassId).add("genusIds", this.genusIds).add("restrictions", this.restrictions).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static LogicalDefinitionAxiom fromJson(Json json) {
        Builder builder = new Builder();
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        if (json.definedClassId != null) {
            builder.definedClassId(json.definedClassId);
        }
        if (json.genusIds != null) {
            builder.addAllGenusIds(json.genusIds);
        }
        if (json.restrictions != null) {
            builder.addAllRestrictions(json.restrictions);
        }
        return builder.build();
    }

    public static LogicalDefinitionAxiom copyOf(AbstractLogicalDefinitionAxiom instance) {
        if (instance instanceof LogicalDefinitionAxiom) {
            return (LogicalDefinitionAxiom)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="AbstractLogicalDefinitionAxiom", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DEFINED_CLASS_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private Meta meta;
        @Nullable
        private String definedClassId;
        private ImmutableList.Builder<String> genusIds = ImmutableList.builder();
        private ImmutableList.Builder<ExistentialRestrictionExpression> restrictions = ImmutableList.builder();

        @CanIgnoreReturnValue
        public final Builder from(AbstractLogicalDefinitionAxiom instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Axiom instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Meta metaValue;
            Axiom instance;
            if (object instanceof AbstractLogicalDefinitionAxiom) {
                instance = (AbstractLogicalDefinitionAxiom)object;
                this.addAllRestrictions(((AbstractLogicalDefinitionAxiom)instance).getRestrictions());
                this.definedClassId(((AbstractLogicalDefinitionAxiom)instance).getDefinedClassId());
                this.addAllGenusIds(((AbstractLogicalDefinitionAxiom)instance).getGenusIds());
            }
            if (object instanceof Axiom && (metaValue = (instance = (Axiom)object).getMeta()) != null) {
                this.meta(metaValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder meta(@Nullable Meta meta) {
            this.meta = meta;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder definedClassId(String definedClassId) {
            this.definedClassId = Objects.requireNonNull(definedClassId, "definedClassId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGenusId(String element) {
            this.genusIds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGenusIds(String ... elements) {
            this.genusIds.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder genusIds(Iterable<String> elements) {
            this.genusIds = ImmutableList.builder();
            return this.addAllGenusIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGenusIds(Iterable<String> elements) {
            this.genusIds.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRestriction(ExistentialRestrictionExpression element) {
            this.restrictions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRestrictions(ExistentialRestrictionExpression ... elements) {
            this.restrictions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder restrictions(Iterable<? extends ExistentialRestrictionExpression> elements) {
            this.restrictions = ImmutableList.builder();
            return this.addAllRestrictions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRestrictions(Iterable<? extends ExistentialRestrictionExpression> elements) {
            this.restrictions.addAll(elements);
            return this;
        }

        public LogicalDefinitionAxiom build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new LogicalDefinitionAxiom(this.meta, this.definedClassId, (ImmutableList<String>)this.genusIds.build(), (ImmutableList<ExistentialRestrictionExpression>)this.restrictions.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("definedClassId");
            }
            return "Cannot build LogicalDefinitionAxiom, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractLogicalDefinitionAxiom", generator="Immutables")
    static final class Json
    extends AbstractLogicalDefinitionAxiom {
        @Nullable
        Meta meta;
        @Nullable
        String definedClassId;
        @Nullable
        List<String> genusIds = ImmutableList.of();
        @Nullable
        List<ExistentialRestrictionExpression> restrictions = ImmutableList.of();

        Json() {
        }

        @JsonProperty
        public void setMeta(@Nullable Meta meta) {
            this.meta = meta;
        }

        @JsonProperty
        public void setDefinedClassId(String definedClassId) {
            this.definedClassId = definedClassId;
        }

        @JsonProperty
        public void setGenusIds(List<String> genusIds) {
            this.genusIds = genusIds;
        }

        @JsonProperty
        public void setRestrictions(List<ExistentialRestrictionExpression> restrictions) {
            this.restrictions = restrictions;
        }

        @Override
        public Meta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDefinedClassId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getGenusIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ExistentialRestrictionExpression> getRestrictions() {
            throw new UnsupportedOperationException();
        }
    }
}

