/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model.axiom;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.axiom.AbstractEquivalentNodesSet;
import org.geneontology.obographs.core.model.axiom.Axiom;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractEquivalentNodesSet", generator="Immutables")
@Immutable
public final class EquivalentNodesSet
extends AbstractEquivalentNodesSet {
    @Nullable
    private final Meta meta;
    private final String representativeNodeId;
    private final ImmutableSet<String> nodeIds;

    private EquivalentNodesSet(Builder builder) {
        this.meta = builder.meta;
        this.nodeIds = builder.nodeIds.build();
        this.representativeNodeId = builder.representativeNodeId != null ? builder.representativeNodeId : Objects.requireNonNull(super.getRepresentativeNodeId(), "representativeNodeId");
    }

    private EquivalentNodesSet(@Nullable Meta meta, String representativeNodeId, ImmutableSet<String> nodeIds) {
        this.meta = meta;
        this.representativeNodeId = representativeNodeId;
        this.nodeIds = nodeIds;
    }

    @Override
    @JsonProperty
    @Nullable
    public Meta getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty
    public String getRepresentativeNodeId() {
        return this.representativeNodeId;
    }

    @JsonProperty
    public ImmutableSet<String> getNodeIds() {
        return this.nodeIds;
    }

    public final EquivalentNodesSet withMeta(@Nullable Meta value) {
        if (this.meta == value) {
            return this;
        }
        return new EquivalentNodesSet(value, this.representativeNodeId, this.nodeIds);
    }

    public final EquivalentNodesSet withRepresentativeNodeId(String value) {
        String newValue = Objects.requireNonNull(value, "representativeNodeId");
        if (this.representativeNodeId.equals(newValue)) {
            return this;
        }
        return new EquivalentNodesSet(this.meta, newValue, this.nodeIds);
    }

    public final EquivalentNodesSet withNodeIds(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new EquivalentNodesSet(this.meta, this.representativeNodeId, (ImmutableSet<String>)newValue);
    }

    public final EquivalentNodesSet withNodeIds(Iterable<String> elements) {
        if (this.nodeIds == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new EquivalentNodesSet(this.meta, this.representativeNodeId, (ImmutableSet<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EquivalentNodesSet && this.equalTo((EquivalentNodesSet)another);
    }

    private boolean equalTo(EquivalentNodesSet another) {
        return Objects.equals(this.meta, another.meta) && this.representativeNodeId.equals(another.representativeNodeId) && this.nodeIds.equals(another.nodeIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.meta);
        h += (h << 5) + this.representativeNodeId.hashCode();
        h += (h << 5) + this.nodeIds.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EquivalentNodesSet").omitNullValues().add("meta", (Object)this.meta).add("representativeNodeId", (Object)this.representativeNodeId).add("nodeIds", this.nodeIds).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static EquivalentNodesSet fromJson(Json json) {
        Builder builder = new Builder();
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        if (json.representativeNodeId != null) {
            builder.representativeNodeId(json.representativeNodeId);
        }
        if (json.nodeIds != null) {
            builder.addAllNodeIds(json.nodeIds);
        }
        return builder.build();
    }

    public static EquivalentNodesSet copyOf(AbstractEquivalentNodesSet instance) {
        if (instance instanceof EquivalentNodesSet) {
            return (EquivalentNodesSet)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="AbstractEquivalentNodesSet", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Meta meta;
        @Nullable
        private String representativeNodeId;
        private ImmutableSet.Builder<String> nodeIds = ImmutableSet.builder();

        @CanIgnoreReturnValue
        public final Builder from(AbstractEquivalentNodesSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Axiom instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Meta metaValue;
            Axiom instance;
            if (object instanceof AbstractEquivalentNodesSet) {
                instance = (AbstractEquivalentNodesSet)object;
                this.addAllNodeIds(((AbstractEquivalentNodesSet)instance).getNodeIds());
                this.representativeNodeId(((AbstractEquivalentNodesSet)instance).getRepresentativeNodeId());
            }
            if (object instanceof Axiom && (metaValue = (instance = (Axiom)object).getMeta()) != null) {
                this.meta(metaValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder meta(@Nullable Meta meta) {
            this.meta = meta;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder representativeNodeId(String representativeNodeId) {
            this.representativeNodeId = Objects.requireNonNull(representativeNodeId, "representativeNodeId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeId(String element) {
            this.nodeIds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodeIds(String ... elements) {
            this.nodeIds.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodeIds(Iterable<String> elements) {
            this.nodeIds = ImmutableSet.builder();
            return this.addAllNodeIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNodeIds(Iterable<String> elements) {
            this.nodeIds.addAll(elements);
            return this;
        }

        public EquivalentNodesSet build() {
            return new EquivalentNodesSet(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractEquivalentNodesSet", generator="Immutables")
    static final class Json
    extends AbstractEquivalentNodesSet {
        @Nullable
        Meta meta;
        @Nullable
        String representativeNodeId;
        @Nullable
        Set<String> nodeIds = ImmutableSet.of();

        Json() {
        }

        @JsonProperty
        public void setMeta(@Nullable Meta meta) {
            this.meta = meta;
        }

        @JsonProperty
        public void setRepresentativeNodeId(String representativeNodeId) {
            this.representativeNodeId = representativeNodeId;
        }

        @JsonProperty
        public void setNodeIds(Set<String> nodeIds) {
            this.nodeIds = nodeIds;
        }

        @Override
        public Meta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRepresentativeNodeId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> getNodeIds() {
            throw new UnsupportedOperationException();
        }
    }
}

