/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model.axiom;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.Edge;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.axiom.AbstractDomainRangeAxiom;
import org.geneontology.obographs.core.model.axiom.Axiom;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractDomainRangeAxiom", generator="Immutables")
@Immutable
public final class DomainRangeAxiom
extends AbstractDomainRangeAxiom {
    @Nullable
    private final Meta meta;
    private final String predicateId;
    private final ImmutableSet<String> domainClassIds;
    private final ImmutableSet<String> rangeClassIds;
    private final ImmutableSet<Edge> allValuesFromEdges;

    private DomainRangeAxiom(@Nullable Meta meta, String predicateId, ImmutableSet<String> domainClassIds, ImmutableSet<String> rangeClassIds, ImmutableSet<Edge> allValuesFromEdges) {
        this.meta = meta;
        this.predicateId = predicateId;
        this.domainClassIds = domainClassIds;
        this.rangeClassIds = rangeClassIds;
        this.allValuesFromEdges = allValuesFromEdges;
    }

    @Override
    @JsonProperty
    @Nullable
    public Meta getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty
    public String getPredicateId() {
        return this.predicateId;
    }

    @JsonProperty
    public ImmutableSet<String> getDomainClassIds() {
        return this.domainClassIds;
    }

    @JsonProperty
    public ImmutableSet<String> getRangeClassIds() {
        return this.rangeClassIds;
    }

    @JsonProperty
    public ImmutableSet<Edge> getAllValuesFromEdges() {
        return this.allValuesFromEdges;
    }

    public final DomainRangeAxiom withMeta(@Nullable Meta value) {
        if (this.meta == value) {
            return this;
        }
        return new DomainRangeAxiom(value, this.predicateId, this.domainClassIds, this.rangeClassIds, this.allValuesFromEdges);
    }

    public final DomainRangeAxiom withPredicateId(String value) {
        String newValue = Objects.requireNonNull(value, "predicateId");
        if (this.predicateId.equals(newValue)) {
            return this;
        }
        return new DomainRangeAxiom(this.meta, newValue, this.domainClassIds, this.rangeClassIds, this.allValuesFromEdges);
    }

    public final DomainRangeAxiom withDomainClassIds(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new DomainRangeAxiom(this.meta, this.predicateId, (ImmutableSet<String>)newValue, this.rangeClassIds, this.allValuesFromEdges);
    }

    public final DomainRangeAxiom withDomainClassIds(Iterable<String> elements) {
        if (this.domainClassIds == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new DomainRangeAxiom(this.meta, this.predicateId, (ImmutableSet<String>)newValue, this.rangeClassIds, this.allValuesFromEdges);
    }

    public final DomainRangeAxiom withRangeClassIds(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new DomainRangeAxiom(this.meta, this.predicateId, this.domainClassIds, (ImmutableSet<String>)newValue, this.allValuesFromEdges);
    }

    public final DomainRangeAxiom withRangeClassIds(Iterable<String> elements) {
        if (this.rangeClassIds == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new DomainRangeAxiom(this.meta, this.predicateId, this.domainClassIds, (ImmutableSet<String>)newValue, this.allValuesFromEdges);
    }

    public final DomainRangeAxiom withAllValuesFromEdges(Edge ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new DomainRangeAxiom(this.meta, this.predicateId, this.domainClassIds, this.rangeClassIds, (ImmutableSet<Edge>)newValue);
    }

    public final DomainRangeAxiom withAllValuesFromEdges(Iterable<? extends Edge> elements) {
        if (this.allValuesFromEdges == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new DomainRangeAxiom(this.meta, this.predicateId, this.domainClassIds, this.rangeClassIds, (ImmutableSet<Edge>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DomainRangeAxiom && this.equalTo((DomainRangeAxiom)another);
    }

    private boolean equalTo(DomainRangeAxiom another) {
        return Objects.equals(this.meta, another.meta) && this.predicateId.equals(another.predicateId) && this.domainClassIds.equals(another.domainClassIds) && this.rangeClassIds.equals(another.rangeClassIds) && this.allValuesFromEdges.equals(another.allValuesFromEdges);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.meta);
        h += (h << 5) + this.predicateId.hashCode();
        h += (h << 5) + this.domainClassIds.hashCode();
        h += (h << 5) + this.rangeClassIds.hashCode();
        h += (h << 5) + this.allValuesFromEdges.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DomainRangeAxiom").omitNullValues().add("meta", (Object)this.meta).add("predicateId", (Object)this.predicateId).add("domainClassIds", this.domainClassIds).add("rangeClassIds", this.rangeClassIds).add("allValuesFromEdges", this.allValuesFromEdges).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static DomainRangeAxiom fromJson(Json json) {
        Builder builder = new Builder();
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        if (json.predicateId != null) {
            builder.predicateId(json.predicateId);
        }
        if (json.domainClassIds != null) {
            builder.addAllDomainClassIds(json.domainClassIds);
        }
        if (json.rangeClassIds != null) {
            builder.addAllRangeClassIds(json.rangeClassIds);
        }
        if (json.allValuesFromEdges != null) {
            builder.addAllAllValuesFromEdges(json.allValuesFromEdges);
        }
        return builder.build();
    }

    public static DomainRangeAxiom copyOf(AbstractDomainRangeAxiom instance) {
        if (instance instanceof DomainRangeAxiom) {
            return (DomainRangeAxiom)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="AbstractDomainRangeAxiom", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PREDICATE_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private Meta meta;
        @Nullable
        private String predicateId;
        private ImmutableSet.Builder<String> domainClassIds = ImmutableSet.builder();
        private ImmutableSet.Builder<String> rangeClassIds = ImmutableSet.builder();
        private ImmutableSet.Builder<Edge> allValuesFromEdges = ImmutableSet.builder();

        @CanIgnoreReturnValue
        public final Builder from(AbstractDomainRangeAxiom instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Axiom instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Meta metaValue;
            Axiom instance;
            if (object instanceof AbstractDomainRangeAxiom) {
                instance = (AbstractDomainRangeAxiom)object;
                this.addAllDomainClassIds(((AbstractDomainRangeAxiom)instance).getDomainClassIds());
                this.predicateId(((AbstractDomainRangeAxiom)instance).getPredicateId());
                this.addAllRangeClassIds(((AbstractDomainRangeAxiom)instance).getRangeClassIds());
                this.addAllAllValuesFromEdges(((AbstractDomainRangeAxiom)instance).getAllValuesFromEdges());
            }
            if (object instanceof Axiom && (metaValue = (instance = (Axiom)object).getMeta()) != null) {
                this.meta(metaValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder meta(@Nullable Meta meta) {
            this.meta = meta;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder predicateId(String predicateId) {
            this.predicateId = Objects.requireNonNull(predicateId, "predicateId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDomainClassId(String element) {
            this.domainClassIds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDomainClassIds(String ... elements) {
            this.domainClassIds.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder domainClassIds(Iterable<String> elements) {
            this.domainClassIds = ImmutableSet.builder();
            return this.addAllDomainClassIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDomainClassIds(Iterable<String> elements) {
            this.domainClassIds.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRangeClassId(String element) {
            this.rangeClassIds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRangeClassIds(String ... elements) {
            this.rangeClassIds.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rangeClassIds(Iterable<String> elements) {
            this.rangeClassIds = ImmutableSet.builder();
            return this.addAllRangeClassIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRangeClassIds(Iterable<String> elements) {
            this.rangeClassIds.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllValuesFromEdge(Edge element) {
            this.allValuesFromEdges.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllValuesFromEdges(Edge ... elements) {
            this.allValuesFromEdges.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allValuesFromEdges(Iterable<? extends Edge> elements) {
            this.allValuesFromEdges = ImmutableSet.builder();
            return this.addAllAllValuesFromEdges(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAllValuesFromEdges(Iterable<? extends Edge> elements) {
            this.allValuesFromEdges.addAll(elements);
            return this;
        }

        public DomainRangeAxiom build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DomainRangeAxiom(this.meta, this.predicateId, (ImmutableSet<String>)this.domainClassIds.build(), (ImmutableSet<String>)this.rangeClassIds.build(), (ImmutableSet<Edge>)this.allValuesFromEdges.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("predicateId");
            }
            return "Cannot build DomainRangeAxiom, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractDomainRangeAxiom", generator="Immutables")
    static final class Json
    extends AbstractDomainRangeAxiom {
        @Nullable
        Meta meta;
        @Nullable
        String predicateId;
        @Nullable
        Set<String> domainClassIds = ImmutableSet.of();
        @Nullable
        Set<String> rangeClassIds = ImmutableSet.of();
        @Nullable
        Set<Edge> allValuesFromEdges = ImmutableSet.of();

        Json() {
        }

        @JsonProperty
        public void setMeta(@Nullable Meta meta) {
            this.meta = meta;
        }

        @JsonProperty
        public void setPredicateId(String predicateId) {
            this.predicateId = predicateId;
        }

        @JsonProperty
        public void setDomainClassIds(Set<String> domainClassIds) {
            this.domainClassIds = domainClassIds;
        }

        @JsonProperty
        public void setRangeClassIds(Set<String> rangeClassIds) {
            this.rangeClassIds = rangeClassIds;
        }

        @JsonProperty
        public void setAllValuesFromEdges(Set<Edge> allValuesFromEdges) {
            this.allValuesFromEdges = allValuesFromEdges;
        }

        @Override
        public Meta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPredicateId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> getDomainClassIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> getRangeClassIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Edge> getAllValuesFromEdges() {
            throw new UnsupportedOperationException();
        }
    }
}

