/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.AbstractNode;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.NodeOrEdge;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractNode", generator="Immutables")
@Immutable
public final class Node
extends AbstractNode {
    @Nullable
    private final Meta meta;
    private final String id;
    private final String label;
    @Nullable
    private final AbstractNode.RDFTYPES type;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private Node(Builder builder) {
        this.meta = builder.meta;
        this.type = builder.type;
        if (builder.id != null) {
            this.initShim.id(builder.id);
        }
        if (builder.label != null) {
            this.initShim.label(builder.label);
        }
        this.id = this.initShim.getId();
        this.label = this.initShim.getLabel();
        this.initShim = null;
    }

    private Node(@Nullable Meta meta, String id, String label, @Nullable AbstractNode.RDFTYPES type) {
        this.meta = meta;
        this.id = id;
        this.label = label;
        this.type = type;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    @Nullable
    public Meta getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty
    public String getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    @Override
    @JsonProperty(value="lbl")
    public String getLabel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLabel() : this.label;
    }

    @Override
    @JsonProperty
    @Nullable
    public AbstractNode.RDFTYPES getType() {
        return this.type;
    }

    public final Node withMeta(@Nullable Meta value) {
        if (this.meta == value) {
            return this;
        }
        return new Node(value, this.id, this.label, this.type);
    }

    public final Node withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new Node(this.meta, newValue, this.label, this.type);
    }

    public final Node withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new Node(this.meta, this.id, newValue, this.type);
    }

    public final Node withType(@Nullable AbstractNode.RDFTYPES value) {
        if (this.type == value) {
            return this;
        }
        if (Objects.equals((Object)this.type, (Object)value)) {
            return this;
        }
        return new Node(this.meta, this.id, this.label, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Node && this.equalTo((Node)another);
    }

    private boolean equalTo(Node another) {
        return Objects.equals(this.meta, another.meta) && this.id.equals(another.id) && this.label.equals(another.label) && Objects.equals((Object)this.type, (Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.meta);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.type);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Node").omitNullValues().add("meta", (Object)this.meta).add("id", (Object)this.id).add("label", (Object)this.label).add("type", (Object)this.type).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Node fromJson(Json json) {
        Builder builder = new Builder();
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.label != null) {
            builder.label(json.label);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static Node copyOf(AbstractNode instance) {
        if (instance instanceof Node) {
            return (Node)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="AbstractNode", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Meta meta;
        @Nullable
        private String id;
        @Nullable
        private String label;
        @Nullable
        private AbstractNode.RDFTYPES type;

        @CanIgnoreReturnValue
        public final Builder from(AbstractNode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(NodeOrEdge instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Meta metaValue;
            NodeOrEdge instance;
            if (object instanceof AbstractNode) {
                instance = (AbstractNode)object;
                AbstractNode.RDFTYPES typeValue = ((AbstractNode)instance).getType();
                if (typeValue != null) {
                    this.type(typeValue);
                }
                this.id(((AbstractNode)instance).getId());
                this.label(((AbstractNode)instance).getLabel());
            }
            if (object instanceof NodeOrEdge && (metaValue = (instance = (NodeOrEdge)object).getMeta()) != null) {
                this.meta(metaValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder meta(@Nullable Meta meta) {
            this.meta = meta;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(@Nullable AbstractNode.RDFTYPES type) {
            this.type = type;
            return this;
        }

        public Node build() {
            return new Node(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractNode", generator="Immutables")
    static final class Json
    extends AbstractNode {
        @Nullable
        Meta meta;
        @Nullable
        String id;
        @Nullable
        String label;
        @Nullable
        AbstractNode.RDFTYPES type;

        Json() {
        }

        @JsonProperty
        public void setMeta(@Nullable Meta meta) {
            this.meta = meta;
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="lbl")
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty
        public void setType(@Nullable AbstractNode.RDFTYPES type) {
            this.type = type;
        }

        @Override
        public Meta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AbstractNode.RDFTYPES getType() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AbstractNode", generator="Immutables")
    private final class InitShim {
        private byte idBuildStage = 0;
        private String id;
        private byte labelBuildStage = 0;
        private String label;

        private InitShim() {
        }

        String getId() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = Objects.requireNonNull(Node.super.getId(), "id");
                this.idBuildStage = 1;
            }
            return this.id;
        }

        void id(String id) {
            this.id = id;
            this.idBuildStage = 1;
        }

        String getLabel() {
            if (this.labelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.labelBuildStage == 0) {
                this.labelBuildStage = (byte)-1;
                this.label = Objects.requireNonNull(Node.super.getLabel(), "label");
                this.labelBuildStage = 1;
            }
            return this.label;
        }

        void label(String label) {
            this.label = label;
            this.labelBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            if (this.labelBuildStage == -1) {
                attributes.add("label");
            }
            return "Cannot build Node, attribute initializers form cycle " + attributes;
        }
    }
}

