/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.AbstractMeta;
import org.geneontology.obographs.core.model.meta.BasicPropertyValue;
import org.geneontology.obographs.core.model.meta.DefinitionPropertyValue;
import org.geneontology.obographs.core.model.meta.SynonymPropertyValue;
import org.geneontology.obographs.core.model.meta.XrefPropertyValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractMeta", generator="Immutables")
@Immutable
public final class Meta
extends AbstractMeta {
    @Nullable
    private final DefinitionPropertyValue definition;
    private final ImmutableList<String> comments;
    private final ImmutableList<String> subsets;
    private final ImmutableList<SynonymPropertyValue> synonyms;
    private final ImmutableList<XrefPropertyValue> xrefs;
    private final ImmutableList<String> xrefsValues;
    private final ImmutableList<BasicPropertyValue> basicPropertyValues;
    private final String version;
    private final boolean deprecated;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private Meta(Builder builder) {
        this.definition = builder.definition;
        this.comments = builder.comments.build();
        this.subsets = builder.subsets.build();
        this.synonyms = builder.synonyms.build();
        this.xrefs = builder.xrefs.build();
        this.basicPropertyValues = builder.basicPropertyValues.build();
        if (builder.xrefsValuesIsSet()) {
            this.initShim.xrefsValues((ImmutableList<String>)builder.xrefsValues.build());
        }
        if (builder.version != null) {
            this.initShim.version(builder.version);
        }
        if (builder.deprecatedIsSet()) {
            this.initShim.deprecated(builder.deprecated);
        }
        this.xrefsValues = this.initShim.getXrefsValues();
        this.version = this.initShim.getVersion();
        this.deprecated = this.initShim.getDeprecated();
        this.initShim = null;
    }

    private Meta(@Nullable DefinitionPropertyValue definition, ImmutableList<String> comments, ImmutableList<String> subsets, ImmutableList<SynonymPropertyValue> synonyms, ImmutableList<XrefPropertyValue> xrefs, ImmutableList<String> xrefsValues, ImmutableList<BasicPropertyValue> basicPropertyValues, String version, boolean deprecated) {
        this.definition = definition;
        this.comments = comments;
        this.subsets = subsets;
        this.synonyms = synonyms;
        this.xrefs = xrefs;
        this.xrefsValues = xrefsValues;
        this.basicPropertyValues = basicPropertyValues;
        this.version = version;
        this.deprecated = deprecated;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    @Nullable
    public DefinitionPropertyValue getDefinition() {
        return this.definition;
    }

    @JsonProperty
    public ImmutableList<String> getComments() {
        return this.comments;
    }

    @JsonProperty
    public ImmutableList<String> getSubsets() {
        return this.subsets;
    }

    @JsonProperty
    public ImmutableList<SynonymPropertyValue> getSynonyms() {
        return this.synonyms;
    }

    @JsonProperty
    public ImmutableList<XrefPropertyValue> getXrefs() {
        return this.xrefs;
    }

    @JsonProperty(value="xrefsValues")
    @JsonIgnore
    public ImmutableList<String> getXrefsValues() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getXrefsValues() : this.xrefsValues;
    }

    @JsonProperty
    public ImmutableList<BasicPropertyValue> getBasicPropertyValues() {
        return this.basicPropertyValues;
    }

    @Override
    @JsonProperty
    public String getVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getVersion() : this.version;
    }

    @Override
    @JsonProperty
    public boolean getDeprecated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDeprecated() : this.deprecated;
    }

    public final Meta withDefinition(@Nullable DefinitionPropertyValue value) {
        if (this.definition == value) {
            return this;
        }
        return new Meta(value, this.comments, this.subsets, this.synonyms, this.xrefs, this.xrefsValues, this.basicPropertyValues, this.version, this.deprecated);
    }

    public final Meta withComments(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Meta(this.definition, (ImmutableList<String>)newValue, this.subsets, this.synonyms, this.xrefs, this.xrefsValues, this.basicPropertyValues, this.version, this.deprecated);
    }

    public final Meta withComments(Iterable<String> elements) {
        if (this.comments == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Meta(this.definition, (ImmutableList<String>)newValue, this.subsets, this.synonyms, this.xrefs, this.xrefsValues, this.basicPropertyValues, this.version, this.deprecated);
    }

    public final Meta withSubsets(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Meta(this.definition, this.comments, (ImmutableList<String>)newValue, this.synonyms, this.xrefs, this.xrefsValues, this.basicPropertyValues, this.version, this.deprecated);
    }

    public final Meta withSubsets(Iterable<String> elements) {
        if (this.subsets == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Meta(this.definition, this.comments, (ImmutableList<String>)newValue, this.synonyms, this.xrefs, this.xrefsValues, this.basicPropertyValues, this.version, this.deprecated);
    }

    public final Meta withSynonyms(SynonymPropertyValue ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Meta(this.definition, this.comments, this.subsets, (ImmutableList<SynonymPropertyValue>)newValue, this.xrefs, this.xrefsValues, this.basicPropertyValues, this.version, this.deprecated);
    }

    public final Meta withSynonyms(Iterable<? extends SynonymPropertyValue> elements) {
        if (this.synonyms == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Meta(this.definition, this.comments, this.subsets, (ImmutableList<SynonymPropertyValue>)newValue, this.xrefs, this.xrefsValues, this.basicPropertyValues, this.version, this.deprecated);
    }

    public final Meta withXrefs(XrefPropertyValue ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Meta(this.definition, this.comments, this.subsets, this.synonyms, (ImmutableList<XrefPropertyValue>)newValue, this.xrefsValues, this.basicPropertyValues, this.version, this.deprecated);
    }

    public final Meta withXrefs(Iterable<? extends XrefPropertyValue> elements) {
        if (this.xrefs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Meta(this.definition, this.comments, this.subsets, this.synonyms, (ImmutableList<XrefPropertyValue>)newValue, this.xrefsValues, this.basicPropertyValues, this.version, this.deprecated);
    }

    public final Meta withXrefsValues(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Meta(this.definition, this.comments, this.subsets, this.synonyms, this.xrefs, (ImmutableList<String>)newValue, this.basicPropertyValues, this.version, this.deprecated);
    }

    public final Meta withXrefsValues(Iterable<String> elements) {
        if (this.xrefsValues == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Meta(this.definition, this.comments, this.subsets, this.synonyms, this.xrefs, (ImmutableList<String>)newValue, this.basicPropertyValues, this.version, this.deprecated);
    }

    public final Meta withBasicPropertyValues(BasicPropertyValue ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Meta(this.definition, this.comments, this.subsets, this.synonyms, this.xrefs, this.xrefsValues, (ImmutableList<BasicPropertyValue>)newValue, this.version, this.deprecated);
    }

    public final Meta withBasicPropertyValues(Iterable<? extends BasicPropertyValue> elements) {
        if (this.basicPropertyValues == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Meta(this.definition, this.comments, this.subsets, this.synonyms, this.xrefs, this.xrefsValues, (ImmutableList<BasicPropertyValue>)newValue, this.version, this.deprecated);
    }

    public final Meta withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new Meta(this.definition, this.comments, this.subsets, this.synonyms, this.xrefs, this.xrefsValues, this.basicPropertyValues, newValue, this.deprecated);
    }

    public final Meta withDeprecated(boolean value) {
        if (this.deprecated == value) {
            return this;
        }
        return new Meta(this.definition, this.comments, this.subsets, this.synonyms, this.xrefs, this.xrefsValues, this.basicPropertyValues, this.version, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Meta && this.equalTo((Meta)another);
    }

    private boolean equalTo(Meta another) {
        return Objects.equals(this.definition, another.definition) && this.comments.equals(another.comments) && this.subsets.equals(another.subsets) && this.synonyms.equals(another.synonyms) && this.xrefs.equals(another.xrefs) && this.xrefsValues.equals(another.xrefsValues) && this.basicPropertyValues.equals(another.basicPropertyValues) && this.version.equals(another.version) && this.deprecated == another.deprecated;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.definition);
        h += (h << 5) + this.comments.hashCode();
        h += (h << 5) + this.subsets.hashCode();
        h += (h << 5) + this.synonyms.hashCode();
        h += (h << 5) + this.xrefs.hashCode();
        h += (h << 5) + this.xrefsValues.hashCode();
        h += (h << 5) + this.basicPropertyValues.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.deprecated);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Meta").omitNullValues().add("definition", (Object)this.definition).add("comments", this.comments).add("subsets", this.subsets).add("synonyms", this.synonyms).add("xrefs", this.xrefs).add("xrefsValues", this.xrefsValues).add("basicPropertyValues", this.basicPropertyValues).add("version", (Object)this.version).add("deprecated", this.deprecated).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Meta fromJson(Json json) {
        Builder builder = new Builder();
        if (json.definition != null) {
            builder.definition(json.definition);
        }
        if (json.comments != null) {
            builder.addAllComments(json.comments);
        }
        if (json.subsets != null) {
            builder.addAllSubsets(json.subsets);
        }
        if (json.synonyms != null) {
            builder.addAllSynonyms(json.synonyms);
        }
        if (json.xrefs != null) {
            builder.addAllXrefs(json.xrefs);
        }
        if (json.xrefsValuesIsSet) {
            builder.addAllXrefsValues(json.xrefsValues);
        }
        if (json.basicPropertyValues != null) {
            builder.addAllBasicPropertyValues(json.basicPropertyValues);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.deprecatedIsSet) {
            builder.deprecated(json.deprecated);
        }
        return builder.build();
    }

    public static Meta copyOf(AbstractMeta instance) {
        if (instance instanceof Meta) {
            return (Meta)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="AbstractMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_XREFS_VALUES = 1L;
        private static final long OPT_BIT_DEPRECATED = 2L;
        private long optBits;
        @Nullable
        private DefinitionPropertyValue definition;
        private ImmutableList.Builder<String> comments = ImmutableList.builder();
        private ImmutableList.Builder<String> subsets = ImmutableList.builder();
        private ImmutableList.Builder<SynonymPropertyValue> synonyms = ImmutableList.builder();
        private ImmutableList.Builder<XrefPropertyValue> xrefs = ImmutableList.builder();
        private ImmutableList.Builder<String> xrefsValues = ImmutableList.builder();
        private ImmutableList.Builder<BasicPropertyValue> basicPropertyValues = ImmutableList.builder();
        @Nullable
        private String version;
        private boolean deprecated;

        @CanIgnoreReturnValue
        public final Builder from(AbstractMeta instance) {
            Objects.requireNonNull(instance, "instance");
            DefinitionPropertyValue definitionValue = instance.getDefinition();
            if (definitionValue != null) {
                this.definition(definitionValue);
            }
            this.addAllComments(instance.getComments());
            this.addAllSubsets(instance.getSubsets());
            this.addAllSynonyms(instance.getSynonyms());
            this.addAllXrefs(instance.getXrefs());
            this.addAllXrefsValues(instance.getXrefsValues());
            this.addAllBasicPropertyValues(instance.getBasicPropertyValues());
            this.version(instance.getVersion());
            this.deprecated(instance.getDeprecated());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder definition(@Nullable DefinitionPropertyValue definition) {
            this.definition = definition;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addComment(String element) {
            this.comments.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addComments(String ... elements) {
            this.comments.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder comments(Iterable<String> elements) {
            this.comments = ImmutableList.builder();
            return this.addAllComments(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllComments(Iterable<String> elements) {
            this.comments.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSubset(String element) {
            this.subsets.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSubsets(String ... elements) {
            this.subsets.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subsets(Iterable<String> elements) {
            this.subsets = ImmutableList.builder();
            return this.addAllSubsets(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSubsets(Iterable<String> elements) {
            this.subsets.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSynonym(SynonymPropertyValue element) {
            this.synonyms.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSynonyms(SynonymPropertyValue ... elements) {
            this.synonyms.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder synonyms(Iterable<? extends SynonymPropertyValue> elements) {
            this.synonyms = ImmutableList.builder();
            return this.addAllSynonyms(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSynonyms(Iterable<? extends SynonymPropertyValue> elements) {
            this.synonyms.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXref(XrefPropertyValue element) {
            this.xrefs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXrefs(XrefPropertyValue ... elements) {
            this.xrefs.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xrefs(Iterable<? extends XrefPropertyValue> elements) {
            this.xrefs = ImmutableList.builder();
            return this.addAllXrefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllXrefs(Iterable<? extends XrefPropertyValue> elements) {
            this.xrefs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXrefsValue(String element) {
            this.xrefsValues.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXrefsValues(String ... elements) {
            this.xrefsValues.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xrefsValues(Iterable<String> elements) {
            this.xrefsValues = ImmutableList.builder();
            return this.addAllXrefsValues(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllXrefsValues(Iterable<String> elements) {
            this.xrefsValues.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBasicPropertyValue(BasicPropertyValue element) {
            this.basicPropertyValues.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBasicPropertyValues(BasicPropertyValue ... elements) {
            this.basicPropertyValues.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder basicPropertyValues(Iterable<? extends BasicPropertyValue> elements) {
            this.basicPropertyValues = ImmutableList.builder();
            return this.addAllBasicPropertyValues(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllBasicPropertyValues(Iterable<? extends BasicPropertyValue> elements) {
            this.basicPropertyValues.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            this.optBits |= 2L;
            return this;
        }

        public Meta build() {
            return new Meta(this);
        }

        private boolean xrefsValuesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean deprecatedIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractMeta", generator="Immutables")
    static final class Json
    extends AbstractMeta {
        @Nullable
        DefinitionPropertyValue definition;
        @Nullable
        List<String> comments = ImmutableList.of();
        @Nullable
        List<String> subsets = ImmutableList.of();
        @Nullable
        List<SynonymPropertyValue> synonyms = ImmutableList.of();
        @Nullable
        List<XrefPropertyValue> xrefs = ImmutableList.of();
        @Nullable
        List<String> xrefsValues = ImmutableList.of();
        boolean xrefsValuesIsSet;
        @Nullable
        List<BasicPropertyValue> basicPropertyValues = ImmutableList.of();
        @Nullable
        String version;
        boolean deprecated;
        boolean deprecatedIsSet;

        Json() {
        }

        @JsonProperty
        public void setDefinition(@Nullable DefinitionPropertyValue definition) {
            this.definition = definition;
        }

        @JsonProperty
        public void setComments(List<String> comments) {
            this.comments = comments;
        }

        @JsonProperty
        public void setSubsets(List<String> subsets) {
            this.subsets = subsets;
        }

        @JsonProperty
        public void setSynonyms(List<SynonymPropertyValue> synonyms) {
            this.synonyms = synonyms;
        }

        @JsonProperty
        public void setXrefs(List<XrefPropertyValue> xrefs) {
            this.xrefs = xrefs;
        }

        @JsonProperty(value="xrefsValues")
        @JsonIgnore
        public void setXrefsValues(List<String> xrefsValues) {
            this.xrefsValues = xrefsValues;
            this.xrefsValuesIsSet = true;
        }

        @JsonProperty
        public void setBasicPropertyValues(List<BasicPropertyValue> basicPropertyValues) {
            this.basicPropertyValues = basicPropertyValues;
        }

        @JsonProperty
        public void setVersion(String version) {
            this.version = version;
        }

        @JsonProperty
        public void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
            this.deprecatedIsSet = true;
        }

        @Override
        public DefinitionPropertyValue getDefinition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getComments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSubsets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SynonymPropertyValue> getSynonyms() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<XrefPropertyValue> getXrefs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getXrefsValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<BasicPropertyValue> getBasicPropertyValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getDeprecated() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AbstractMeta", generator="Immutables")
    private final class InitShim {
        private byte xrefsValuesBuildStage = 0;
        private ImmutableList<String> xrefsValues;
        private byte versionBuildStage = 0;
        private String version;
        private byte deprecatedBuildStage = 0;
        private boolean deprecated;

        private InitShim() {
        }

        ImmutableList<String> getXrefsValues() {
            if (this.xrefsValuesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.xrefsValuesBuildStage == 0) {
                this.xrefsValuesBuildStage = (byte)-1;
                this.xrefsValues = ImmutableList.copyOf((Collection)Meta.super.getXrefsValues());
                this.xrefsValuesBuildStage = 1;
            }
            return this.xrefsValues;
        }

        void xrefsValues(ImmutableList<String> xrefsValues) {
            this.xrefsValues = xrefsValues;
            this.xrefsValuesBuildStage = 1;
        }

        String getVersion() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(Meta.super.getVersion(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        void version(String version) {
            this.version = version;
            this.versionBuildStage = 1;
        }

        boolean getDeprecated() {
            if (this.deprecatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deprecatedBuildStage == 0) {
                this.deprecatedBuildStage = (byte)-1;
                this.deprecated = Meta.super.getDeprecated();
                this.deprecatedBuildStage = 1;
            }
            return this.deprecated;
        }

        void deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            this.deprecatedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.xrefsValuesBuildStage == -1) {
                attributes.add("xrefsValues");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            if (this.deprecatedBuildStage == -1) {
                attributes.add("deprecated");
            }
            return "Cannot build Meta, attribute initializers form cycle " + attributes;
        }
    }
}

