/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.AbstractGraphDocument;
import org.geneontology.obographs.core.model.Graph;
import org.geneontology.obographs.core.model.Meta;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractGraphDocument", generator="Immutables")
@Immutable
public final class GraphDocument
extends AbstractGraphDocument {
    @Nullable
    private final Object context;
    @Nullable
    private final Meta meta;
    private final ImmutableList<Graph> graphs;

    private GraphDocument(@Nullable Object context, @Nullable Meta meta, ImmutableList<Graph> graphs) {
        this.context = context;
        this.meta = meta;
        this.graphs = graphs;
    }

    @Override
    @JsonProperty(value="@context")
    @Nullable
    public Object getContext() {
        return this.context;
    }

    @Override
    @JsonProperty
    @Nullable
    public Meta getMeta() {
        return this.meta;
    }

    @JsonProperty
    public ImmutableList<Graph> getGraphs() {
        return this.graphs;
    }

    public final GraphDocument withContext(@Nullable Object value) {
        if (this.context == value) {
            return this;
        }
        return new GraphDocument(value, this.meta, this.graphs);
    }

    public final GraphDocument withMeta(@Nullable Meta value) {
        if (this.meta == value) {
            return this;
        }
        return new GraphDocument(this.context, value, this.graphs);
    }

    public final GraphDocument withGraphs(Graph ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new GraphDocument(this.context, this.meta, (ImmutableList<Graph>)newValue);
    }

    public final GraphDocument withGraphs(Iterable<? extends Graph> elements) {
        if (this.graphs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new GraphDocument(this.context, this.meta, (ImmutableList<Graph>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GraphDocument && this.equalTo((GraphDocument)another);
    }

    private boolean equalTo(GraphDocument another) {
        return Objects.equals(this.context, another.context) && Objects.equals(this.meta, another.meta) && this.graphs.equals(another.graphs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.context);
        h += (h << 5) + Objects.hashCode(this.meta);
        h += (h << 5) + this.graphs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GraphDocument").omitNullValues().add("context", this.context).add("meta", (Object)this.meta).add("graphs", this.graphs).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GraphDocument fromJson(Json json) {
        Builder builder = new Builder();
        if (json.context != null) {
            builder.context(json.context);
        }
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        if (json.graphs != null) {
            builder.addAllGraphs(json.graphs);
        }
        return builder.build();
    }

    public static GraphDocument copyOf(AbstractGraphDocument instance) {
        if (instance instanceof GraphDocument) {
            return (GraphDocument)instance;
        }
        return new Builder().from(instance).build();
    }

    @JsonPropertyOrder(value={"context", "meta", "graphs"})
    @Generated(from="AbstractGraphDocument", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Object context;
        @Nullable
        private Meta meta;
        private ImmutableList.Builder<Graph> graphs = ImmutableList.builder();

        @CanIgnoreReturnValue
        public final Builder from(AbstractGraphDocument instance) {
            Meta metaValue;
            Objects.requireNonNull(instance, "instance");
            Object contextValue = instance.getContext();
            if (contextValue != null) {
                this.context(contextValue);
            }
            if ((metaValue = instance.getMeta()) != null) {
                this.meta(metaValue);
            }
            this.addAllGraphs(instance.getGraphs());
            return this;
        }

        @JsonProperty(value="@context")
        @CanIgnoreReturnValue
        public final Builder context(@Nullable Object context) {
            this.context = context;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder meta(@Nullable Meta meta) {
            this.meta = meta;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGraph(Graph element) {
            this.graphs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGraphs(Graph ... elements) {
            this.graphs.add((Object[])elements);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder graphs(Iterable<? extends Graph> elements) {
            this.graphs = ImmutableList.builder();
            return this.addAllGraphs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGraphs(Iterable<? extends Graph> elements) {
            this.graphs.addAll(elements);
            return this;
        }

        public GraphDocument build() {
            return new GraphDocument(this.context, this.meta, (ImmutableList<Graph>)this.graphs.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractGraphDocument", generator="Immutables")
    static final class Json
    extends AbstractGraphDocument {
        @Nullable
        Object context;
        @Nullable
        Meta meta;
        @Nullable
        List<Graph> graphs = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="@context")
        public void setContext(@Nullable Object context) {
            this.context = context;
        }

        @JsonProperty
        public void setMeta(@Nullable Meta meta) {
            this.meta = meta;
        }

        @JsonProperty
        public void setGraphs(List<Graph> graphs) {
            this.graphs = graphs;
        }

        @Override
        public Object getContext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Meta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Graph> getGraphs() {
            throw new UnsupportedOperationException();
        }
    }
}

