/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.AbstractGraph;
import org.geneontology.obographs.core.model.Edge;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.Node;
import org.geneontology.obographs.core.model.axiom.DomainRangeAxiom;
import org.geneontology.obographs.core.model.axiom.EquivalentNodesSet;
import org.geneontology.obographs.core.model.axiom.LogicalDefinitionAxiom;
import org.geneontology.obographs.core.model.axiom.PropertyChainAxiom;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractGraph", generator="Immutables")
@Immutable
public final class Graph
extends AbstractGraph {
    private final String id;
    private final String lbl;
    @Nullable
    private final Meta meta;
    private final ImmutableList<Node> nodes;
    private final ImmutableList<Edge> edges;
    private final ImmutableList<EquivalentNodesSet> equivalentNodesSets;
    private final ImmutableList<LogicalDefinitionAxiom> logicalDefinitionAxioms;
    private final ImmutableList<DomainRangeAxiom> domainRangeAxioms;
    private final ImmutableList<PropertyChainAxiom> propertyChainAxioms;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private Graph(Builder builder) {
        this.meta = builder.meta;
        this.nodes = builder.nodes.build();
        this.edges = builder.edges.build();
        this.equivalentNodesSets = builder.equivalentNodesSets.build();
        this.logicalDefinitionAxioms = builder.logicalDefinitionAxioms.build();
        this.domainRangeAxioms = builder.domainRangeAxioms.build();
        this.propertyChainAxioms = builder.propertyChainAxioms.build();
        if (builder.id != null) {
            this.initShim.id(builder.id);
        }
        if (builder.lbl != null) {
            this.initShim.lbl(builder.lbl);
        }
        this.id = this.initShim.getId();
        this.lbl = this.initShim.getLbl();
        this.initShim = null;
    }

    private Graph(String id, String lbl, @Nullable Meta meta, ImmutableList<Node> nodes, ImmutableList<Edge> edges, ImmutableList<EquivalentNodesSet> equivalentNodesSets, ImmutableList<LogicalDefinitionAxiom> logicalDefinitionAxioms, ImmutableList<DomainRangeAxiom> domainRangeAxioms, ImmutableList<PropertyChainAxiom> propertyChainAxioms) {
        this.id = id;
        this.lbl = lbl;
        this.meta = meta;
        this.nodes = nodes;
        this.edges = edges;
        this.equivalentNodesSets = equivalentNodesSets;
        this.logicalDefinitionAxioms = logicalDefinitionAxioms;
        this.domainRangeAxioms = domainRangeAxioms;
        this.propertyChainAxioms = propertyChainAxioms;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public String getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    @Override
    @JsonProperty
    public String getLbl() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLbl() : this.lbl;
    }

    @Override
    @JsonProperty
    @Nullable
    public Meta getMeta() {
        return this.meta;
    }

    @JsonProperty
    public ImmutableList<Node> getNodes() {
        return this.nodes;
    }

    @JsonProperty
    public ImmutableList<Edge> getEdges() {
        return this.edges;
    }

    @JsonProperty
    public ImmutableList<EquivalentNodesSet> getEquivalentNodesSets() {
        return this.equivalentNodesSets;
    }

    @JsonProperty
    public ImmutableList<LogicalDefinitionAxiom> getLogicalDefinitionAxioms() {
        return this.logicalDefinitionAxioms;
    }

    @JsonProperty
    public ImmutableList<DomainRangeAxiom> getDomainRangeAxioms() {
        return this.domainRangeAxioms;
    }

    @JsonProperty
    public ImmutableList<PropertyChainAxiom> getPropertyChainAxioms() {
        return this.propertyChainAxioms;
    }

    public final Graph withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new Graph(newValue, this.lbl, this.meta, this.nodes, this.edges, this.equivalentNodesSets, this.logicalDefinitionAxioms, this.domainRangeAxioms, this.propertyChainAxioms);
    }

    public final Graph withLbl(String value) {
        String newValue = Objects.requireNonNull(value, "lbl");
        if (this.lbl.equals(newValue)) {
            return this;
        }
        return new Graph(this.id, newValue, this.meta, this.nodes, this.edges, this.equivalentNodesSets, this.logicalDefinitionAxioms, this.domainRangeAxioms, this.propertyChainAxioms);
    }

    public final Graph withMeta(@Nullable Meta value) {
        if (this.meta == value) {
            return this;
        }
        return new Graph(this.id, this.lbl, value, this.nodes, this.edges, this.equivalentNodesSets, this.logicalDefinitionAxioms, this.domainRangeAxioms, this.propertyChainAxioms);
    }

    public final Graph withNodes(Node ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Graph(this.id, this.lbl, this.meta, (ImmutableList<Node>)newValue, this.edges, this.equivalentNodesSets, this.logicalDefinitionAxioms, this.domainRangeAxioms, this.propertyChainAxioms);
    }

    public final Graph withNodes(Iterable<? extends Node> elements) {
        if (this.nodes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Graph(this.id, this.lbl, this.meta, (ImmutableList<Node>)newValue, this.edges, this.equivalentNodesSets, this.logicalDefinitionAxioms, this.domainRangeAxioms, this.propertyChainAxioms);
    }

    public final Graph withEdges(Edge ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Graph(this.id, this.lbl, this.meta, this.nodes, (ImmutableList<Edge>)newValue, this.equivalentNodesSets, this.logicalDefinitionAxioms, this.domainRangeAxioms, this.propertyChainAxioms);
    }

    public final Graph withEdges(Iterable<? extends Edge> elements) {
        if (this.edges == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Graph(this.id, this.lbl, this.meta, this.nodes, (ImmutableList<Edge>)newValue, this.equivalentNodesSets, this.logicalDefinitionAxioms, this.domainRangeAxioms, this.propertyChainAxioms);
    }

    public final Graph withEquivalentNodesSets(EquivalentNodesSet ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Graph(this.id, this.lbl, this.meta, this.nodes, this.edges, (ImmutableList<EquivalentNodesSet>)newValue, this.logicalDefinitionAxioms, this.domainRangeAxioms, this.propertyChainAxioms);
    }

    public final Graph withEquivalentNodesSets(Iterable<? extends EquivalentNodesSet> elements) {
        if (this.equivalentNodesSets == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Graph(this.id, this.lbl, this.meta, this.nodes, this.edges, (ImmutableList<EquivalentNodesSet>)newValue, this.logicalDefinitionAxioms, this.domainRangeAxioms, this.propertyChainAxioms);
    }

    public final Graph withLogicalDefinitionAxioms(LogicalDefinitionAxiom ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Graph(this.id, this.lbl, this.meta, this.nodes, this.edges, this.equivalentNodesSets, (ImmutableList<LogicalDefinitionAxiom>)newValue, this.domainRangeAxioms, this.propertyChainAxioms);
    }

    public final Graph withLogicalDefinitionAxioms(Iterable<? extends LogicalDefinitionAxiom> elements) {
        if (this.logicalDefinitionAxioms == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Graph(this.id, this.lbl, this.meta, this.nodes, this.edges, this.equivalentNodesSets, (ImmutableList<LogicalDefinitionAxiom>)newValue, this.domainRangeAxioms, this.propertyChainAxioms);
    }

    public final Graph withDomainRangeAxioms(DomainRangeAxiom ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Graph(this.id, this.lbl, this.meta, this.nodes, this.edges, this.equivalentNodesSets, this.logicalDefinitionAxioms, (ImmutableList<DomainRangeAxiom>)newValue, this.propertyChainAxioms);
    }

    public final Graph withDomainRangeAxioms(Iterable<? extends DomainRangeAxiom> elements) {
        if (this.domainRangeAxioms == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Graph(this.id, this.lbl, this.meta, this.nodes, this.edges, this.equivalentNodesSets, this.logicalDefinitionAxioms, (ImmutableList<DomainRangeAxiom>)newValue, this.propertyChainAxioms);
    }

    public final Graph withPropertyChainAxioms(PropertyChainAxiom ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Graph(this.id, this.lbl, this.meta, this.nodes, this.edges, this.equivalentNodesSets, this.logicalDefinitionAxioms, this.domainRangeAxioms, (ImmutableList<PropertyChainAxiom>)newValue);
    }

    public final Graph withPropertyChainAxioms(Iterable<? extends PropertyChainAxiom> elements) {
        if (this.propertyChainAxioms == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Graph(this.id, this.lbl, this.meta, this.nodes, this.edges, this.equivalentNodesSets, this.logicalDefinitionAxioms, this.domainRangeAxioms, (ImmutableList<PropertyChainAxiom>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Graph && this.equalTo((Graph)another);
    }

    private boolean equalTo(Graph another) {
        return this.id.equals(another.id) && this.lbl.equals(another.lbl) && Objects.equals(this.meta, another.meta) && this.nodes.equals(another.nodes) && this.edges.equals(another.edges) && this.equivalentNodesSets.equals(another.equivalentNodesSets) && this.logicalDefinitionAxioms.equals(another.logicalDefinitionAxioms) && this.domainRangeAxioms.equals(another.domainRangeAxioms) && this.propertyChainAxioms.equals(another.propertyChainAxioms);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.lbl.hashCode();
        h += (h << 5) + Objects.hashCode(this.meta);
        h += (h << 5) + this.nodes.hashCode();
        h += (h << 5) + this.edges.hashCode();
        h += (h << 5) + this.equivalentNodesSets.hashCode();
        h += (h << 5) + this.logicalDefinitionAxioms.hashCode();
        h += (h << 5) + this.domainRangeAxioms.hashCode();
        h += (h << 5) + this.propertyChainAxioms.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Graph").omitNullValues().add("id", (Object)this.id).add("lbl", (Object)this.lbl).add("meta", (Object)this.meta).add("nodes", this.nodes).add("edges", this.edges).add("equivalentNodesSets", this.equivalentNodesSets).add("logicalDefinitionAxioms", this.logicalDefinitionAxioms).add("domainRangeAxioms", this.domainRangeAxioms).add("propertyChainAxioms", this.propertyChainAxioms).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Graph fromJson(Json json) {
        Builder builder = new Builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.lbl != null) {
            builder.lbl(json.lbl);
        }
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        if (json.nodes != null) {
            builder.addAllNodes(json.nodes);
        }
        if (json.edges != null) {
            builder.addAllEdges(json.edges);
        }
        if (json.equivalentNodesSets != null) {
            builder.addAllEquivalentNodesSets(json.equivalentNodesSets);
        }
        if (json.logicalDefinitionAxioms != null) {
            builder.addAllLogicalDefinitionAxioms(json.logicalDefinitionAxioms);
        }
        if (json.domainRangeAxioms != null) {
            builder.addAllDomainRangeAxioms(json.domainRangeAxioms);
        }
        if (json.propertyChainAxioms != null) {
            builder.addAllPropertyChainAxioms(json.propertyChainAxioms);
        }
        return builder.build();
    }

    public static Graph copyOf(AbstractGraph instance) {
        if (instance instanceof Graph) {
            return (Graph)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="AbstractGraph", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String lbl;
        @Nullable
        private Meta meta;
        private ImmutableList.Builder<Node> nodes = ImmutableList.builder();
        private ImmutableList.Builder<Edge> edges = ImmutableList.builder();
        private ImmutableList.Builder<EquivalentNodesSet> equivalentNodesSets = ImmutableList.builder();
        private ImmutableList.Builder<LogicalDefinitionAxiom> logicalDefinitionAxioms = ImmutableList.builder();
        private ImmutableList.Builder<DomainRangeAxiom> domainRangeAxioms = ImmutableList.builder();
        private ImmutableList.Builder<PropertyChainAxiom> propertyChainAxioms = ImmutableList.builder();

        @CanIgnoreReturnValue
        public final Builder from(AbstractGraph instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.lbl(instance.getLbl());
            Meta metaValue = instance.getMeta();
            if (metaValue != null) {
                this.meta(metaValue);
            }
            this.addAllNodes(instance.getNodes());
            this.addAllEdges(instance.getEdges());
            this.addAllEquivalentNodesSets(instance.getEquivalentNodesSets());
            this.addAllLogicalDefinitionAxioms(instance.getLogicalDefinitionAxioms());
            this.addAllDomainRangeAxioms(instance.getDomainRangeAxioms());
            this.addAllPropertyChainAxioms(instance.getPropertyChainAxioms());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lbl(String lbl) {
            this.lbl = Objects.requireNonNull(lbl, "lbl");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder meta(@Nullable Meta meta) {
            this.meta = meta;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNode(Node element) {
            this.nodes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodes(Node ... elements) {
            this.nodes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodes(Iterable<? extends Node> elements) {
            this.nodes = ImmutableList.builder();
            return this.addAllNodes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNodes(Iterable<? extends Node> elements) {
            this.nodes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEdge(Edge element) {
            this.edges.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEdges(Edge ... elements) {
            this.edges.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder edges(Iterable<? extends Edge> elements) {
            this.edges = ImmutableList.builder();
            return this.addAllEdges(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEdges(Iterable<? extends Edge> elements) {
            this.edges.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEquivalentNodesSet(EquivalentNodesSet element) {
            this.equivalentNodesSets.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEquivalentNodesSets(EquivalentNodesSet ... elements) {
            this.equivalentNodesSets.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder equivalentNodesSets(Iterable<? extends EquivalentNodesSet> elements) {
            this.equivalentNodesSets = ImmutableList.builder();
            return this.addAllEquivalentNodesSets(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEquivalentNodesSets(Iterable<? extends EquivalentNodesSet> elements) {
            this.equivalentNodesSets.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLogicalDefinitionAxiom(LogicalDefinitionAxiom element) {
            this.logicalDefinitionAxioms.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLogicalDefinitionAxioms(LogicalDefinitionAxiom ... elements) {
            this.logicalDefinitionAxioms.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logicalDefinitionAxioms(Iterable<? extends LogicalDefinitionAxiom> elements) {
            this.logicalDefinitionAxioms = ImmutableList.builder();
            return this.addAllLogicalDefinitionAxioms(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLogicalDefinitionAxioms(Iterable<? extends LogicalDefinitionAxiom> elements) {
            this.logicalDefinitionAxioms.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDomainRangeAxiom(DomainRangeAxiom element) {
            this.domainRangeAxioms.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDomainRangeAxioms(DomainRangeAxiom ... elements) {
            this.domainRangeAxioms.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder domainRangeAxioms(Iterable<? extends DomainRangeAxiom> elements) {
            this.domainRangeAxioms = ImmutableList.builder();
            return this.addAllDomainRangeAxioms(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDomainRangeAxioms(Iterable<? extends DomainRangeAxiom> elements) {
            this.domainRangeAxioms.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPropertyChainAxiom(PropertyChainAxiom element) {
            this.propertyChainAxioms.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPropertyChainAxioms(PropertyChainAxiom ... elements) {
            this.propertyChainAxioms.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder propertyChainAxioms(Iterable<? extends PropertyChainAxiom> elements) {
            this.propertyChainAxioms = ImmutableList.builder();
            return this.addAllPropertyChainAxioms(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPropertyChainAxioms(Iterable<? extends PropertyChainAxiom> elements) {
            this.propertyChainAxioms.addAll(elements);
            return this;
        }

        public Graph build() {
            return new Graph(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractGraph", generator="Immutables")
    static final class Json
    extends AbstractGraph {
        @Nullable
        String id;
        @Nullable
        String lbl;
        @Nullable
        Meta meta;
        @Nullable
        List<Node> nodes = ImmutableList.of();
        @Nullable
        List<Edge> edges = ImmutableList.of();
        @Nullable
        List<EquivalentNodesSet> equivalentNodesSets = ImmutableList.of();
        @Nullable
        List<LogicalDefinitionAxiom> logicalDefinitionAxioms = ImmutableList.of();
        @Nullable
        List<DomainRangeAxiom> domainRangeAxioms = ImmutableList.of();
        @Nullable
        List<PropertyChainAxiom> propertyChainAxioms = ImmutableList.of();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setLbl(String lbl) {
            this.lbl = lbl;
        }

        @JsonProperty
        public void setMeta(@Nullable Meta meta) {
            this.meta = meta;
        }

        @JsonProperty
        public void setNodes(List<Node> nodes) {
            this.nodes = nodes;
        }

        @JsonProperty
        public void setEdges(List<Edge> edges) {
            this.edges = edges;
        }

        @JsonProperty
        public void setEquivalentNodesSets(List<EquivalentNodesSet> equivalentNodesSets) {
            this.equivalentNodesSets = equivalentNodesSets;
        }

        @JsonProperty
        public void setLogicalDefinitionAxioms(List<LogicalDefinitionAxiom> logicalDefinitionAxioms) {
            this.logicalDefinitionAxioms = logicalDefinitionAxioms;
        }

        @JsonProperty
        public void setDomainRangeAxioms(List<DomainRangeAxiom> domainRangeAxioms) {
            this.domainRangeAxioms = domainRangeAxioms;
        }

        @JsonProperty
        public void setPropertyChainAxioms(List<PropertyChainAxiom> propertyChainAxioms) {
            this.propertyChainAxioms = propertyChainAxioms;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLbl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Meta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Node> getNodes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Edge> getEdges() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<EquivalentNodesSet> getEquivalentNodesSets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<LogicalDefinitionAxiom> getLogicalDefinitionAxioms() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DomainRangeAxiom> getDomainRangeAxioms() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PropertyChainAxiom> getPropertyChainAxioms() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AbstractGraph", generator="Immutables")
    private final class InitShim {
        private byte idBuildStage = 0;
        private String id;
        private byte lblBuildStage = 0;
        private String lbl;

        private InitShim() {
        }

        String getId() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = Objects.requireNonNull(Graph.super.getId(), "id");
                this.idBuildStage = 1;
            }
            return this.id;
        }

        void id(String id) {
            this.id = id;
            this.idBuildStage = 1;
        }

        String getLbl() {
            if (this.lblBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lblBuildStage == 0) {
                this.lblBuildStage = (byte)-1;
                this.lbl = Objects.requireNonNull(Graph.super.getLbl(), "lbl");
                this.lblBuildStage = 1;
            }
            return this.lbl;
        }

        void lbl(String lbl) {
            this.lbl = lbl;
            this.lblBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            if (this.lblBuildStage == -1) {
                attributes.add("lbl");
            }
            return "Cannot build Graph, attribute initializers form cycle " + attributes;
        }
    }
}

