/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.geneontology.obographs.core.model.AbstractEdge;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.NodeOrEdge;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractEdge", generator="Immutables")
@Immutable
public final class Edge
extends AbstractEdge {
    @Nullable
    private final Meta meta;
    private final String sub;
    private final String pred;
    private final String obj;

    private Edge(@Nullable Meta meta, String sub, String pred, String obj) {
        this.meta = meta;
        this.sub = sub;
        this.pred = pred;
        this.obj = obj;
    }

    @Override
    @JsonProperty
    @Nullable
    public Meta getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty
    public String getSub() {
        return this.sub;
    }

    @Override
    @JsonProperty
    public String getPred() {
        return this.pred;
    }

    @Override
    @JsonProperty
    public String getObj() {
        return this.obj;
    }

    public final Edge withMeta(@Nullable Meta value) {
        if (this.meta == value) {
            return this;
        }
        return new Edge(value, this.sub, this.pred, this.obj);
    }

    public final Edge withSub(String value) {
        String newValue = Objects.requireNonNull(value, "sub");
        if (this.sub.equals(newValue)) {
            return this;
        }
        return new Edge(this.meta, newValue, this.pred, this.obj);
    }

    public final Edge withPred(String value) {
        String newValue = Objects.requireNonNull(value, "pred");
        if (this.pred.equals(newValue)) {
            return this;
        }
        return new Edge(this.meta, this.sub, newValue, this.obj);
    }

    public final Edge withObj(String value) {
        String newValue = Objects.requireNonNull(value, "obj");
        if (this.obj.equals(newValue)) {
            return this;
        }
        return new Edge(this.meta, this.sub, this.pred, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Edge && this.equalTo((Edge)another);
    }

    private boolean equalTo(Edge another) {
        return Objects.equals(this.meta, another.meta) && this.sub.equals(another.sub) && this.pred.equals(another.pred) && this.obj.equals(another.obj);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.meta);
        h += (h << 5) + this.sub.hashCode();
        h += (h << 5) + this.pred.hashCode();
        h += (h << 5) + this.obj.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Edge").omitNullValues().add("meta", (Object)this.meta).add("sub", (Object)this.sub).add("pred", (Object)this.pred).add("obj", (Object)this.obj).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Edge fromJson(Json json) {
        Builder builder = new Builder();
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        if (json.sub != null) {
            builder.sub(json.sub);
        }
        if (json.pred != null) {
            builder.pred(json.pred);
        }
        if (json.obj != null) {
            builder.obj(json.obj);
        }
        return builder.build();
    }

    public static Edge copyOf(AbstractEdge instance) {
        if (instance instanceof Edge) {
            return (Edge)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="AbstractEdge", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SUB = 1L;
        private static final long INIT_BIT_PRED = 2L;
        private static final long INIT_BIT_OBJ = 4L;
        private long initBits = 7L;
        @Nullable
        private Meta meta;
        @Nullable
        private String sub;
        @Nullable
        private String pred;
        @Nullable
        private String obj;

        @CanIgnoreReturnValue
        public final Builder from(NodeOrEdge instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AbstractEdge instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            NodeOrEdge instance;
            Meta metaValue;
            if (object instanceof NodeOrEdge && (metaValue = (instance = (NodeOrEdge)object).getMeta()) != null) {
                this.meta(metaValue);
            }
            if (object instanceof AbstractEdge) {
                instance = (AbstractEdge)object;
                this.sub(((AbstractEdge)instance).getSub());
                this.pred(((AbstractEdge)instance).getPred());
                this.obj(((AbstractEdge)instance).getObj());
            }
        }

        @CanIgnoreReturnValue
        public final Builder meta(@Nullable Meta meta) {
            this.meta = meta;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sub(String sub) {
            this.sub = Objects.requireNonNull(sub, "sub");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pred(String pred) {
            this.pred = Objects.requireNonNull(pred, "pred");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder obj(String obj) {
            this.obj = Objects.requireNonNull(obj, "obj");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Edge build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Edge(this.meta, this.sub, this.pred, this.obj);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sub");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pred");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("obj");
            }
            return "Cannot build Edge, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractEdge", generator="Immutables")
    static final class Json
    extends AbstractEdge {
        @Nullable
        Meta meta;
        @Nullable
        String sub;
        @Nullable
        String pred;
        @Nullable
        String obj;

        Json() {
        }

        @JsonProperty
        public void setMeta(@Nullable Meta meta) {
            this.meta = meta;
        }

        @JsonProperty
        public void setSub(String sub) {
            this.sub = sub;
        }

        @JsonProperty
        public void setPred(String pred) {
            this.pred = pred;
        }

        @JsonProperty
        public void setObj(String obj) {
            this.obj = obj;
        }

        @Override
        public Meta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSub() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPred() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getObj() {
            throw new UnsupportedOperationException();
        }
    }
}

