/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.geneontology.obographs.core.model.meta.BasicPropertyValue;
import org.geneontology.obographs.core.model.meta.DefinitionPropertyValue;
import org.geneontology.obographs.core.model.meta.SynonymPropertyValue;
import org.geneontology.obographs.core.model.meta.XrefPropertyValue;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"definition", "comments", "subsets", "synonyms", "xrefs", "basicPropertyValues", "version", "deprecated"})
@Value.Immutable
public abstract class AbstractMeta {
    @JsonProperty
    @Nullable
    public abstract DefinitionPropertyValue getDefinition();

    @JsonProperty
    public abstract List<String> getComments();

    @JsonProperty
    public abstract List<String> getSubsets();

    @JsonProperty
    public abstract List<SynonymPropertyValue> getSynonyms();

    @JsonProperty
    public abstract List<XrefPropertyValue> getXrefs();

    @JsonIgnore
    @Value.Default
    public List<String> getXrefsValues() {
        return this.getXrefs().stream().map(XrefPropertyValue::getVal).collect(Collectors.toList());
    }

    @JsonProperty
    public abstract List<BasicPropertyValue> getBasicPropertyValues();

    @JsonProperty
    @Value.Default
    public String getVersion() {
        return "";
    }

    @JsonProperty
    @Value.Default
    public boolean getDeprecated() {
        return false;
    }
}

