/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.core.io;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.geneontology.obographs.core.model.GraphDocument;

public class OgJsonReader {
    private OgJsonReader() {
    }

    public static GraphDocument readFile(String fileName) throws IOException {
        return OgJsonReader.readFile(new File(fileName));
    }

    public static GraphDocument readFile(File file) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new GuavaModule());
        return (GraphDocument)objectMapper.readValue(file, GraphDocument.class);
    }

    public static GraphDocument readInputStream(InputStream stream) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new GuavaModule());
        return (GraphDocument)objectMapper.readValue(stream, GraphDocument.class);
    }

    public static GraphDocument read(Reader reader) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new GuavaModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        return (GraphDocument)objectMapper.readValue(reader, GraphDocument.class);
    }
}

