/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.test;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.gedcomx.test.Recipe;
import org.gedcomx.test.Snippet;
import org.junit.After;

public class RecipeTest {
    static final ThreadLocal<Recipe> CURRENT_RECIPE = new ThreadLocal();
    static final ThreadLocal<List<Recipe>> RECIPES = new ThreadLocal<List<Recipe>>(){

        @Override
        protected List<Recipe> initialValue() {
            return new ArrayList<Recipe>();
        }
    };
    static final String DEFAULT_OUTPUT_DIR = "target" + File.separator + "recipes";

    protected Recipe createRecipe(String title) {
        if (title == null || title.isEmpty()) {
            throw new IllegalArgumentException("title must not be null or empty");
        }
        Recipe recipe = new Recipe();
        recipe.setTitle(title);
        this.setCurrentRecipe(recipe);
        return recipe;
    }

    protected void addSnippet(Snippet snippet) {
        Recipe currentRecipe = CURRENT_RECIPE.get();
        if (currentRecipe == null) {
            throw new IllegalStateException("No recipe has been initialized to accommodate the snippet.");
        }
        currentRecipe.addSnippet(snippet);
    }

    private void setCurrentRecipe(Recipe recipe) {
        Recipe old = CURRENT_RECIPE.get();
        if (old != null) {
            RECIPES.get().add(old);
        }
        CURRENT_RECIPE.set(recipe);
    }

    @After
    public void tearDown() throws Exception {
        this.endRecipe();
        String recipesDir = System.getProperty("recipes.dir");
        if (recipesDir == null) {
            recipesDir = DEFAULT_OUTPUT_DIR;
        }
        File directory = new File(recipesDir);
        directory.mkdirs();
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{Recipe.class}).createMarshaller();
        boolean ensureUniqueRecipes = !"false".equals(System.getProperty("ensure.unique.recipes")) && !this.isRunningFromIntelliJ();
        for (Recipe recipe : RECIPES.get()) {
            File file = new File(recipesDir, this.generateFilename(recipe.getTitle()));
            if (ensureUniqueRecipes && file.exists()) {
                RECIPES.get().clear();
                throw new Exception("File is not unique, please ensure the recipe title is unique!\n" + recipe.getTitle());
            }
            FileOutputStream os = new FileOutputStream(file);
            marshaller.marshal((Object)recipe, (OutputStream)os);
            ((OutputStream)os).close();
        }
        RECIPES.get().clear();
    }

    private boolean isRunningFromIntelliJ() {
        try {
            Class.forName("com.intellij.rt.execution.application.AppMain", false, this.getClass().getClassLoader());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private String generateFilename(String title) {
        StringBuilder filename = new StringBuilder(title.replace(' ', '-'));
        filename.append(".recipe.xml");
        return filename.toString();
    }

    protected void endRecipe() {
        this.setCurrentRecipe(null);
    }
}

