/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.fuin.esmp.AbstractEventStoreMojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="post-start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresProject=false)
public final class EventStorePostStartMojo
extends AbstractEventStoreMojo {
    private static final Logger LOG = LoggerFactory.getLogger(EventStorePostStartMojo.class);
    @Parameter(name="post-start-command")
    private String postStartCommand;
    private List<String> messages;

    @Override
    protected final void executeGoal() throws MojoExecutionException {
        if (this.postStartCommand == null) {
            throw new MojoExecutionException("postStartCommand not set");
        }
        LOG.info("postStartCommand={}", (Object)this.postStartCommand);
        CommandLine cmdLine = new CommandLine(this.postStartCommand);
        DefaultExecutor executor = new DefaultExecutor();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PumpStreamHandler psh = new PumpStreamHandler((OutputStream)bos);
            executor.setStreamHandler((ExecuteStreamHandler)psh);
            executor.setWorkingDirectory(this.getEventStoreDir());
            int exitCode = executor.execute(cmdLine);
            this.messages = this.asList(bos.toString());
            if (exitCode == 0) {
                LOG.info("Post-start command executed successfully");
                this.logDebug(this.messages);
            } else {
                LOG.error("Post-start command failed with exit code: {}", (Object)exitCode);
                this.logError(this.messages);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error executing the command line: " + cmdLine, (Exception)ex);
        }
    }

    public final String getPostStartCommand() {
        return this.postStartCommand;
    }

    public final void setPostStartCommand(String postStartCommand) {
        this.postStartCommand = postStartCommand;
    }

    public final List<String> getMessages() {
        return this.messages;
    }
}

