/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.fuin.esmp.AbstractEventStoreMojo;
import org.fuin.esmp.FileMode;
import org.fuin.utils4j.Utils4J;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="download", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresProject=true)
public final class EventStoreDownloadMojo
extends AbstractEventStoreMojo {
    private static final Logger LOG = LoggerFactory.getLogger(EventStoreDownloadMojo.class);
    private static final int MB = 0x100000;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    @Override
    protected final void executeGoal() throws MojoExecutionException {
        this.assertParametersNotNull();
        if (this.getEventStoreDir().exists()) {
            LOG.info("Events store directory already exists: " + this.getEventStoreDir());
        } else {
            File archive = this.downloadEventStoreArchive();
            this.unpack(archive);
        }
    }

    private void assertParametersNotNull() throws MojoExecutionException {
        LOG.info("mavenProject={}", (Object)this.mavenProject);
        LOG.info("mavenSession={}", (Object)this.mavenSession);
        LOG.info("pluginManager={}", (Object)this.pluginManager);
        if (this.mavenProject == null) {
            throw new MojoExecutionException("mavenProject==null");
        }
        if (this.mavenSession == null) {
            throw new MojoExecutionException("mavenSession==null");
        }
        if (this.pluginManager == null) {
            throw new MojoExecutionException("pluginManager==null");
        }
    }

    public final File getDownloadFile() throws MojoExecutionException {
        String name = FilenameUtils.getName((String)this.getDownloadUrl());
        return new File(this.getEventStoreDir().getParentFile(), name);
    }

    private URL createDownloadURL() throws MojoExecutionException {
        try {
            return new URL(this.getDownloadUrl());
        }
        catch (MalformedURLException ex) {
            throw new MojoExecutionException("Failed to construct download URL for the event store", (Exception)ex);
        }
    }

    private File downloadEventStoreArchive() throws MojoExecutionException {
        URL url = this.createDownloadURL();
        try {
            File file = this.getDownloadFile();
            if (file.exists()) {
                LOG.info("Archive already exists in target directory: " + file);
            } else {
                LOG.info("Dowloading archive: " + url);
                File tmpFile = new File(Utils4J.getTempDir(), file.getName());
                if (!tmpFile.exists()) {
                    this.download(url, tmpFile);
                    LOG.info("Archive downloaded to: " + tmpFile);
                }
                FileUtils.copyFile((File)tmpFile, (File)file);
                LOG.info("Archive copied from '" + tmpFile + "' to:" + file);
            }
            return file;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error downloading event store archive: " + url, (Exception)ex);
        }
    }

    private void download(URL url, File file) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.googlecode.maven-download-plugin"), (String)MojoExecutor.artifactId((String)"download-maven-plugin"), (String)MojoExecutor.version((String)"1.3.0")), (String)MojoExecutor.goal((String)"wget"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"url"), (String)url.toString()), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)file.getParent()), MojoExecutor.element((String)MojoExecutor.name((String)"outputFileName"), (String)file.getName()), MojoExecutor.element((String)MojoExecutor.name((String)"skipCache"), (String)"true")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private void unpack(File archive) throws MojoExecutionException {
        LOG.info("Unpack event store to target directory: " + this.getEventStoreDir());
        if (archive.getName().endsWith(".zip")) {
            File destDir = this.getEventStoreDir();
            EventStoreDownloadMojo.unzip(archive, destDir);
        } else if (archive.getName().endsWith(".tar.gz")) {
            File destDir = this.getEventStoreDir().getParentFile();
            EventStoreDownloadMojo.unTarGz(archive, destDir);
        } else {
            throw new MojoExecutionException("Cannot unpack file: " + archive.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destDir) throws MojoExecutionException {
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> enu = zip.entries();
            while (enu.hasMoreElements()) {
                ZipEntry entry = enu.nextElement();
                File file = new File(entry.getName());
                if (file.isAbsolute()) {
                    throw new IllegalArgumentException("Only relative path entries are allowed! [" + entry.getName() + "]");
                }
                if (entry.isDirectory()) {
                    File dir = new File(destDir, entry.getName());
                    EventStoreDownloadMojo.mkDirsIfNecessary(dir);
                    continue;
                }
                LOG.info("Extracting: " + entry.getName());
                File outFile = new File(destDir, entry.getName());
                EventStoreDownloadMojo.mkDirsIfNecessary(outFile.getParentFile());
                try (BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
                     BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));){
                    int len;
                    byte[] buf = new byte[4096];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error unzipping event store archive: " + zipFile, (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unTarGz(File archive, File destDir) throws MojoExecutionException {
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(archive))));){
            TarArchiveEntry entry;
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                LOG.info("Extracting: " + entry.getName());
                File file = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    EventStoreDownloadMojo.mkDirsIfNecessary(file);
                } else {
                    EventStoreDownloadMojo.mkDirsIfNecessary(file.getParentFile());
                    byte[] data = new byte[0x100000];
                    FileOutputStream fos = new FileOutputStream(file);
                    try (BufferedOutputStream dest = new BufferedOutputStream(fos, 0x100000);){
                        int count;
                        while ((count = tarIn.read(data, 0, 0x100000)) != -1) {
                            dest.write(data, 0, count);
                        }
                    }
                    entry.getMode();
                }
                EventStoreDownloadMojo.applyFileMode(file, new FileMode(entry.getMode()));
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error uncompressing event store archive: " + archive, (Exception)ex);
        }
    }

    private static void mkDirsIfNecessary(File dir) throws IOException {
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new IOException("Error creating directory '" + dir + "'!");
        }
    }

    private static void applyFileMode(File file, FileMode fileMode) throws MojoExecutionException {
        block4: {
            if (OS.isFamilyUnix() || OS.isFamilyMac()) {
                String smode = fileMode.toChmodStringFull();
                CommandLine cmdLine = new CommandLine("chmod");
                cmdLine.addArgument(smode);
                cmdLine.addArgument(file.getAbsolutePath(), false);
                DefaultExecutor executor = new DefaultExecutor();
                try {
                    int result = executor.execute(cmdLine);
                    if (result != 0) {
                        throw new MojoExecutionException("Error # " + result + " while trying to set mode \"" + smode + "\" for file: " + file.getAbsolutePath());
                    }
                    break block4;
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error while trying to set mode \"" + smode + "\" for file: " + file.getAbsolutePath(), (Exception)ex);
                }
            }
            file.setReadable(fileMode.isUr() || fileMode.isGr() || fileMode.isOr());
            file.setWritable(fileMode.isUw() || fileMode.isGw() || fileMode.isOw());
            file.setExecutable(fileMode.isUx() || fileMode.isGx() || fileMode.isOx());
        }
    }
}

