/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Random;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="certificate", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresProject=false)
public final class EventStoreCertificateMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(EventStoreCertificateMojo.class);
    @Parameter(name="certificate-file")
    private String certificateFile;

    public final void execute() throws MojoExecutionException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        LOG.info("certificateFile={}", (Object)this.certificateFile);
        if (this.certificateFile == null || this.certificateFile.trim().length() == 0) {
            LOG.info("Skipped generation: No certificate file given");
            return;
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            File file = new File(this.certificateFile);
            EventStoreCertificateMojo.createSelfSignedCertificate("test.com", file);
            LOG.info("Certificate successfully created");
        }
        catch (RuntimeException ex) {
            throw new MojoExecutionException("Error generating a self-signed X509 certificate: " + this.certificateFile, (Exception)ex);
        }
    }

    public final String getCertificateFile() {
        return this.certificateFile;
    }

    public final void setCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile;
    }

    private static X509Certificate generateCertificate(String domain, KeyPair pair) {
        try {
            X500Name issuerName;
            X500Name subjectName = issuerName = new X500Name("CN=" + domain);
            BigInteger serial = BigInteger.valueOf(new Random().nextInt());
            Date notBefore = Date.from(LocalDateTime.of(2016, 1, 1, 0, 0).toInstant(ZoneOffset.UTC));
            Date notAfter = Date.from(LocalDateTime.of(2099, 1, 1, 0, 0).toInstant(ZoneOffset.UTC));
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuerName, serial, notBefore, notAfter, subjectName, pair.getPublic());
            builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
            ASN1EncodableVector purposes = new ASN1EncodableVector();
            purposes.add((ASN1Encodable)KeyPurposeId.id_kp_serverAuth);
            builder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new DERSequence(purposes));
            return EventStoreCertificateMojo.signCertificate((X509v3CertificateBuilder)builder, pair.getPrivate());
        }
        catch (CertIOException ex) {
            throw new RuntimeException("Couldn't generate certificate", ex);
        }
    }

    private static KeyPair generateKeyPair(int keySize) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
            generator.initialize(keySize, new SecureRandom());
            return generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new RuntimeException("Couldn't generate key pair", ex);
        }
    }

    private static X509Certificate signCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey privateKey) {
        try {
            ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(privateKey);
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(signer));
        }
        catch (CertificateException | OperatorCreationException ex) {
            throw new RuntimeException("Couldn't sign certificate", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveCertificateAsP12File(String domain, X509Certificate certificate, PrivateKey key, File file) {
        try {
            char[] noPw = new char[]{};
            KeyStore p12Store = KeyStore.getInstance("PKCS12", "BC");
            p12Store.load(null, null);
            p12Store.setKeyEntry(domain, key, noPw, new X509Certificate[]{certificate});
            try (FileOutputStream fos = new FileOutputStream(file);){
                p12Store.store(fos, noPw);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException ex) {
            throw new RuntimeException("Couldn't save certificate", ex);
        }
    }

    private static void verify(X509Certificate cert) {
        try {
            cert.checkValidity(new Date());
            cert.verify(cert.getPublicKey());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException ex) {
            throw new RuntimeException("Certificate verification failed", ex);
        }
    }

    private static void createSelfSignedCertificate(String domain, File file) {
        KeyPair pair = EventStoreCertificateMojo.generateKeyPair(1024);
        X509Certificate cert = EventStoreCertificateMojo.generateCertificate(domain, pair);
        EventStoreCertificateMojo.verify(cert);
        EventStoreCertificateMojo.saveCertificateAsP12File(domain, cert, pair.getPrivate(), file);
    }
}

