/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.FileUtils;
import org.fuin.esmp.DownloadOS;
import org.fuin.esmp.DownloadOSFamily;
import org.fuin.esmp.DownloadVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Downloads {
    private static final Logger LOG = LoggerFactory.getLogger(Downloads.class);
    private static final int TIMEOUT_30_SECONDS = 30000;
    private final File jsonDownloadsFile;
    private final List<DownloadVersion> versions;

    public Downloads(URL versionURL, File jsonDownloadsFile) throws IOException {
        this.jsonDownloadsFile = jsonDownloadsFile;
        this.versions = new ArrayList<DownloadVersion>();
        if (!jsonDownloadsFile.exists()) {
            LOG.info("Download version file: " + versionURL);
            FileUtils.copyURLToFile((URL)versionURL, (File)jsonDownloadsFile, (int)30000, (int)30000);
        }
        LOG.info("Local version file: " + jsonDownloadsFile);
    }

    public DownloadVersion findVersion(String name) {
        int idx = this.versions.indexOf(new DownloadVersion(name));
        if (idx < 0) {
            return null;
        }
        return this.versions.get(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parse() throws IOException {
        try (FileReader reader = new FileReader(this.jsonDownloadsFile);){
            JsonReader jsonReader = Json.createReader((Reader)reader);
            JsonObject versionsObj = jsonReader.readObject();
            Iterator versionIt = versionsObj.keySet().iterator();
            while (versionIt.hasNext()) {
                DownloadVersion version = new DownloadVersion((String)versionIt.next());
                this.versions.add(version);
                JsonObject families = versionsObj.getJsonObject(version.getName());
                Iterator familyIt = families.keySet().iterator();
                while (familyIt.hasNext()) {
                    DownloadOSFamily family = new DownloadOSFamily((String)familyIt.next());
                    version.addOSFamily(family);
                    JsonArray downloads = families.getJsonArray(family.getName());
                    for (int i = 0; i < downloads.size(); ++i) {
                        JsonObject download = downloads.getJsonObject(i);
                        String name = download.getString("name");
                        String url = download.getString("url");
                        if (!url.endsWith(".tar.gz") && !url.endsWith(".zip")) continue;
                        family.addOS(new DownloadOS(name, url));
                    }
                }
            }
            for (DownloadVersion version : this.versions) {
                version.seal();
            }
        }
        for (DownloadVersion version : this.versions) {
            LOG.info("{}", (Object)version);
        }
    }

    public final File getJsonDownloadsFile() {
        return this.jsonDownloadsFile;
    }

    public List<DownloadVersion> getVersions() {
        return Collections.unmodifiableList(this.versions);
    }

    public DownloadVersion findLatest(boolean includeRC) {
        for (DownloadVersion version : this.versions) {
            if (!includeRC && !version.isRelease()) continue;
            return version;
        }
        throw new IllegalStateException("No version found");
    }
}

