/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.esmp.DownloadOSFamily;

public final class DownloadVersion
implements Comparable<DownloadVersion> {
    private final String name;
    private final List<DownloadOSFamily> osFamilies;
    private boolean sealed;

    public DownloadVersion(String name) {
        this(name, new ArrayList<DownloadOSFamily>());
    }

    public DownloadVersion(String name, List<DownloadOSFamily> osFamilies) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (osFamilies == null) {
            throw new IllegalArgumentException("osFamilies == null");
        }
        this.name = name;
        this.osFamilies = osFamilies;
    }

    public final String getName() {
        return this.name;
    }

    public final List<DownloadOSFamily> getOSFamilies() {
        return Collections.unmodifiableList(this.osFamilies);
    }

    final void addOSFamily(DownloadOSFamily family) {
        if (this.sealed) {
            throw new IllegalStateException("The instance is sealed");
        }
        this.osFamilies.add(family);
    }

    final void seal() {
        if (this.sealed) {
            return;
        }
        this.sealed = true;
        for (DownloadOSFamily family : this.osFamilies) {
            family.seal();
        }
    }

    public DownloadOSFamily findFamily(String name) {
        int idx = this.osFamilies.indexOf(new DownloadOSFamily(name));
        if (idx < 0) {
            return null;
        }
        return this.osFamilies.get(idx);
    }

    public boolean isRelease() {
        return !this.name.contains("-rc");
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DownloadVersion other = (DownloadVersion)obj;
        return this.name.equals(other.name);
    }

    public final String toString() {
        return this.name;
    }

    @Override
    public final int compareTo(DownloadVersion other) {
        return this.name.compareTo(other.name);
    }
}

