/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.esmp.DownloadOS;

public final class DownloadOSFamily
implements Comparable<DownloadOSFamily> {
    private final String name;
    private final List<DownloadOS> downloads;
    private boolean sealed;

    public DownloadOSFamily(String name) {
        this(name, new ArrayList<DownloadOS>());
    }

    public DownloadOSFamily(String name, List<DownloadOS> downloads) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (downloads == null) {
            throw new IllegalArgumentException("downloads == null");
        }
        this.name = name;
        this.downloads = downloads;
    }

    public final String getName() {
        return this.name;
    }

    public final List<DownloadOS> getDownloads() {
        return Collections.unmodifiableList(this.downloads);
    }

    final void addOS(DownloadOS download) {
        if (this.sealed) {
            throw new IllegalStateException("The instance is sealed");
        }
        this.downloads.add(download);
    }

    final void seal() {
        this.sealed = true;
    }

    public DownloadOS findDownload(String name) {
        int idx = this.downloads.indexOf(new DownloadOS(name));
        if (idx < 0) {
            return null;
        }
        return this.downloads.get(idx);
    }

    public DownloadOS findLatestDownload(String qualifier) {
        for (int i = this.downloads.size() - 1; i >= 0; --i) {
            DownloadOS download = this.downloads.get(i);
            if (qualifier != null && !download.getName().contains(qualifier)) continue;
            return download;
        }
        throw new IllegalStateException("No downloads found for qualifier '" + qualifier + "'");
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DownloadOSFamily other = (DownloadOSFamily)obj;
        return this.name.equals(other.name);
    }

    @Override
    public final int compareTo(DownloadOSFamily other) {
        return this.name.compareTo(other.name);
    }

    public final String toString() {
        return this.name;
    }
}

