/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.fuin.esmp.DownloadOS;
import org.fuin.esmp.DownloadOSFamily;
import org.fuin.esmp.DownloadVersion;
import org.fuin.esmp.Downloads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public abstract class AbstractEventStoreMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventStoreMojo.class);
    private static final String PID_FILE_NAME = "event-store-pid";
    public static final String VERSION_URL = "https://eventstore.org/downloads/downloads.json";
    @Parameter(name="version-url", defaultValue="https://eventstore.org/downloads/downloads.json")
    private String versionUrl = "https://eventstore.org/downloads/downloads.json";
    @Parameter(name="download-url")
    private String downloadUrl;
    @Parameter(name="download-os-qualifier")
    private String downloadOsQualifier;
    @Parameter(name="include-rc", defaultValue="false")
    private String includeRc;
    @Parameter(name="target-dir", property="project.build.directory")
    private File targetDir = new File("./target");
    @Parameter(name="event-store-dir")
    private File eventStoreDir;

    protected final void checkNotNull(String name, Object value) throws MojoExecutionException {
        if (value == null) {
            throw new MojoExecutionException(name + " cannot be null!");
        }
    }

    public final void execute() throws MojoExecutionException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        this.init();
        LOG.info("version-url={}", (Object)this.versionUrl);
        LOG.info("download-url={}", (Object)this.downloadUrl);
        LOG.info("\n        LOG={}", (Object)this.downloadOsQualifier);
        LOG.info("includeRc={}", (Object)this.includeRc);
        LOG.info("target-dir={}", (Object)this.targetDir);
        LOG.info("event-store-dir={}", (Object)this.eventStoreDir);
        this.executeGoal();
    }

    private void init() throws MojoExecutionException {
        if (this.downloadUrl == null) {
            this.initUsingLatest();
        }
        if (this.eventStoreDir == null) {
            if (this.downloadUrl.endsWith(".zip")) {
                this.eventStoreDir = new File(this.canonicalFile(this.targetDir), FilenameUtils.getBaseName((String)this.downloadUrl));
            } else if (this.downloadUrl.endsWith(".tar.gz")) {
                this.eventStoreDir = new File(this.canonicalFile(this.targetDir), FilenameUtils.getBaseName((String)FilenameUtils.getBaseName((String)this.downloadUrl)));
            } else {
                throw new MojoExecutionException("Cannot handle archive with this extension: " + this.downloadUrl);
            }
        }
    }

    private void initDownloadOSQualifier() throws MojoExecutionException {
        if (this.downloadOsQualifier == null) {
            if (OS.isFamilyWindows()) {
                this.downloadOsQualifier = "Windows";
            } else if (OS.isFamilyMac()) {
                this.downloadOsQualifier = "macOS";
            } else if (OS.isFamilyUnix()) {
                this.downloadOsQualifier = "Ubuntu";
            } else {
                throw new MojoExecutionException("Unknown OS - You must use the 'archive-name' parameter");
            }
        }
    }

    private String getOS() throws MojoExecutionException {
        if (OS.isFamilyWindows()) {
            return "Windows";
        }
        if (OS.isFamilyMac()) {
            return "Mac";
        }
        if (OS.isFamilyUnix()) {
            return "Linux";
        }
        throw new MojoExecutionException("Unknown OS - You must use the 'archive-name' parameter");
    }

    private void initUsingLatest() throws MojoExecutionException {
        this.initDownloadOSQualifier();
        try {
            URL versionURL = new URL(this.versionUrl);
            File jsonVersionFile = new File(this.canonicalFile(this.targetDir), "event-store-versions.json");
            Downloads downloads = new Downloads(versionURL, jsonVersionFile);
            downloads.parse();
            String os = this.getOS();
            DownloadVersion version = downloads.findLatest(this.isIncludeRc());
            DownloadOSFamily family = version.findFamily(os);
            if (family == null) {
                throw new MojoExecutionException("Couldn't find OS family '" + os + "' in '" + downloads.getJsonDownloadsFile() + "'");
            }
            DownloadOS download = family.findLatestDownload(this.downloadOsQualifier);
            if (download == null) {
                throw new MojoExecutionException("Couldn't find eyntr with download OS qualifier '" + this.downloadOsQualifier + "' (version='" + version + "', family='" + family + "') in '" + downloads.getJsonDownloadsFile() + "'");
            }
            this.downloadUrl = download.getUrl();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error parsing the event store version file", (Exception)ex);
        }
    }

    private File canonicalFile(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error creating canonical file: " + file, (Exception)ex);
        }
    }

    public final String getDownloadUrl() throws MojoExecutionException {
        if (this.downloadUrl == null) {
            this.init();
        }
        return this.downloadUrl;
    }

    public final void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public final File getEventStoreDir() throws MojoExecutionException {
        if (this.eventStoreDir == null) {
            this.init();
        }
        return this.eventStoreDir;
    }

    public final void setEventStoreDir(File eventStoreDir) {
        this.eventStoreDir = eventStoreDir;
    }

    public final File getTargetDir() {
        return this.targetDir;
    }

    public final void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public String getDownloadOsQualifier() {
        return this.downloadOsQualifier;
    }

    public void setDownloadOsQualifier(String downloadOsQualifier) {
        this.downloadOsQualifier = downloadOsQualifier;
    }

    public String getIncludeRc() {
        return this.includeRc;
    }

    public boolean isIncludeRc() {
        if (this.includeRc == null) {
            return false;
        }
        return Boolean.valueOf(this.includeRc);
    }

    public void setIncludeRc(String includeRc) {
        this.includeRc = includeRc;
    }

    public String getVersionUrl() {
        return this.versionUrl;
    }

    public void setVersionUrl(String versionUrl) {
        this.versionUrl = versionUrl;
    }

    protected final void writePid(String pid) throws MojoExecutionException {
        try {
            FileUtils.write((File)this.getPidFile(), (CharSequence)pid);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Couldn't write the PID '" + pid + "' to file: " + this.getPidFile(), (Exception)ex);
        }
    }

    protected final String readPid() throws MojoExecutionException {
        try {
            return FileUtils.readFileToString((File)this.getPidFile());
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Couldn't read the PID from file: " + this.getPidFile(), (Exception)ex);
        }
    }

    protected final void deletePid() throws MojoExecutionException {
        boolean ok = this.getPidFile().delete();
        if (!ok) {
            throw new MojoExecutionException("Couldn't delete the PID file: " + this.getPidFile());
        }
    }

    protected final File getPidFile() {
        return new File(this.getTargetDir(), PID_FILE_NAME);
    }

    protected final List<String> asList(String str) throws MojoExecutionException {
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            LineNumberReader reader = new LineNumberReader(new StringReader(str));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error creating string list", (Exception)ex);
        }
    }

    protected final void logDebug(List<String> messages) {
        if (LOG.isDebugEnabled()) {
            for (String message : messages) {
                LOG.debug(message);
            }
        }
    }

    protected final void logError(List<String> messages) {
        if (LOG.isErrorEnabled()) {
            for (String message : messages) {
                LOG.error(message);
            }
        }
    }

    protected abstract void executeGoal() throws MojoExecutionException;
}

