/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.devsupwiz.tasks.maven;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.attribute.PosixFilePermission;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.fuin.devsupwiz.common.DevSupWizUtils;
import org.fuin.devsupwiz.common.SetupTask;
import org.fuin.devsupwiz.common.ValidateInstance;
import org.fuin.utils4j.Utils4J;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="create-maven-settings")
public class CreateMavenSettingsTask
implements SetupTask {
    private static final String M2_SETTINGS_XML = ".m2/settings.xml";
    static final String KEY = "create-maven-settings";
    private static final Logger LOG = LoggerFactory.getLogger(CreateMavenSettingsTask.class);
    @NotEmpty
    @XmlAttribute(name="id")
    private String id;
    @NotEmpty(message="{create-maven-settings.template.empty}")
    @XmlAttribute(name="template")
    private @NotEmpty(message="{create-maven-settings.template.empty}") String template;
    @NotEmpty(message="{create-maven-settings.name.empty}")
    @XmlTransient
    private @NotEmpty(message="{create-maven-settings.name.empty}") String name;
    @NotEmpty(message="{create-maven-settings.password.empty}")
    @XmlTransient
    private @NotEmpty(message="{create-maven-settings.password.empty}") String password;
    @NotNull(message="settingsFile==null")
    @XmlTransient
    private @NotNull(message="settingsFile==null") File settingsFile;

    protected CreateMavenSettingsTask() {
        this.settingsFile = new File(Utils4J.getUserHomeDir(), M2_SETTINGS_XML);
    }

    public CreateMavenSettingsTask(@NotEmpty String id, @NotEmpty String template, @NotEmpty String name, @NotEmpty String password) {
        this(id, template, name, password, new File(Utils4J.getUserHomeDir(), M2_SETTINGS_XML));
    }

    public CreateMavenSettingsTask(@NotEmpty String id, @NotEmpty String template, @NotEmpty String name, @NotEmpty String password, @NotNull File settingsFile) {
        this.id = id;
        this.template = template;
        this.name = name;
        this.password = password;
        this.settingsFile = settingsFile;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(@NotEmpty String template) {
        this.template = template;
    }

    public File getTemplateFile() {
        if (this.template == null) {
            throw new IllegalStateException("The template name for the 'settings.xml' is not set");
        }
        File file = new File(StringUtils.replace((String)this.template, (String)"~", (String)Utils4J.getUserHomeDir().toString()));
        if (!file.exists()) {
            throw new IllegalStateException("The template files does not exist: " + file);
        }
        return file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotEmpty String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(@NotEmpty String password) {
        this.password = password;
    }

    public boolean alreadyExecuted() {
        return this.settingsFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValidateInstance
    public void execute() {
        block6: {
            MDC.put((String)"task", (String)this.getTypeId());
            try {
                if (this.alreadyExecuted()) break block6;
                if (!this.settingsFile.getParentFile().exists() && !this.settingsFile.getParentFile().mkdir()) {
                    throw new RuntimeException("Wasn't able to create Maven directory: " + this.settingsFile.getParent());
                }
                try {
                    String str = FileUtils.readFileToString((File)this.getTemplateFile(), (Charset)Charset.forName("utf-8"));
                    String nameReplaced = StringUtils.replace((String)str, (String)"((USER))", (String)this.name);
                    String pwAndNameReplaced = StringUtils.replace((String)nameReplaced, (String)"((PW))", (String)this.password);
                    FileUtils.writeStringToFile((File)this.settingsFile, (String)pwAndNameReplaced, (Charset)Charset.forName("utf-8"));
                    DevSupWizUtils.setFilePermissions((File)this.settingsFile, (PosixFilePermission[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE});
                    LOG.info("Successfully create Maven settings: {}", (Object)this.settingsFile);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Wasn't able to write Maven settings: " + this.settingsFile, ex);
                }
            }
            finally {
                MDC.remove((String)"task");
            }
        }
    }

    public String getResource() {
        return this.getClass().getPackage().getName().replace('.', '/') + "/" + KEY;
    }

    public String getFxml() {
        return "/" + this.getResource() + ".fxml";
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return KEY;
    }

    public String getTypeId() {
        return this.getType() + "[" + this.getId() + "]";
    }
}

