/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.devsupwiz.tasks.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.Decorator;
import org.controlsfx.control.decoration.GraphicDecoration;
import org.fuin.devsupwiz.common.DevSupWizFxUtils;
import org.fuin.devsupwiz.common.DevSupWizUtils;
import org.fuin.devsupwiz.common.Loggable;
import org.fuin.devsupwiz.common.SetupController;
import org.fuin.devsupwiz.common.SetupTask;
import org.fuin.devsupwiz.tasks.maven.CreateMavenSettingsTask;

@Loggable
public class CreateMavenSettingsController
implements SetupController {
    @FXML
    private TextField name;
    @FXML
    private PasswordField password;
    @FXML
    private Label title;
    @Inject
    private Validator validator;
    private CreateMavenSettingsTask task;

    public void init(SetupTask task) {
        if (!(task instanceof CreateMavenSettingsTask)) {
            throw new IllegalArgumentException("Expected task of type " + CreateMavenSettingsTask.class.getName() + ", but was: " + task.getClass().getName());
        }
        this.task = (CreateMavenSettingsTask)task;
        this.refreshStatus();
    }

    public List<String> getValidationErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.task.alreadyExecuted()) {
            CreateMavenSettingsTask t = new CreateMavenSettingsTask("x", "y", (String)this.name.textProperty().get(), (String)this.password.textProperty().get());
            Set violations = this.validator.validate((Object)t, new Class[0]);
            for (ConstraintViolation violation : violations) {
                errors.add(violation.getMessage());
            }
            Decorator.removeAllDecorations((Node)this.name);
            if (DevSupWizUtils.violated((Set)violations, (String)this.name.getId())) {
                Decorator.addDecoration((Node)this.name, (Decoration)new GraphicDecoration((Node)DevSupWizFxUtils.createIconError16x16(), Pos.TOP_RIGHT));
            }
            Decorator.removeAllDecorations((Node)this.password);
            if (DevSupWizUtils.violated((Set)violations, (String)this.password.getId())) {
                Decorator.addDecoration((Node)this.password, (Decoration)new GraphicDecoration((Node)DevSupWizFxUtils.createIconError16x16(), Pos.TOP_RIGHT));
            }
        }
        return errors;
    }

    public void save() {
        this.task.setName(this.name.getText());
        this.task.setPassword(this.password.getText());
    }

    public SetupTask getTask() {
        return this.task;
    }

    public void refreshStatus() {
        boolean alreadyExecuted = this.task.alreadyExecuted();
        this.name.setDisable(alreadyExecuted);
        this.password.setDisable(alreadyExecuted);
        if (alreadyExecuted) {
            this.title.setGraphic((Node)DevSupWizFxUtils.createIconOk24x24());
        } else {
            this.title.setGraphic((Node)DevSupWizFxUtils.createIconTodo24x24());
        }
    }
}

