/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.devsupwiz.tasks.gitsetup;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.fuin.devsupwiz.common.LogOutputStream;
import org.fuin.devsupwiz.common.SetupTask;
import org.fuin.devsupwiz.common.ShellCommandExecutor;
import org.fuin.devsupwiz.common.ValidateInstance;
import org.fuin.utils4j.Utils4J;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.event.Level;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="git-clone")
public class GitCloneTask
implements SetupTask {
    static final String KEY = "git-clone";
    private static final Logger LOG = LoggerFactory.getLogger(GitCloneTask.class);
    @NotEmpty
    @XmlAttribute(name="id")
    private String id;
    @NotEmpty(message="target-dir")
    @XmlAttribute(name="target-dir")
    private @NotEmpty(message="target-dir") String targetDir;
    @XmlElement(name="repository")
    private List<String> repositories;
    @XmlTransient
    private Preferences userPrefs;

    protected GitCloneTask() {
        this.userPrefs = Preferences.userRoot();
    }

    public GitCloneTask(@NotEmpty String id, @NotEmpty String targetDir, @NotNull List<String> repositories) {
        this.id = id;
        this.targetDir = targetDir;
        this.repositories = new ArrayList<String>(repositories);
        this.userPrefs = Preferences.userRoot();
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public File getTargetDirFile() {
        if (this.targetDir == null) {
            return new File(Utils4J.getUserHomeDir(), "git");
        }
        String dir = StringUtils.replace((String)this.targetDir, (String)"~", (String)Utils4J.getUserHomeDir().toString());
        return new File(dir);
    }

    public void setTargetDir(@NotEmpty String targetDir) {
        this.targetDir = targetDir;
    }

    public List<String> getRepositories() {
        if (this.repositories == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.repositories);
    }

    public boolean alreadyExecuted() {
        return this.userPrefs.getBoolean(this.getPrefKey(), false);
    }

    private String getPrefKey() {
        return this.getType() + "-" + this.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValidateInstance
    public void execute() {
        block7: {
            MDC.put((String)"task", (String)this.getTypeId());
            try {
                if (this.alreadyExecuted()) break block7;
                if (!this.getTargetDirFile().exists()) {
                    this.getTargetDirFile().mkdirs();
                }
                for (String repository : this.repositories) {
                    ShellCommandExecutor executor = new ShellCommandExecutor("git clone -v " + repository, 120L, new HashMap(), (OutputStream)new LogOutputStream(Level.INFO), (OutputStream)new LogOutputStream(Level.ERROR), this.getTargetDirFile());
                    int result = executor.execute();
                    if (result == 0) continue;
                    throw new RuntimeException("Failed to clone " + repository + ": " + result);
                }
                try {
                    this.userPrefs.putBoolean(this.getPrefKey(), true);
                    this.userPrefs.flush();
                }
                catch (BackingStoreException ex) {
                    throw new RuntimeException("Failed to save the setup key '" + this.getPrefKey() + "'", ex);
                }
                LOG.info("Successfully finished SSH git setup");
            }
            finally {
                MDC.remove((String)"task");
            }
        }
    }

    public String getResource() {
        return this.getClass().getPackage().getName().replace('.', '/') + "/" + KEY;
    }

    public String getFxml() {
        return "/" + this.getResource() + ".fxml";
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return KEY;
    }

    public String getTypeId() {
        return this.getType() + "[" + this.getId() + "]";
    }
}

